/*
 * Decompiled with CFR 0.152.
 */
package bluej.parser;

import antlr.ASTFactory;
import antlr.RecognitionException;
import antlr.TokenStreamException;
import antlr.collections.AST;
import bluej.parser.SourceLocation;
import bluej.parser.SourceSpan;
import bluej.parser.ast.JavaAnalyzer;
import bluej.parser.ast.LocatableAST;
import bluej.parser.ast.gen.UnitTestParser;
import java.io.Reader;
import java.util.LinkedList;
import java.util.List;

public class UnitTestAnalyzer {
    private boolean parsedOk;
    private AST rootAST;
    private LocatableAST unitTestAST;

    public UnitTestAnalyzer(Reader r) {
        JavaAnalyzer ja = null;
        this.parsedOk = false;
        try {
            ja = new JavaAnalyzer(r);
        }
        catch (RecognitionException re) {
            re.printStackTrace();
        }
        catch (TokenStreamException tse) {
            tse.printStackTrace();
        }
        this.rootAST = new ASTFactory().create(0, "AST ROOT");
        UnitTestParser tparse = new UnitTestParser();
        tparse.setASTNodeClass("bluej.parser.ast.LocatableAST");
        try {
            tparse.compilationUnit(ja.getAST());
        }
        catch (RecognitionException e) {
            e.printStackTrace();
        }
        this.rootAST.setFirstChild(tparse.getAST());
        this.unitTestAST = this.findUnitTestClass();
        if (this.unitTestAST != null) {
            this.parsedOk = true;
        }
    }

    private LocatableAST findUnitTestClass() {
        for (LocatableAST firstClass = (LocatableAST)this.rootAST.getFirstChild(); firstClass != null; firstClass = (LocatableAST)firstClass.getNextSibling()) {
            LocatableAST rightCurly;
            LocatableAST leftCurly = (LocatableAST)firstClass.getFirstChild();
            if (leftCurly == null || (rightCurly = (LocatableAST)leftCurly.getNextSibling()) == null) continue;
            LocatableAST modifiers = (LocatableAST)rightCurly.getNextSibling();
            LocatableAST modifierTokens = (LocatableAST)modifiers.getFirstChild();
            while (modifierTokens != null) {
                if (!modifierTokens.getText().equals("public")) continue;
                return firstClass;
            }
        }
        return null;
    }

    private LocatableAST findUnitTestOpeningBracket() {
        return (LocatableAST)this.unitTestAST.getFirstChild();
    }

    private LocatableAST findUnitTestClosingBracket() {
        return (LocatableAST)this.unitTestAST.getFirstChild().getNextSibling();
    }

    private LocatableAST findUnitTestObjectBlock() {
        for (LocatableAST childAST = (LocatableAST)this.unitTestAST.getFirstChild().getNextSibling().getNextSibling(); childAST != null; childAST = (LocatableAST)childAST.getNextSibling()) {
            if (childAST.getType() != 6) continue;
            return childAST;
        }
        return null;
    }

    public List getFieldSpans() {
        LinkedList<SourceSpan> l = new LinkedList<SourceSpan>();
        for (LocatableAST childAST = (LocatableAST)this.findUnitTestObjectBlock().getFirstChild(); childAST != null; childAST = (LocatableAST)childAST.getNextSibling()) {
            if (childAST.getType() != 10) continue;
            LocatableAST startSibling = null;
            LocatableAST endSibling = null;
            startSibling = (LocatableAST)childAST.getFirstChild();
            if (startSibling != null) {
                endSibling = (LocatableAST)startSibling.getNextSibling();
                while (startSibling.getFirstChild() != null) {
                    startSibling = (LocatableAST)startSibling.getFirstChild();
                }
            }
            if (startSibling == null || endSibling == null) continue;
            l.add(new SourceSpan(new SourceLocation(startSibling.getLine(), startSibling.getColumn()), new SourceLocation(endSibling.getLine(), endSibling.getColumn())));
        }
        return l;
    }

    public SourceSpan getMethodBlockSpan(String methodName) {
        for (LocatableAST childAST = (LocatableAST)this.findUnitTestObjectBlock().getFirstChild(); childAST != null; childAST = (LocatableAST)childAST.getNextSibling()) {
            LocatableAST closeBracketAST;
            LocatableAST openBracketAST;
            LocatableAST parameterAST;
            if (childAST.getType() != 9) continue;
            LocatableAST nameAST = null;
            nameAST = (LocatableAST)childAST.getFirstChild();
            if (nameAST == null || !nameAST.getText().equals(methodName) || (parameterAST = (LocatableAST)nameAST.getFirstChild()).getFirstChild() != null || (openBracketAST = (LocatableAST)nameAST.getNextSibling()) == null || (closeBracketAST = (LocatableAST)openBracketAST.getNextSibling()) == null) continue;
            return new SourceSpan(new SourceLocation(openBracketAST.getLine(), openBracketAST.getColumn()), new SourceLocation(closeBracketAST.getLine(), closeBracketAST.getColumn()));
        }
        return null;
    }

    public SourceLocation getFixtureInsertLocation() {
        LocatableAST a = this.findUnitTestOpeningBracket();
        return new SourceLocation(a.getLine(), a.getColumn());
    }

    public SourceLocation getNewMethodInsertLocation() {
        LocatableAST a = this.findUnitTestClosingBracket();
        return new SourceLocation(a.getLine(), a.getColumn());
    }
}

