/*
 * Decompiled with CFR 0.152.
 */
package bluej.parser;

import antlr.CommonHiddenStreamToken;
import antlr.LLkParser;
import antlr.NoViableAltException;
import antlr.ParserSharedInputState;
import antlr.RecognitionException;
import antlr.SemanticException;
import antlr.Token;
import antlr.TokenBuffer;
import antlr.TokenStream;
import antlr.TokenStreamException;
import antlr.TokenStreamHiddenTokenFilter;
import antlr.collections.impl.BitSet;
import bluej.parser.JavaBitSet;
import bluej.parser.JavaLexer;
import bluej.parser.JavaToken;
import bluej.parser.JavaTokenTypes;
import bluej.parser.symtab.ClassInfo;
import bluej.parser.symtab.DummyClass;
import bluej.parser.symtab.JavaVector;
import bluej.parser.symtab.Selection;
import bluej.parser.symtab.SymbolTable;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.Iterator;
import java.util.Vector;

public class ClassParser
extends LLkParser
implements JavaTokenTypes {
    static final int BODY = 1;
    static final int CLASS_INIT = 2;
    static final int INSTANCE_INIT = 3;
    static final int NEW_SCOPE = 4;
    static final int MOD_PRIVATE = 0;
    static final int MOD_PUBLIC = 1;
    static final int MOD_PROTECTED = 2;
    static final int MOD_STATIC = 3;
    static final int MOD_ABSTRACT = 4;
    private SymbolTable symbolTable;
    private TokenStreamHiddenTokenFilter filter;
    private ClassInfo info;
    private int ltCounter = 0;
    public static final String[] _tokenNames = new String[]{"<0>", "EOF", "<2>", "NULL_TREE_LOOKAHEAD", "BLOCK", "MODIFIERS", "OBJBLOCK", "SLIST", "CTOR_DEF", "METHOD_DEF", "VARIABLE_DEF", "INSTANCE_INIT", "STATIC_INIT", "TYPE", "CLASS_DEF", "INTERFACE_DEF", "PACKAGE_DEF", "ARRAY_DECLARATOR", "EXTENDS_CLAUSE", "IMPLEMENTS_CLAUSE", "PARAMETERS", "PARAMETER_DEF", "LABELED_STAT", "TYPECAST", "INDEX_OP", "POST_INC", "POST_DEC", "METHOD_CALL", "EXPR", "ARRAY_INIT", "IMPORT", "UNARY_MINUS", "UNARY_PLUS", "CASE_GROUP", "ELIST", "FOR_INIT", "FOR_CONDITION", "FOR_ITERATOR", "EMPTY_STAT", "\"final\"", "\"abstract\"", "\"strictfp\"", "SUPER_CTOR_CALL", "CTOR_CALL", "\"package\"", "SEMI", "\"import\"", "\"static\"", "LBRACK", "RBRACK", "IDENT", "DOT", "LT", "COMMA", "QUESTION", "\"extends\"", "\"super\"", "GT", "SR", "BSR", "\"void\"", "\"boolean\"", "\"byte\"", "\"char\"", "\"short\"", "\"int\"", "\"float\"", "\"long\"", "\"double\"", "STAR", "\"private\"", "\"public\"", "\"protected\"", "\"transient\"", "\"native\"", "\"threadsafe\"", "\"synchronized\"", "\"volatile\"", "\"class\"", "\"interface\"", "\"enum\"", "AT", "BAND", "LCURLY", "RCURLY", "LPAREN", "RPAREN", "\"default\"", "\"implements\"", "\"this\"", "ASSIGN", "\"throws\"", "ELLIPSES", "COLON", "\"if\"", "\"else\"", "\"for\"", "\"while\"", "\"do\"", "\"break\"", "\"continue\"", "\"return\"", "\"switch\"", "\"throw\"", "\"assert\"", "\"case\"", "\"try\"", "\"finally\"", "\"catch\"", "PLUS_ASSIGN", "MINUS_ASSIGN", "STAR_ASSIGN", "DIV_ASSIGN", "MOD_ASSIGN", "SR_ASSIGN", "BSR_ASSIGN", "SL_ASSIGN", "BAND_ASSIGN", "BXOR_ASSIGN", "BOR_ASSIGN", "LOR", "LAND", "BOR", "BXOR", "NOT_EQUAL", "EQUAL", "LE", "GE", "\"instanceof\"", "SL", "PLUS", "MINUS", "DIV", "MOD", "INC", "DEC", "BNOT", "LNOT", "\"true\"", "\"false\"", "\"null\"", "\"new\"", "NUM_INT", "CHAR_LITERAL", "STRING_LITERAL", "NUM_FLOAT", "NUM_LONG", "NUM_DOUBLE", "WS", "SL_COMMENT", "ML_COMMENT", "ESC", "HEX_DIGIT", "EXPONENT", "FLOAT_SUFFIX"};
    public static final BitSet _tokenSet_0 = new BitSet(ClassParser.mk_tokenSet_0());
    public static final BitSet _tokenSet_1 = new BitSet(ClassParser.mk_tokenSet_1());
    public static final BitSet _tokenSet_2 = new BitSet(ClassParser.mk_tokenSet_2());
    public static final BitSet _tokenSet_3 = new BitSet(ClassParser.mk_tokenSet_3());
    public static final BitSet _tokenSet_4 = new BitSet(ClassParser.mk_tokenSet_4());
    public static final BitSet _tokenSet_5 = new BitSet(ClassParser.mk_tokenSet_5());
    public static final BitSet _tokenSet_6 = new BitSet(ClassParser.mk_tokenSet_6());
    public static final BitSet _tokenSet_7 = new BitSet(ClassParser.mk_tokenSet_7());
    public static final BitSet _tokenSet_8 = new BitSet(ClassParser.mk_tokenSet_8());
    public static final BitSet _tokenSet_9 = new BitSet(ClassParser.mk_tokenSet_9());
    public static final BitSet _tokenSet_10 = new BitSet(ClassParser.mk_tokenSet_10());
    public static final BitSet _tokenSet_11 = new BitSet(ClassParser.mk_tokenSet_11());
    public static final BitSet _tokenSet_12 = new BitSet(ClassParser.mk_tokenSet_12());
    public static final BitSet _tokenSet_13 = new BitSet(ClassParser.mk_tokenSet_13());
    public static final BitSet _tokenSet_14 = new BitSet(ClassParser.mk_tokenSet_14());
    public static final BitSet _tokenSet_15 = new BitSet(ClassParser.mk_tokenSet_15());
    public static final BitSet _tokenSet_16 = new BitSet(ClassParser.mk_tokenSet_16());
    public static final BitSet _tokenSet_17 = new BitSet(ClassParser.mk_tokenSet_17());
    public static final BitSet _tokenSet_18 = new BitSet(ClassParser.mk_tokenSet_18());
    public static final BitSet _tokenSet_19 = new BitSet(ClassParser.mk_tokenSet_19());
    public static final BitSet _tokenSet_20 = new BitSet(ClassParser.mk_tokenSet_20());
    public static final BitSet _tokenSet_21 = new BitSet(ClassParser.mk_tokenSet_21());
    public static final BitSet _tokenSet_22 = new BitSet(ClassParser.mk_tokenSet_22());
    public static final BitSet _tokenSet_23 = new BitSet(ClassParser.mk_tokenSet_23());
    public static final BitSet _tokenSet_24 = new BitSet(ClassParser.mk_tokenSet_24());
    public static final BitSet _tokenSet_25 = new BitSet(ClassParser.mk_tokenSet_25());
    public static final BitSet _tokenSet_26 = new BitSet(ClassParser.mk_tokenSet_26());
    public static final BitSet _tokenSet_27 = new BitSet(ClassParser.mk_tokenSet_27());
    public static final BitSet _tokenSet_28 = new BitSet(ClassParser.mk_tokenSet_28());
    public static final BitSet _tokenSet_29 = new BitSet(ClassParser.mk_tokenSet_29());
    public static final BitSet _tokenSet_30 = new BitSet(ClassParser.mk_tokenSet_30());
    public static final BitSet _tokenSet_31 = new BitSet(ClassParser.mk_tokenSet_31());
    public static final BitSet _tokenSet_32 = new BitSet(ClassParser.mk_tokenSet_32());
    public static final BitSet _tokenSet_33 = new BitSet(ClassParser.mk_tokenSet_33());
    public static final BitSet _tokenSet_34 = new BitSet(ClassParser.mk_tokenSet_34());
    public static final BitSet _tokenSet_35 = new BitSet(ClassParser.mk_tokenSet_35());
    public static final BitSet _tokenSet_36 = new BitSet(ClassParser.mk_tokenSet_36());
    public static final BitSet _tokenSet_37 = new BitSet(ClassParser.mk_tokenSet_37());
    public static final BitSet _tokenSet_38 = new BitSet(ClassParser.mk_tokenSet_38());
    public static final BitSet _tokenSet_39 = new BitSet(ClassParser.mk_tokenSet_39());
    public static final BitSet _tokenSet_40 = new BitSet(ClassParser.mk_tokenSet_40());
    public static final BitSet _tokenSet_41 = new BitSet(ClassParser.mk_tokenSet_41());
    public static final BitSet _tokenSet_42 = new BitSet(ClassParser.mk_tokenSet_42());
    public static final BitSet _tokenSet_43 = new BitSet(ClassParser.mk_tokenSet_43());

    public static ClassInfo parse(String filename) throws Exception {
        return ClassParser.parse(filename, null);
    }

    public static ClassInfo parse(File file) throws Exception {
        return ClassParser.parse(file, null);
    }

    public static ClassInfo parse(String filename, Vector classes) throws Exception {
        return ClassParser.parse(new File(filename), classes);
    }

    public static ClassInfo parse(File file, Vector classes) throws Exception {
        SymbolTable symbolTable = new SymbolTable();
        ClassInfo info = new ClassInfo();
        ClassParser.doFile(file, symbolTable, info);
        if (classes != null) {
            symbolTable.addClasses(classes);
        }
        symbolTable.getInfo(info);
        return info;
    }

    private static void doFile(File f, SymbolTable symbolTable, ClassInfo info) throws Exception {
        if (f.isDirectory()) {
            throw new Exception("Attempt to parse directory");
        }
        if (f.getName().endsWith(".java")) {
            symbolTable.setFile(f);
            ClassParser.parseFile(new BufferedReader(new FileReader(f)), symbolTable, info);
        }
    }

    private static void parseFile(Reader r, SymbolTable symbolTable, ClassInfo info) throws Exception {
        JavaLexer lexer = new JavaLexer(r);
        lexer.setTokenObjectClass("bluej.parser.JavaToken");
        TokenStreamHiddenTokenFilter filter = new TokenStreamHiddenTokenFilter((TokenStream)lexer);
        filter.hide(150);
        ClassParser parser = new ClassParser((TokenStream)filter);
        parser.setSymbolTable(symbolTable);
        parser.setClassInfo(info);
        parser.setFilter(filter);
        parser.compilationUnit();
        r.close();
    }

    public void setSymbolTable(SymbolTable symbolTable) {
        this.symbolTable = symbolTable;
    }

    public void setClassInfo(ClassInfo info) {
        this.info = info;
    }

    public void setFilter(TokenStreamHiddenTokenFilter filter) {
        this.filter = filter;
    }

    public void reportError(RecognitionException ex) {
    }

    public JavaToken findAttachedComment(JavaToken startToken) {
        CommonHiddenStreamToken ctok = null;
        if (startToken == null || (ctok = this.filter.getHiddenBefore((CommonHiddenStreamToken)startToken)) != null) {
            // empty if block
        }
        return (JavaToken)ctok;
    }

    public void popScope() {
        this.symbolTable.popScope();
    }

    public void endFile() {
        this.symbolTable.popAllScopes();
    }

    public void defineBlock(JavaToken tok) {
        this.symbolTable.defineBlock(tok);
    }

    public void definePackage(JavaToken t) {
        this.symbolTable.definePackage(t);
    }

    public void defineLabel(JavaToken t) {
        this.symbolTable.defineLabel(t);
    }

    public void useDefaultPackage() {
        this.symbolTable.useDefaultPackage();
    }

    public void reference(JavaToken t) {
        this.symbolTable.reference(t);
    }

    public void setNearestClassScope() {
        this.symbolTable.setNearestClassScope();
    }

    public void endMethodHead(JavaVector exceptions) {
        this.symbolTable.endMethodHead(exceptions);
    }

    public DummyClass dummyClass(JavaToken theClass) {
        return this.symbolTable.getDummyClass(theClass);
    }

    public void defineClass(JavaToken theClass, JavaToken superClass, JavaVector interfaces, boolean isAbstract, boolean isPublic, boolean isEnum, JavaToken comment, Selection extendsInsert, Selection implementsInsert, Selection extendsReplace, Selection superReplace, Selection typeParameterTextSelection, Vector typeParameterSelections, Vector interfaceSelections) {
        this.symbolTable.defineClass(theClass, superClass, interfaces, isAbstract, isPublic, isEnum, comment, extendsInsert, implementsInsert, extendsReplace, superReplace, typeParameterTextSelection, typeParameterSelections, interfaceSelections);
    }

    public void defineInterface(JavaToken theInterface, JavaVector superInterfaces, boolean isPublic, JavaToken comment, Selection extendsInsert, Selection typeParameterTextSelection, Vector typeParameterSelections, Vector superInterfaceSelections) {
        this.symbolTable.defineInterface(theInterface, superInterfaces, isPublic, comment, extendsInsert, typeParameterTextSelection, typeParameterSelections, superInterfaceSelections);
    }

    public void defineVar(JavaToken theVariable, JavaToken type, boolean isVarargs, JavaToken comment) {
        this.symbolTable.defineVar(theVariable, type, isVarargs, comment);
    }

    public void defineMethod(JavaToken theMethod, JavaToken type, JavaToken comment, Selection typeParameterText) {
        this.symbolTable.defineMethod(theMethod, type, comment, typeParameterText);
    }

    public void addImport(JavaToken id, String className, String packageName) {
        this.symbolTable.addImport(id, className, packageName);
    }

    public Selection selectionAfterToken(JavaToken id) {
        return new Selection(id.getFile(), id.getLine(), id.getColumn() + id.getText().length());
    }

    public Selection nextSelection(Selection sel) {
        return new Selection(sel.getFile(), sel.getLine(), sel.getColumn() + sel.getText().length());
    }

    protected ClassParser(TokenBuffer tokenBuf, int k) {
        super(tokenBuf, k);
        this.tokenNames = _tokenNames;
    }

    public ClassParser(TokenBuffer tokenBuf) {
        this(tokenBuf, 2);
    }

    protected ClassParser(TokenStream lexer, int k) {
        super(lexer, k);
        this.tokenNames = _tokenNames;
    }

    public ClassParser(TokenStream lexer) {
        this(lexer, 2);
    }

    public ClassParser(ParserSharedInputState state) {
        super(state, 2);
        this.tokenNames = _tokenNames;
    }

    public final void compilationUnit() throws RecognitionException, TokenStreamException {
        boolean synPredMatched4 = false;
        if ((this.LA(1) == 44 || this.LA(1) == 81) && this.LA(2) == 50) {
            int _m4 = this.mark();
            synPredMatched4 = true;
            ++this.inputState.guessing;
            try {
                this.packageDefinition();
            }
            catch (RecognitionException pe) {
                synPredMatched4 = false;
            }
            this.rewind(_m4);
            --this.inputState.guessing;
        }
        if (synPredMatched4) {
            this.packageDefinition();
        } else if (_tokenSet_0.member(this.LA(1)) && _tokenSet_1.member(this.LA(2))) {
            if (this.inputState.guessing == 0) {
                this.useDefaultPackage();
            }
        } else {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        while (this.LA(1) == 46) {
            this.importDefinition();
        }
        while (_tokenSet_2.member(this.LA(1))) {
            this.typeDefinition();
        }
        this.match(1);
        if (this.inputState.guessing == 0) {
            this.endFile();
        }
    }

    public final void packageDefinition() throws RecognitionException, TokenStreamException {
        Token pkg = null;
        Token sem = null;
        try {
            while (this.LA(1) == 81) {
                this.annotation();
            }
            pkg = this.LT(1);
            this.match(44);
            JavaToken id = this.identifier();
            sem = this.LT(1);
            this.match(45);
            if (this.inputState.guessing == 0) {
                this.info.setPackageSelections(new Selection((JavaToken)pkg), new Selection(id), id.getText(), new Selection((JavaToken)sem));
                this.definePackage(id);
            }
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.consume();
                this.consumeUntil(_tokenSet_0);
            }
            throw ex;
        }
    }

    public final void importDefinition() throws RecognitionException, TokenStreamException {
        try {
            this.match(46);
            switch (this.LA(1)) {
                case 47: {
                    this.match(47);
                    break;
                }
                case 50: {
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            this.identifierStar();
            this.match(45);
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.consume();
                this.consumeUntil(_tokenSet_0);
            }
            throw ex;
        }
    }

    public final void typeDefinition() throws RecognitionException, TokenStreamException {
        JavaToken commentToken = null;
        try {
            block1 : switch (this.LA(1)) {
                case 39: 
                case 40: 
                case 41: 
                case 47: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: {
                    if (this.inputState.guessing == 0) {
                        commentToken = this.findAttachedComment((JavaToken)this.LT(1));
                    }
                    JavaBitSet mods = this.modifiers();
                    switch (this.LA(1)) {
                        case 78: {
                            this.classDefinition(mods, commentToken);
                            break block1;
                        }
                        case 79: {
                            this.interfaceDefinition(mods, commentToken);
                            break block1;
                        }
                        case 80: {
                            this.enumDefinition(mods, commentToken);
                            break block1;
                        }
                        case 81: {
                            this.annotationTypeDeclaration();
                            break block1;
                        }
                    }
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
                case 45: {
                    this.match(45);
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
        }
        catch (RecognitionException ex) {
            if (this.inputState.guessing == 0) {
                this.reportError(ex);
                this.consume();
                this.consumeUntil(_tokenSet_3);
            }
            throw ex;
        }
    }

    protected final void annotation() throws RecognitionException, TokenStreamException {
        this.match(81);
        this.annTypeName();
        if (this.LA(1) == 85 && this.LA(2) == 86) {
            this.match(85);
            this.match(86);
        } else {
            boolean synPredMatched265 = false;
            if (this.LA(1) == 85 && this.LA(2) == 50) {
                int _m265 = this.mark();
                synPredMatched265 = true;
                ++this.inputState.guessing;
                try {
                    this.match(85);
                    this.match(50);
                    this.match(90);
                }
                catch (RecognitionException pe) {
                    synPredMatched265 = false;
                }
                this.rewind(_m265);
                --this.inputState.guessing;
            }
            if (synPredMatched265) {
                this.match(85);
                this.annMemberValuePair();
                while (this.LA(1) == 53) {
                    this.match(53);
                    this.annMemberValuePair();
                }
                this.match(86);
            } else if (this.LA(1) == 85 && _tokenSet_4.member(this.LA(2))) {
                this.match(85);
                this.annMemberValue();
                this.match(86);
            } else if (!_tokenSet_5.member(this.LA(1))) {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
    }

    public final JavaToken identifier() throws RecognitionException, TokenStreamException {
        Token id1 = null;
        Token id2 = null;
        JavaToken t = null;
        id1 = this.LT(1);
        this.match(50);
        if (this.inputState.guessing == 0) {
            t = (JavaToken)id1;
        }
        while (this.LA(1) == 51) {
            this.match(51);
            id2 = this.LT(1);
            this.match(50);
            if (this.inputState.guessing != 0) continue;
            t.setText(t.getText() + "." + id2.getText());
        }
        return t;
    }

    public final void identifierStar() throws RecognitionException, TokenStreamException {
        Token id = null;
        Token id2 = null;
        String className = "";
        String packageName = "";
        id = this.LT(1);
        this.match(50);
        if (this.inputState.guessing == 0) {
            className = id.getText();
        }
        while (this.LA(1) == 51 && this.LA(2) == 50) {
            this.match(51);
            id2 = this.LT(1);
            this.match(50);
            if (this.inputState.guessing != 0) continue;
            packageName = packageName + "." + className;
            className = id2.getText();
        }
        switch (this.LA(1)) {
            case 51: {
                this.match(51);
                this.match(69);
                if (this.inputState.guessing != 0) break;
                packageName = packageName + "." + className;
                className = null;
                break;
            }
            case 45: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        if (this.inputState.guessing == 0) {
            if (packageName.equals("")) {
                id.setText(className);
            } else if (className == null) {
                id.setText(packageName.substring(1));
            } else {
                id.setText(packageName.substring(1) + "." + className);
            }
            this.addImport((JavaToken)id, className, packageName);
        }
    }

    public final JavaBitSet modifiers() throws RecognitionException, TokenStreamException {
        JavaBitSet mods = new JavaBitSet();
        while (true) {
            if (_tokenSet_6.member(this.LA(1)) && _tokenSet_7.member(this.LA(2))) {
                this.modifier(mods);
                continue;
            }
            if (this.LA(1) != 81 || this.LA(2) != 50) break;
            this.annotation();
        }
        return mods;
    }

    public final void classDefinition(JavaBitSet mods, JavaToken commentToken) throws RecognitionException, TokenStreamException {
        Token id = null;
        Token ex = null;
        JavaToken superClass = null;
        JavaVector interfaces = new JavaVector();
        Vector interfaceSelections = new Vector();
        Vector typeParameterSelections = new Vector();
        Selection extendsInsert = null;
        Selection implementsInsert = null;
        Selection extendsReplace = null;
        Selection superReplace = null;
        Selection typeParameterTextSelection = null;
        Vector typeArguments = new Vector();
        this.match(78);
        id = this.LT(1);
        this.match(50);
        switch (this.LA(1)) {
            case 52: {
                typeParameterTextSelection = this.typeParameters(typeParameterSelections);
                break;
            }
            case 55: 
            case 83: 
            case 88: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        if (this.inputState.guessing == 0) {
            Selection lastTypeParamSelection = null;
            if (!typeParameterSelections.isEmpty()) {
                lastTypeParamSelection = (Selection)typeParameterSelections.lastElement();
                extendsInsert = implementsInsert = this.nextSelection(lastTypeParamSelection);
            } else {
                extendsInsert = implementsInsert = this.selectionAfterToken((JavaToken)id);
            }
        }
        switch (this.LA(1)) {
            case 55: {
                ex = this.LT(1);
                this.match(55);
                superClass = this.classOrInterfaceType(false, typeArguments);
                if (this.inputState.guessing != 0) break;
                extendsReplace = new Selection((JavaToken)ex);
                superReplace = new Selection(superClass);
                if (!typeArguments.isEmpty()) {
                    Iterator it = typeArguments.iterator();
                    while (it.hasNext()) {
                        superReplace.addToken((JavaToken)((Object)it.next()));
                    }
                }
                if (!typeArguments.isEmpty()) {
                    JavaToken lastArg = (JavaToken)((Object)typeArguments.lastElement());
                    implementsInsert = this.selectionAfterToken(lastArg);
                    break;
                }
                implementsInsert = this.selectionAfterToken(superClass);
                break;
            }
            case 83: 
            case 88: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        switch (this.LA(1)) {
            case 88: {
                implementsInsert = this.implementsClause(interfaces, interfaceSelections);
                break;
            }
            case 83: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        if (this.inputState.guessing == 0) {
            this.defineClass((JavaToken)id, superClass, interfaces, mods.get(4), mods.get(1), false, commentToken, extendsInsert, implementsInsert, extendsReplace, superReplace, typeParameterTextSelection, typeParameterSelections, interfaceSelections);
        }
        this.classBlock();
        if (this.inputState.guessing == 0) {
            this.popScope();
        }
    }

    public final void interfaceDefinition(JavaBitSet mods, JavaToken commentToken) throws RecognitionException, TokenStreamException {
        Token id = null;
        JavaVector superInterfaces = new JavaVector();
        Vector superInterfaceSelections = new Vector();
        Vector typeParameterSelections = new Vector();
        Selection extendsInsert = null;
        Selection typeParameterTextSelection = null;
        this.match(79);
        id = this.LT(1);
        this.match(50);
        switch (this.LA(1)) {
            case 52: {
                typeParameterTextSelection = this.typeParameters(typeParameterSelections);
                break;
            }
            case 55: 
            case 83: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        if (this.inputState.guessing == 0) {
            Selection lastTypeParamSelection = null;
            if (!typeParameterSelections.isEmpty()) {
                lastTypeParamSelection = (Selection)typeParameterSelections.lastElement();
                extendsInsert = this.nextSelection(lastTypeParamSelection);
            } else {
                extendsInsert = this.selectionAfterToken((JavaToken)id);
            }
        }
        switch (this.LA(1)) {
            case 55: {
                extendsInsert = this.interfaceExtends(superInterfaces, superInterfaceSelections);
                break;
            }
            case 83: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        if (this.inputState.guessing == 0) {
            this.defineInterface((JavaToken)id, superInterfaces, mods.get(1), commentToken, extendsInsert, typeParameterTextSelection, typeParameterSelections, superInterfaceSelections);
        }
        this.classBlock();
        if (this.inputState.guessing == 0) {
            this.popScope();
        }
    }

    public final void enumDefinition(JavaBitSet mods, JavaToken commentToken) throws RecognitionException, TokenStreamException {
        Token id = null;
        JavaToken superClass = null;
        JavaVector interfaces = new JavaVector();
        Vector interfaceSelections = new Vector();
        Selection implementsInsert = null;
        this.match(80);
        id = this.LT(1);
        this.match(50);
        if (this.inputState.guessing == 0) {
            implementsInsert = this.selectionAfterToken((JavaToken)id);
        }
        switch (this.LA(1)) {
            case 88: {
                implementsInsert = this.implementsClause(interfaces, interfaceSelections);
                break;
            }
            case 83: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        if (this.inputState.guessing == 0) {
            this.defineClass((JavaToken)id, superClass, interfaces, mods.get(4), mods.get(1), true, commentToken, null, implementsInsert, null, null, null, null, interfaceSelections);
        }
        this.enumBlock();
        if (this.inputState.guessing == 0) {
            this.popScope();
        }
    }

    public final void annotationTypeDeclaration() throws RecognitionException, TokenStreamException {
        this.match(81);
        this.match(79);
        this.match(50);
        this.annotationTypeBody();
    }

    public final void declaration() throws RecognitionException, TokenStreamException {
        this.modifiers();
        JavaToken type = this.typeSpec();
        this.variableDefinitions(type, null);
    }

    public final JavaToken typeSpec() throws RecognitionException, TokenStreamException {
        JavaToken t = null;
        switch (this.LA(1)) {
            case 50: {
                t = this.classTypeSpec();
                break;
            }
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: {
                t = this.builtInTypeSpec();
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        return t;
    }

    public final void variableDefinitions(JavaToken type, JavaToken commentToken) throws RecognitionException, TokenStreamException {
        this.variableDeclarator(type, commentToken);
        while (this.LA(1) == 53) {
            this.match(53);
            this.variableDeclarator(type, commentToken);
        }
    }

    public final JavaToken classTypeSpec() throws RecognitionException, TokenStreamException {
        JavaToken t = null;
        t = this.classOrInterfaceType(true, null);
        while (this.LA(1) == 48 && this.LA(2) == 49) {
            this.match(48);
            this.match(49);
            if (this.inputState.guessing != 0 || t == null) continue;
            t.setText(t.getText() + "[]");
        }
        return t;
    }

    public final JavaToken builtInTypeSpec() throws RecognitionException, TokenStreamException {
        JavaToken t = null;
        t = this.builtInType();
        while (this.LA(1) == 48 && this.LA(2) == 49) {
            this.match(48);
            this.match(49);
            if (this.inputState.guessing != 0 || t == null) continue;
            t.setText(t.getText() + "[]");
        }
        return t;
    }

    public final void arraySpecOpt() throws RecognitionException, TokenStreamException {
        Token lb = null;
        while (this.LA(1) == 48) {
            lb = this.LT(1);
            this.match(48);
            this.match(49);
        }
    }

    public final JavaToken classOrInterfaceType(boolean includeTypeArgs, Vector typeArgTokens) throws RecognitionException, TokenStreamException {
        Token id1 = null;
        Token id2 = null;
        JavaToken t = null;
        JavaToken typeArg = null;
        id1 = this.LT(1);
        this.match(50);
        if (this.inputState.guessing == 0) {
            t = (JavaToken)id1;
        }
        switch (this.LA(1)) {
            case 52: {
                typeArg = this.typeArguments(typeArgTokens);
                if (this.inputState.guessing != 0 || !includeTypeArgs) break;
                t.setText(t.getText() + typeArg.getText());
                break;
            }
            case 45: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 78: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 88: 
            case 89: 
            case 90: 
            case 92: 
            case 93: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 141: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        block8: while (this.LA(1) == 51 && this.LA(2) == 50) {
            this.match(51);
            id2 = this.LT(1);
            this.match(50);
            if (this.inputState.guessing == 0) {
                t.setText(t.getText() + "." + id2.getText());
            }
            switch (this.LA(1)) {
                case 52: {
                    typeArg = this.typeArguments(typeArgTokens);
                    if (this.inputState.guessing != 0 || !includeTypeArgs) continue block8;
                    t.setText(t.getText() + typeArg.getText());
                    continue block8;
                }
                case 45: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 78: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 88: 
                case 89: 
                case 90: 
                case 92: 
                case 93: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 121: 
                case 122: 
                case 123: 
                case 124: 
                case 125: 
                case 141: {
                    continue block8;
                }
            }
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        return t;
    }

    public final JavaToken typeArguments(Vector typeArgTokens) throws RecognitionException, TokenStreamException {
        Token lt = null;
        Token co = null;
        JavaToken t = null;
        JavaToken st = null;
        JavaToken st1 = null;
        JavaToken te = null;
        int currentLtLevel = 0;
        if (this.inputState.guessing == 0) {
            currentLtLevel = this.ltCounter;
        }
        lt = this.LT(1);
        this.match(52);
        if (this.inputState.guessing == 0) {
            ++this.ltCounter;
            t = (JavaToken)lt;
            if (typeArgTokens != null) {
                typeArgTokens.add(t);
            }
        }
        st = this.singleTypeArgument(typeArgTokens);
        if (this.inputState.guessing == 0) {
            t.setText(t.getText() + st.getText());
        }
        while (this.LA(1) == 53 && _tokenSet_8.member(this.LA(2))) {
            co = this.LT(1);
            this.match(53);
            st1 = this.singleTypeArgument(typeArgTokens);
            if (this.inputState.guessing != 0) continue;
            t.setText(t.getText() + ((JavaToken)co).getText() + st1.getText());
        }
        if (this.LA(1) >= 57 && this.LA(1) <= 59 && _tokenSet_9.member(this.LA(2))) {
            te = this.typeArgumentsEnd();
            if (this.inputState.guessing == 0) {
                if (typeArgTokens != null) {
                    typeArgTokens.add(te);
                }
                t.setText(t.getText() + te.getText());
            }
        } else if (!_tokenSet_9.member(this.LA(1)) || !_tokenSet_10.member(this.LA(2))) {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        if (currentLtLevel == 0 && this.ltCounter != currentLtLevel) {
            throw new SemanticException("(currentLtLevel != 0) || ltCounter == currentLtLevel");
        }
        return t;
    }

    public final JavaToken singleTypeArgument(Vector typeArgTokens) throws RecognitionException, TokenStreamException {
        JavaToken t;
        block29: {
            block28: {
                Token qu = null;
                Token id1 = null;
                Token id2 = null;
                Token qu1 = null;
                t = null;
                JavaToken t1 = null;
                JavaToken t2 = null;
                JavaToken t3 = null;
                JavaToken t4 = null;
                switch (this.LA(1)) {
                    case 50: {
                        t3 = this.classTypeSpec();
                        if (this.inputState.guessing != 0) break;
                        t = t3;
                        if (typeArgTokens == null) break;
                        typeArgTokens.add(t);
                        break;
                    }
                    case 60: 
                    case 61: 
                    case 62: 
                    case 63: 
                    case 64: 
                    case 65: 
                    case 66: 
                    case 67: 
                    case 68: {
                        t4 = this.builtInTypeSpec();
                        if (this.inputState.guessing != 0) break;
                        t = t4;
                        if (typeArgTokens == null) break;
                        typeArgTokens.add(t);
                        break;
                    }
                    case 54: {
                        qu = this.LT(1);
                        this.match(54);
                        if (this.inputState.guessing != 0) break;
                        if (qu != null) {
                            t = (JavaToken)qu;
                        }
                        if (typeArgTokens == null) break;
                        typeArgTokens.add(t);
                        break;
                    }
                    default: {
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                }
                if (this.LA(1) != 55 && this.LA(1) != 56 || !_tokenSet_8.member(this.LA(2))) break block28;
                switch (this.LA(1)) {
                    case 55: {
                        id1 = this.LT(1);
                        this.match(55);
                        break;
                    }
                    case 56: {
                        id2 = this.LT(1);
                        this.match(56);
                        break;
                    }
                    default: {
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                }
                if (this.inputState.guessing == 0) {
                    if (id1 != null) {
                        t.setText(t.getText() + " " + ((JavaToken)id1).getText());
                        if (typeArgTokens != null) {
                            typeArgTokens.add(id1);
                        }
                    } else if (id2 != null) {
                        t.setText(t.getText() + " " + ((JavaToken)id2).getText());
                    }
                    if (typeArgTokens != null) {
                        typeArgTokens.add(id2);
                    }
                }
                switch (this.LA(1)) {
                    case 50: {
                        t1 = this.classTypeSpec();
                        if (this.inputState.guessing == 0) {
                            t.setText(t.getText() + " " + t1.getText());
                            if (typeArgTokens != null) {
                                typeArgTokens.add(t1);
                            }
                        }
                        break block29;
                    }
                    case 60: 
                    case 61: 
                    case 62: 
                    case 63: 
                    case 64: 
                    case 65: 
                    case 66: 
                    case 67: 
                    case 68: {
                        t2 = this.builtInTypeSpec();
                        if (this.inputState.guessing == 0) {
                            t.setText(t.getText() + " " + t2.getText());
                            if (typeArgTokens != null) {
                                typeArgTokens.add(t2);
                            }
                        }
                        break block29;
                    }
                    case 54: {
                        qu1 = this.LT(1);
                        this.match(54);
                        if (this.inputState.guessing == 0) {
                            t.setText(t.getText() + ((JavaToken)qu1).getText());
                            if (typeArgTokens != null) {
                                typeArgTokens.add(t3);
                            }
                        }
                        break block29;
                    }
                    default: {
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                }
            }
            if (!_tokenSet_9.member(this.LA(1)) || !_tokenSet_10.member(this.LA(2))) {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        return t;
    }

    protected final JavaToken typeArgumentsEnd() throws RecognitionException, TokenStreamException {
        Token id1 = null;
        Token id2 = null;
        Token id3 = null;
        JavaToken t = null;
        switch (this.LA(1)) {
            case 57: {
                id1 = this.LT(1);
                this.match(57);
                if (this.inputState.guessing != 0) break;
                --this.ltCounter;
                t = (JavaToken)id1;
                break;
            }
            case 58: {
                id2 = this.LT(1);
                this.match(58);
                if (this.inputState.guessing != 0) break;
                this.ltCounter -= 2;
                t = (JavaToken)id2;
                break;
            }
            case 59: {
                id3 = this.LT(1);
                this.match(59);
                if (this.inputState.guessing != 0) break;
                this.ltCounter -= 3;
                t = (JavaToken)id3;
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        return t;
    }

    public final JavaToken builtInType() throws RecognitionException, TokenStreamException {
        Token bVoid = null;
        Token bBoolean = null;
        Token bByte = null;
        Token bChar = null;
        Token bShort = null;
        Token bInt = null;
        Token bFloat = null;
        Token bLong = null;
        Token bDouble = null;
        JavaToken t = null;
        switch (this.LA(1)) {
            case 60: {
                bVoid = this.LT(1);
                this.match(60);
                if (this.inputState.guessing != 0) break;
                t = (JavaToken)bVoid;
                break;
            }
            case 61: {
                bBoolean = this.LT(1);
                this.match(61);
                if (this.inputState.guessing != 0) break;
                t = (JavaToken)bBoolean;
                break;
            }
            case 62: {
                bByte = this.LT(1);
                this.match(62);
                if (this.inputState.guessing != 0) break;
                t = (JavaToken)bByte;
                break;
            }
            case 63: {
                bChar = this.LT(1);
                this.match(63);
                if (this.inputState.guessing != 0) break;
                t = (JavaToken)bChar;
                break;
            }
            case 64: {
                bShort = this.LT(1);
                this.match(64);
                if (this.inputState.guessing != 0) break;
                t = (JavaToken)bShort;
                break;
            }
            case 65: {
                bInt = this.LT(1);
                this.match(65);
                if (this.inputState.guessing != 0) break;
                t = (JavaToken)bInt;
                break;
            }
            case 66: {
                bFloat = this.LT(1);
                this.match(66);
                if (this.inputState.guessing != 0) break;
                t = (JavaToken)bFloat;
                break;
            }
            case 67: {
                bLong = this.LT(1);
                this.match(67);
                if (this.inputState.guessing != 0) break;
                t = (JavaToken)bLong;
                break;
            }
            case 68: {
                bDouble = this.LT(1);
                this.match(68);
                if (this.inputState.guessing != 0) break;
                t = (JavaToken)bDouble;
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        return t;
    }

    public final JavaToken type() throws RecognitionException, TokenStreamException {
        JavaToken t = null;
        switch (this.LA(1)) {
            case 50: {
                t = this.classOrInterfaceType(false, null);
                break;
            }
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: {
                t = this.builtInType();
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        return t;
    }

    public final void modifier(JavaBitSet mods) throws RecognitionException, TokenStreamException {
        switch (this.LA(1)) {
            case 70: {
                this.match(70);
                if (this.inputState.guessing != 0) break;
                mods.set(0);
                break;
            }
            case 71: {
                this.match(71);
                if (this.inputState.guessing != 0) break;
                mods.set(1);
                break;
            }
            case 72: {
                this.match(72);
                if (this.inputState.guessing != 0) break;
                mods.set(2);
                break;
            }
            case 47: {
                this.match(47);
                if (this.inputState.guessing != 0) break;
                mods.set(3);
                break;
            }
            case 73: {
                this.match(73);
                break;
            }
            case 39: {
                this.match(39);
                break;
            }
            case 40: {
                this.match(40);
                if (this.inputState.guessing != 0) break;
                mods.set(4);
                break;
            }
            case 74: {
                this.match(74);
                break;
            }
            case 75: {
                this.match(75);
                break;
            }
            case 76: {
                this.match(76);
                break;
            }
            case 77: {
                this.match(77);
                break;
            }
            case 41: {
                this.match(41);
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
    }

    public final Selection typeParameters(Vector typeParameterSelections) throws RecognitionException, TokenStreamException {
        Selection s;
        Token id = null;
        Token co = null;
        int currentLtLevel = 0;
        Selection typeParamInsert = null;
        JavaToken typeParameterText = null;
        JavaToken typeParam = null;
        JavaToken paramEnd = null;
        if (this.inputState.guessing == 0) {
            currentLtLevel = this.ltCounter;
        }
        id = this.LT(1);
        this.match(52);
        if (this.inputState.guessing == 0) {
            ++this.ltCounter;
            typeParameterText = (JavaToken)id;
            typeParamInsert = new Selection(typeParameterText);
            typeParameterSelections.add(typeParamInsert);
        }
        typeParam = this.typeParameter(typeParameterSelections);
        if (this.inputState.guessing == 0) {
            s = new Selection(typeParam);
            typeParameterSelections.add(s);
            typeParameterText.setText(typeParameterText.getText() + typeParam.getText());
            typeParamInsert = new Selection(typeParameterText);
        }
        while (this.LA(1) == 53) {
            co = this.LT(1);
            this.match(53);
            typeParam = this.typeParameter(typeParameterSelections);
            if (this.inputState.guessing != 0) continue;
            s = new Selection((JavaToken)co);
            typeParameterSelections.add(s);
            s = new Selection(typeParam);
            typeParameterSelections.add(s);
            typeParameterText.setText(typeParameterText.getText() + ((JavaToken)co).getText() + typeParam.getText());
            typeParamInsert = new Selection(typeParameterText);
        }
        switch (this.LA(1)) {
            case 57: 
            case 58: 
            case 59: {
                paramEnd = this.typeArgumentsEnd();
                if (this.inputState.guessing != 0 || paramEnd == null) break;
                s = new Selection(paramEnd);
                typeParameterSelections.add(s);
                typeParameterText.setText(typeParameterText.getText() + paramEnd.getText());
                typeParamInsert = new Selection(typeParameterText);
                break;
            }
            case 50: 
            case 55: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 83: 
            case 88: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        if (currentLtLevel == 0 && this.ltCounter != currentLtLevel) {
            throw new SemanticException("(currentLtLevel != 0) || ltCounter == currentLtLevel");
        }
        return typeParamInsert;
    }

    public final Selection implementsClause(JavaVector interfaces, Vector interfaceSelections) throws RecognitionException, TokenStreamException {
        Iterator it;
        Selection s;
        JavaToken lastArg;
        Token im = null;
        Token co = null;
        Vector typeArgs = new Vector();
        Selection implementsInsert = null;
        im = this.LT(1);
        this.match(88);
        JavaToken id = this.classOrInterfaceType(false, typeArgs);
        if (this.inputState.guessing == 0) {
            if (!typeArgs.isEmpty()) {
                lastArg = (JavaToken)((Object)typeArgs.lastElement());
                implementsInsert = this.selectionAfterToken(lastArg);
            } else {
                implementsInsert = this.selectionAfterToken(id);
            }
            interfaceSelections.addElement(new Selection((JavaToken)im));
            interfaces.addElement(this.dummyClass(id));
            s = new Selection(id);
            if (!typeArgs.isEmpty()) {
                it = typeArgs.iterator();
                while (it.hasNext()) {
                    s.addToken((JavaToken)((Object)it.next()));
                }
            }
            interfaceSelections.addElement(s);
            typeArgs.removeAllElements();
        }
        while (this.LA(1) == 53) {
            co = this.LT(1);
            this.match(53);
            id = this.classOrInterfaceType(false, typeArgs);
            if (this.inputState.guessing != 0) continue;
            if (!typeArgs.isEmpty()) {
                lastArg = (JavaToken)((Object)typeArgs.lastElement());
                implementsInsert = this.selectionAfterToken(lastArg);
            } else {
                implementsInsert = this.selectionAfterToken(id);
            }
            interfaceSelections.addElement(new Selection((JavaToken)co));
            interfaces.addElement(this.dummyClass(id));
            s = new Selection(id);
            if (!typeArgs.isEmpty()) {
                it = typeArgs.iterator();
                while (it.hasNext()) {
                    s.addToken((JavaToken)((Object)it.next()));
                }
            }
            interfaceSelections.addElement(s);
            typeArgs.removeAllElements();
        }
        return implementsInsert;
    }

    public final void classBlock() throws RecognitionException, TokenStreamException {
        this.match(83);
        block4: while (true) {
            switch (this.LA(1)) {
                case 39: 
                case 40: 
                case 41: 
                case 47: 
                case 50: 
                case 52: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 83: {
                    this.field();
                    continue block4;
                }
                case 45: {
                    this.match(45);
                    continue block4;
                }
            }
            break;
        }
        this.match(84);
    }

    public final Selection interfaceExtends(JavaVector interfaces, Vector interfaceSelections) throws RecognitionException, TokenStreamException {
        Iterator it;
        Selection s;
        Token ex = null;
        Token co = null;
        Vector typeArgs = new Vector();
        Selection extendsInsert = null;
        ex = this.LT(1);
        this.match(55);
        JavaToken id = this.classOrInterfaceType(false, typeArgs);
        if (this.inputState.guessing == 0) {
            if (!typeArgs.isEmpty()) {
                JavaToken lastArg = (JavaToken)((Object)typeArgs.lastElement());
                extendsInsert = this.selectionAfterToken(lastArg);
            } else {
                extendsInsert = this.selectionAfterToken(id);
            }
            interfaceSelections.addElement(new Selection((JavaToken)ex));
            interfaces.addElement(this.dummyClass(id));
            s = new Selection(id);
            if (!typeArgs.isEmpty()) {
                it = typeArgs.iterator();
                while (it.hasNext()) {
                    s.addToken((JavaToken)((Object)it.next()));
                }
            }
            interfaceSelections.addElement(s);
            typeArgs.removeAllElements();
        }
        while (this.LA(1) == 53) {
            co = this.LT(1);
            this.match(53);
            id = this.classOrInterfaceType(false, typeArgs);
            if (this.inputState.guessing != 0) continue;
            extendsInsert = this.selectionAfterToken(id);
            interfaceSelections.addElement(new Selection((JavaToken)co));
            interfaces.addElement(this.dummyClass(id));
            s = new Selection(id);
            if (!typeArgs.isEmpty()) {
                it = typeArgs.iterator();
                while (it.hasNext()) {
                    s.addToken((JavaToken)((Object)it.next()));
                }
            }
            interfaceSelections.addElement(s);
            typeArgs.removeAllElements();
            interfaceSelections.addElement(new Selection(id));
        }
        return extendsInsert;
    }

    public final void enumBlock() throws RecognitionException, TokenStreamException {
        this.match(83);
        this.enumConstant();
        while (this.LA(1) == 53 && (this.LA(2) == 50 || this.LA(2) == 81)) {
            this.match(53);
            this.enumConstant();
        }
        switch (this.LA(1)) {
            case 53: {
                this.match(53);
                break;
            }
            case 45: 
            case 84: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        switch (this.LA(1)) {
            case 45: {
                this.match(45);
                block13: while (true) {
                    switch (this.LA(1)) {
                        case 39: 
                        case 40: 
                        case 41: 
                        case 47: 
                        case 50: 
                        case 52: 
                        case 60: 
                        case 61: 
                        case 62: 
                        case 63: 
                        case 64: 
                        case 65: 
                        case 66: 
                        case 67: 
                        case 68: 
                        case 70: 
                        case 71: 
                        case 72: 
                        case 73: 
                        case 74: 
                        case 75: 
                        case 76: 
                        case 77: 
                        case 78: 
                        case 79: 
                        case 80: 
                        case 81: 
                        case 83: {
                            this.field();
                            continue block13;
                        }
                        case 45: {
                            this.match(45);
                            continue block13;
                        }
                    }
                    break;
                }
                break;
            }
            case 84: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        this.match(84);
    }

    public final void annotationTypeBody() throws RecognitionException, TokenStreamException {
        this.match(83);
        while (_tokenSet_11.member(this.LA(1))) {
            this.annotationTypeMemberDeclaration();
        }
        this.match(84);
    }

    public final JavaToken typeParameter(Vector typeParameterSelections) throws RecognitionException, TokenStreamException {
        Token id2 = null;
        Token id3 = null;
        Token ex = null;
        Token band = null;
        JavaToken paramInsert = null;
        JavaToken id = null;
        Object xtend = null;
        switch (this.LA(1)) {
            case 50: {
                id2 = this.LT(1);
                this.match(50);
                break;
            }
            case 54: {
                id3 = this.LT(1);
                this.match(54);
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        if (this.inputState.guessing == 0) {
            if (id2 != null) {
                paramInsert = (JavaToken)id2;
            } else if (id3 != null) {
                paramInsert = (JavaToken)id3;
            }
            typeParameterSelections.add(new Selection(paramInsert));
        }
        if (this.LA(1) == 55 && this.LA(2) == 50) {
            Selection s;
            ex = this.LT(1);
            this.match(55);
            id = this.classOrInterfaceType(false, null);
            if (this.inputState.guessing == 0) {
                typeParameterSelections.add(new Selection((JavaToken)ex));
                typeParameterSelections.add(new Selection(id));
                paramInsert.setText(paramInsert.getText() + " " + ex.getText());
                paramInsert.setText(paramInsert.getText() + " " + id.getText());
                s = new Selection(paramInsert);
            }
            while (this.LA(1) == 82) {
                band = this.LT(1);
                this.match(82);
                id = this.classOrInterfaceType(false, null);
                if (this.inputState.guessing != 0) continue;
                typeParameterSelections.add(new Selection((JavaToken)band));
                typeParameterSelections.add(new Selection(id));
                paramInsert.setText(paramInsert.getText() + " " + band.getText());
                paramInsert.setText(paramInsert.getText() + " " + id.getText());
                s = new Selection(paramInsert);
            }
        } else if (!_tokenSet_12.member(this.LA(1)) || !_tokenSet_13.member(this.LA(2))) {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        return paramInsert;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void field() throws RecognitionException, TokenStreamException {
        Token method = null;
        JavaToken commentToken = null;
        JavaVector exceptions = null;
        JavaBitSet mods = null;
        Vector typeParameterSelections = new Vector();
        Selection typeParameterTextSelection = null;
        if (_tokenSet_14.member(this.LA(1)) && _tokenSet_15.member(this.LA(2))) {
            if (this.inputState.guessing == 0) {
                commentToken = this.findAttachedComment((JavaToken)this.LT(1));
            }
            mods = this.modifiers();
            switch (this.LA(1)) {
                case 78: {
                    this.classDefinition(new JavaBitSet(), null);
                    return;
                }
                case 80: {
                    this.enumDefinition(new JavaBitSet(), null);
                    return;
                }
                case 79: {
                    this.interfaceDefinition(new JavaBitSet(), null);
                    return;
                }
                default: {
                    if (this.LA(1) == 50 && this.LA(2) == 85) {
                        this.ctorHead(null, commentToken);
                        this.constructorBody();
                        return;
                    }
                    if (!_tokenSet_16.member(this.LA(1)) || !_tokenSet_17.member(this.LA(2))) throw new NoViableAltException(this.LT(1), this.getFilename());
                    switch (this.LA(1)) {
                        case 52: {
                            typeParameterTextSelection = this.typeParameters(typeParameterSelections);
                            break;
                        }
                        case 50: 
                        case 60: 
                        case 61: 
                        case 62: 
                        case 63: 
                        case 64: 
                        case 65: 
                        case 66: 
                        case 67: 
                        case 68: {
                            break;
                        }
                        default: {
                            throw new NoViableAltException(this.LT(1), this.getFilename());
                        }
                    }
                    JavaToken type = this.typeSpec();
                    if (this.LA(1) == 50 && this.LA(2) == 85) {
                        method = this.LT(1);
                        this.match(50);
                        if (this.inputState.guessing == 0) {
                            this.defineMethod((JavaToken)method, type, commentToken, typeParameterTextSelection);
                        }
                        this.match(85);
                        this.parameterDeclarationList();
                        this.match(86);
                        while (this.LA(1) == 48) {
                            this.match(48);
                            this.match(49);
                        }
                        switch (this.LA(1)) {
                            case 91: {
                                exceptions = this.throwsClause();
                                break;
                            }
                            case 45: 
                            case 83: {
                                break;
                            }
                            default: {
                                throw new NoViableAltException(this.LT(1), this.getFilename());
                            }
                        }
                        if (this.inputState.guessing == 0) {
                            this.endMethodHead(exceptions);
                        }
                        switch (this.LA(1)) {
                            case 83: {
                                this.compoundStatement(1);
                                return;
                            }
                            case 45: {
                                this.match(45);
                                if (this.inputState.guessing != 0) return;
                                this.popScope();
                                return;
                            }
                            default: {
                                throw new NoViableAltException(this.LT(1), this.getFilename());
                            }
                        }
                    }
                    if (this.LA(1) != 50 || !_tokenSet_18.member(this.LA(2))) throw new NoViableAltException(this.LT(1), this.getFilename());
                    this.variableDefinitions(type, commentToken);
                    this.match(45);
                    return;
                }
            }
        }
        if (this.LA(1) == 47 && this.LA(2) == 83) {
            this.match(47);
            this.compoundStatement(2);
            return;
        } else {
            if (this.LA(1) != 83) throw new NoViableAltException(this.LT(1), this.getFilename());
            this.compoundStatement(3);
        }
    }

    public final void enumConstant() throws RecognitionException, TokenStreamException {
        while (this.LA(1) == 81) {
            this.annotation();
        }
        this.match(50);
        switch (this.LA(1)) {
            case 85: {
                this.match(85);
                this.argList();
                this.match(86);
                break;
            }
            case 45: 
            case 53: 
            case 83: 
            case 84: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        switch (this.LA(1)) {
            case 83: {
                this.classBlock();
                break;
            }
            case 45: 
            case 53: 
            case 84: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
    }

    public final int argList() throws RecognitionException, TokenStreamException {
        int count = 0;
        switch (this.LA(1)) {
            case 50: 
            case 56: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 85: 
            case 89: 
            case 130: 
            case 131: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: {
                count = this.expressionList();
                break;
            }
            case 86: {
                if (this.inputState.guessing != 0) break;
                count = 0;
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        return count;
    }

    public final void annotationTypeMemberDeclaration() throws RecognitionException, TokenStreamException {
        this.modifiers();
        switch (this.LA(1)) {
            case 50: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: {
                this.typeSpec();
                this.match(50);
                this.match(85);
                this.match(86);
                switch (this.LA(1)) {
                    case 87: {
                        this.annDefaultValue();
                        break;
                    }
                    case 45: {
                        break;
                    }
                    default: {
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                }
                this.match(45);
                break;
            }
            case 39: 
            case 40: 
            case 41: 
            case 45: 
            case 47: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: {
                this.typeDefinition();
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
    }

    protected final void annDefaultValue() throws RecognitionException, TokenStreamException {
        this.match(87);
        this.annMemberValue();
    }

    protected final void annMemberValue() throws RecognitionException, TokenStreamException {
        switch (this.LA(1)) {
            case 50: 
            case 56: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 85: 
            case 89: 
            case 130: 
            case 131: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: {
                this.conditionalExpression();
                break;
            }
            case 81: {
                this.annotation();
                break;
            }
            case 83: {
                this.annMemberValueArrayInitializer();
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
    }

    public final void ctorHead(JavaToken type, JavaToken commentToken) throws RecognitionException, TokenStreamException {
        Token method = null;
        JavaVector exceptions = null;
        method = this.LT(1);
        this.match(50);
        if (this.inputState.guessing == 0) {
            this.defineMethod((JavaToken)method, type, commentToken, null);
        }
        this.match(85);
        this.parameterDeclarationList();
        this.match(86);
        switch (this.LA(1)) {
            case 91: {
                exceptions = this.throwsClause();
                break;
            }
            case 83: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        if (this.inputState.guessing == 0) {
            this.endMethodHead(exceptions);
        }
    }

    public final void constructorBody() throws RecognitionException, TokenStreamException {
        this.match(83);
        boolean synPredMatched113 = false;
        if (_tokenSet_19.member(this.LA(1)) && _tokenSet_20.member(this.LA(2))) {
            int _m113 = this.mark();
            synPredMatched113 = true;
            ++this.inputState.guessing;
            try {
                this.explicitConstructorInvocation();
            }
            catch (RecognitionException pe) {
                synPredMatched113 = false;
            }
            this.rewind(_m113);
            --this.inputState.guessing;
        }
        if (synPredMatched113) {
            this.explicitConstructorInvocation();
        } else if (!_tokenSet_21.member(this.LA(1)) || !_tokenSet_22.member(this.LA(2))) {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
        while (_tokenSet_23.member(this.LA(1))) {
            this.statement();
        }
        if (this.inputState.guessing == 0) {
            this.popScope();
        }
        this.match(84);
    }

    public final void parameterDeclarationList() throws RecognitionException, TokenStreamException {
        switch (this.LA(1)) {
            case 39: 
            case 50: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 81: {
                this.parameterDeclaration();
                while (this.LA(1) == 53) {
                    this.match(53);
                    this.parameterDeclaration();
                }
                break;
            }
            case 86: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
    }

    public final JavaVector throwsClause() throws RecognitionException, TokenStreamException {
        JavaVector exceptions = new JavaVector();
        this.match(91);
        JavaToken id = this.identifier();
        if (this.inputState.guessing == 0) {
            exceptions.addElement(this.dummyClass(id));
        }
        while (this.LA(1) == 53) {
            this.match(53);
            id = this.identifier();
            if (this.inputState.guessing != 0) continue;
            exceptions.addElement(this.dummyClass(id));
        }
        return exceptions;
    }

    public final void compoundStatement(int scopeType) throws RecognitionException, TokenStreamException {
        Token lc = null;
        lc = this.LT(1);
        this.match(83);
        if (this.inputState.guessing == 0) {
            switch (scopeType) {
                case 4: {
                    this.defineBlock((JavaToken)lc);
                    break;
                }
                case 2: {
                    lc.setText("~class-init~");
                    this.defineMethod(null, (JavaToken)lc, null, null);
                    this.endMethodHead(null);
                    break;
                }
                case 3: {
                    lc.setText("~instance-init~");
                    this.defineMethod(null, (JavaToken)lc, null, null);
                    this.endMethodHead(null);
                }
            }
        }
        while (_tokenSet_23.member(this.LA(1))) {
            this.statement();
        }
        if (this.inputState.guessing == 0) {
            this.popScope();
        }
        this.match(84);
    }

    public final void explicitConstructorInvocation() throws RecognitionException, TokenStreamException {
        if (this.LA(1) == 89 && this.LA(2) == 85) {
            this.match(89);
            this.match(85);
            this.argList();
            this.match(86);
            this.match(45);
        } else if (this.LA(1) == 56 && this.LA(2) == 85) {
            this.match(56);
            this.match(85);
            this.argList();
            this.match(86);
            this.match(45);
        } else if (_tokenSet_19.member(this.LA(1)) && _tokenSet_20.member(this.LA(2))) {
            this.primaryExpression();
            this.match(51);
            this.match(56);
            this.match(85);
            this.argList();
            this.match(86);
            this.match(45);
        } else {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
    }

    public final void statement() throws RecognitionException, TokenStreamException {
        Token id = null;
        Token bid = null;
        Token cid = null;
        int count = -1;
        switch (this.LA(1)) {
            case 83: {
                this.compoundStatement(4);
                break;
            }
            case 94: {
                this.match(94);
                this.match(85);
                this.expression();
                this.match(86);
                this.statement();
                if (this.LA(1) == 95 && _tokenSet_23.member(this.LA(2))) {
                    this.match(95);
                    this.statement();
                    break;
                }
                if (_tokenSet_24.member(this.LA(1)) && _tokenSet_25.member(this.LA(2))) break;
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            case 96: {
                this.match(96);
                this.match(85);
                boolean synPredMatched162 = false;
                if (_tokenSet_26.member(this.LA(1)) && _tokenSet_27.member(this.LA(2))) {
                    int _m162 = this.mark();
                    synPredMatched162 = true;
                    ++this.inputState.guessing;
                    try {
                        this.parameterDeclaration();
                        this.match(93);
                    }
                    catch (RecognitionException pe) {
                        synPredMatched162 = false;
                    }
                    this.rewind(_m162);
                    --this.inputState.guessing;
                }
                if (synPredMatched162) {
                    this.enhancedForClause();
                } else if (_tokenSet_28.member(this.LA(1)) && _tokenSet_29.member(this.LA(2))) {
                    this.forClause();
                } else {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
                this.match(86);
                this.statement();
                break;
            }
            case 97: {
                this.match(97);
                this.match(85);
                this.expression();
                this.match(86);
                this.statement();
                break;
            }
            case 98: {
                this.match(98);
                this.statement();
                this.match(97);
                this.match(85);
                this.expression();
                this.match(86);
                this.match(45);
                break;
            }
            case 99: {
                this.match(99);
                switch (this.LA(1)) {
                    case 50: {
                        bid = this.LT(1);
                        this.match(50);
                        if (this.inputState.guessing != 0) break;
                        this.reference((JavaToken)bid);
                        break;
                    }
                    case 45: {
                        break;
                    }
                    default: {
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                }
                this.match(45);
                break;
            }
            case 100: {
                this.match(100);
                switch (this.LA(1)) {
                    case 50: {
                        cid = this.LT(1);
                        this.match(50);
                        if (this.inputState.guessing != 0) break;
                        this.reference((JavaToken)cid);
                        break;
                    }
                    case 45: {
                        break;
                    }
                    default: {
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                }
                this.match(45);
                break;
            }
            case 101: {
                this.match(101);
                switch (this.LA(1)) {
                    case 50: 
                    case 56: 
                    case 60: 
                    case 61: 
                    case 62: 
                    case 63: 
                    case 64: 
                    case 65: 
                    case 66: 
                    case 67: 
                    case 68: 
                    case 85: 
                    case 89: 
                    case 130: 
                    case 131: 
                    case 134: 
                    case 135: 
                    case 136: 
                    case 137: 
                    case 138: 
                    case 139: 
                    case 140: 
                    case 141: 
                    case 142: 
                    case 143: 
                    case 144: 
                    case 145: 
                    case 146: 
                    case 147: {
                        this.expression();
                        break;
                    }
                    case 45: {
                        break;
                    }
                    default: {
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                }
                this.match(45);
                break;
            }
            case 102: {
                this.match(102);
                this.match(85);
                this.expression();
                this.match(86);
                this.match(83);
                while (this.LA(1) == 87 || this.LA(1) == 105) {
                    this.casesGroup();
                }
                this.match(84);
                break;
            }
            case 106: {
                this.tryBlock();
                break;
            }
            case 103: {
                this.match(103);
                this.expression();
                this.match(45);
                break;
            }
            case 104: {
                this.match(104);
                this.expression();
                switch (this.LA(1)) {
                    case 93: {
                        this.match(93);
                        this.expression();
                        break;
                    }
                    case 45: {
                        break;
                    }
                    default: {
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                }
                this.match(45);
                break;
            }
            case 45: {
                this.match(45);
                break;
            }
            default: {
                JavaBitSet mods;
                boolean synPredMatched156 = false;
                if (_tokenSet_30.member(this.LA(1)) && _tokenSet_31.member(this.LA(2))) {
                    int _m156 = this.mark();
                    synPredMatched156 = true;
                    ++this.inputState.guessing;
                    try {
                        this.declaration();
                    }
                    catch (RecognitionException pe) {
                        synPredMatched156 = false;
                    }
                    this.rewind(_m156);
                    --this.inputState.guessing;
                }
                if (synPredMatched156) {
                    this.declaration();
                    this.match(45);
                    break;
                }
                if (_tokenSet_32.member(this.LA(1)) && _tokenSet_33.member(this.LA(2))) {
                    this.expression();
                    this.match(45);
                    break;
                }
                boolean synPredMatched158 = false;
                if (_tokenSet_34.member(this.LA(1)) && _tokenSet_35.member(this.LA(2))) {
                    int _m158 = this.mark();
                    synPredMatched158 = true;
                    ++this.inputState.guessing;
                    try {
                        mods = this.modifiers();
                        this.classDefinition(mods, null);
                    }
                    catch (RecognitionException pe) {
                        synPredMatched158 = false;
                    }
                    this.rewind(_m158);
                    --this.inputState.guessing;
                }
                if (synPredMatched158) {
                    mods = this.modifiers();
                    this.classDefinition(mods, null);
                    break;
                }
                if (this.LA(1) == 50 && this.LA(2) == 93) {
                    id = this.LT(1);
                    this.match(50);
                    this.match(93);
                    this.statement();
                    if (this.inputState.guessing != 0) break;
                    this.defineLabel((JavaToken)id);
                    break;
                }
                if (this.LA(1) == 76 && this.LA(2) == 85) {
                    this.match(76);
                    this.match(85);
                    this.expression();
                    this.match(86);
                    this.statement();
                    break;
                }
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
    }

    public final JavaToken primaryExpression() throws RecognitionException, TokenStreamException {
        Token id = null;
        Token th = null;
        Token s = null;
        JavaToken t = null;
        switch (this.LA(1)) {
            case 50: {
                id = this.LT(1);
                this.match(50);
                if (this.inputState.guessing != 0) break;
                t = (JavaToken)id;
                break;
            }
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: {
                this.constant();
                break;
            }
            case 138: {
                this.match(138);
                break;
            }
            case 139: {
                this.match(139);
                break;
            }
            case 89: {
                th = this.LT(1);
                this.match(89);
                if (this.inputState.guessing != 0) break;
                t = (JavaToken)th;
                this.setNearestClassScope();
                break;
            }
            case 140: {
                this.match(140);
                break;
            }
            case 141: {
                t = this.newExpression();
                break;
            }
            case 85: {
                this.match(85);
                this.expression();
                this.match(86);
                break;
            }
            case 56: {
                s = this.LT(1);
                this.match(56);
                if (this.inputState.guessing != 0) break;
                t = (JavaToken)s;
                break;
            }
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: {
                this.builtInType();
                while (this.LA(1) == 48) {
                    this.match(48);
                    this.match(49);
                }
                this.match(51);
                this.match(78);
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        return t;
    }

    public final void variableDeclarator(JavaToken type, JavaToken commentToken) throws RecognitionException, TokenStreamException {
        Token id = null;
        id = this.LT(1);
        this.match(50);
        while (this.LA(1) == 48) {
            this.match(48);
            this.match(49);
            if (this.inputState.guessing != 0 || type == null) continue;
            type.setText(type.getText() + "[]");
        }
        this.varInitializer();
        if (this.inputState.guessing == 0) {
            this.defineVar((JavaToken)id, type, false, commentToken);
        }
    }

    public final void varInitializer() throws RecognitionException, TokenStreamException {
        switch (this.LA(1)) {
            case 90: {
                this.match(90);
                this.initializer();
                break;
            }
            case 45: 
            case 53: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
    }

    public final void initializer() throws RecognitionException, TokenStreamException {
        switch (this.LA(1)) {
            case 50: 
            case 56: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 85: 
            case 89: 
            case 130: 
            case 131: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: {
                this.expression();
                break;
            }
            case 83: {
                this.arrayInitializer();
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
    }

    public final void arrayInitializer() throws RecognitionException, TokenStreamException {
        this.match(83);
        block0 : switch (this.LA(1)) {
            case 50: 
            case 56: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 83: 
            case 85: 
            case 89: 
            case 130: 
            case 131: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: {
                this.initializer();
                while (this.LA(1) == 53 && _tokenSet_36.member(this.LA(2))) {
                    this.match(53);
                    this.initializer();
                }
                switch (this.LA(1)) {
                    case 53: {
                        this.match(53);
                        break block0;
                    }
                    case 84: {
                        break block0;
                    }
                }
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            case 84: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        this.match(84);
    }

    public final void expression() throws RecognitionException, TokenStreamException {
        this.assignmentExpression();
    }

    public final void parameterDeclaration() throws RecognitionException, TokenStreamException {
        Token id = null;
        boolean isVarargs = false;
        this.parameterModifier();
        JavaToken type = this.typeSpec();
        switch (this.LA(1)) {
            case 92: {
                this.match(92);
                if (this.inputState.guessing != 0) break;
                isVarargs = true;
                break;
            }
            case 50: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        id = this.LT(1);
        this.match(50);
        while (this.LA(1) == 48) {
            this.match(48);
            this.match(49);
            if (this.inputState.guessing != 0 || type == null) continue;
            type.setText(type.getText() + "[]");
        }
        if (this.inputState.guessing == 0) {
            this.defineVar((JavaToken)id, type, isVarargs, null);
        }
    }

    public final void parameterModifier() throws RecognitionException, TokenStreamException {
        Token f = null;
        while (this.LA(1) == 81) {
            this.annotation();
        }
        switch (this.LA(1)) {
            case 39: {
                f = this.LT(1);
                this.match(39);
                while (this.LA(1) == 81) {
                    this.annotation();
                }
                break;
            }
            case 50: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
    }

    protected final void enhancedForClause() throws RecognitionException, TokenStreamException {
        this.parameterDeclaration();
        this.match(93);
        this.expression();
    }

    protected final void forClause() throws RecognitionException, TokenStreamException {
        switch (this.LA(1)) {
            case 39: 
            case 40: 
            case 41: 
            case 47: 
            case 50: 
            case 56: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 81: 
            case 85: 
            case 89: 
            case 130: 
            case 131: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: {
                this.forInit();
                break;
            }
            case 45: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        this.match(45);
        switch (this.LA(1)) {
            case 50: 
            case 56: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 85: 
            case 89: 
            case 130: 
            case 131: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: {
                this.expression();
                break;
            }
            case 45: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        this.match(45);
        switch (this.LA(1)) {
            case 50: 
            case 56: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 85: 
            case 89: 
            case 130: 
            case 131: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: {
                this.expressionList();
                break;
            }
            case 86: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
    }

    public final void casesGroup() throws RecognitionException, TokenStreamException {
        int _cnt171 = 0;
        while (true) {
            if (this.LA(1) != 87 && this.LA(1) != 105 || !_tokenSet_37.member(this.LA(2))) {
                if (_cnt171 >= 1) break;
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            this.aCase();
            ++_cnt171;
        }
        this.caseSList();
    }

    public final void tryBlock() throws RecognitionException, TokenStreamException {
        this.match(106);
        this.compoundStatement(4);
        while (this.LA(1) == 108) {
            this.handler();
        }
        switch (this.LA(1)) {
            case 107: {
                this.match(107);
                this.compoundStatement(4);
                break;
            }
            case 39: 
            case 40: 
            case 41: 
            case 45: 
            case 47: 
            case 50: 
            case 56: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 81: 
            case 83: 
            case 84: 
            case 85: 
            case 87: 
            case 89: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 130: 
            case 131: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
    }

    public final void aCase() throws RecognitionException, TokenStreamException {
        switch (this.LA(1)) {
            case 105: {
                this.match(105);
                this.expression();
                break;
            }
            case 87: {
                this.match(87);
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        this.match(93);
    }

    public final void caseSList() throws RecognitionException, TokenStreamException {
        while (_tokenSet_23.member(this.LA(1))) {
            this.statement();
        }
    }

    public final void forInit() throws RecognitionException, TokenStreamException {
        int count = -1;
        boolean synPredMatched184 = false;
        if (_tokenSet_30.member(this.LA(1)) && _tokenSet_31.member(this.LA(2))) {
            int _m184 = this.mark();
            synPredMatched184 = true;
            ++this.inputState.guessing;
            try {
                this.declaration();
            }
            catch (RecognitionException pe) {
                synPredMatched184 = false;
            }
            this.rewind(_m184);
            --this.inputState.guessing;
        }
        if (synPredMatched184) {
            this.declaration();
        } else if (_tokenSet_32.member(this.LA(1)) && _tokenSet_38.member(this.LA(2))) {
            count = this.expressionList();
        } else {
            throw new NoViableAltException(this.LT(1), this.getFilename());
        }
    }

    public final int expressionList() throws RecognitionException, TokenStreamException {
        int count = 1;
        this.expression();
        while (this.LA(1) == 53) {
            this.match(53);
            this.expression();
            if (this.inputState.guessing != 0) continue;
            ++count;
        }
        return count;
    }

    public final void handler() throws RecognitionException, TokenStreamException {
        this.match(108);
        this.match(85);
        this.parameterDeclaration();
        this.match(86);
        this.compoundStatement(4);
    }

    public final void assignmentExpression() throws RecognitionException, TokenStreamException {
        this.conditionalExpression();
        switch (this.LA(1)) {
            case 90: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: {
                switch (this.LA(1)) {
                    case 90: {
                        this.match(90);
                        break;
                    }
                    case 109: {
                        this.match(109);
                        break;
                    }
                    case 110: {
                        this.match(110);
                        break;
                    }
                    case 111: {
                        this.match(111);
                        break;
                    }
                    case 112: {
                        this.match(112);
                        break;
                    }
                    case 113: {
                        this.match(113);
                        break;
                    }
                    case 114: {
                        this.match(114);
                        break;
                    }
                    case 115: {
                        this.match(115);
                        break;
                    }
                    case 116: {
                        this.match(116);
                        break;
                    }
                    case 117: {
                        this.match(117);
                        break;
                    }
                    case 118: {
                        this.match(118);
                        break;
                    }
                    case 119: {
                        this.match(119);
                        break;
                    }
                    default: {
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                }
                this.assignmentExpression();
                break;
            }
            case 45: 
            case 49: 
            case 53: 
            case 84: 
            case 86: 
            case 93: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
    }

    public final void conditionalExpression() throws RecognitionException, TokenStreamException {
        this.logicalOrExpression();
        switch (this.LA(1)) {
            case 54: {
                this.match(54);
                this.assignmentExpression();
                this.match(93);
                this.conditionalExpression();
                break;
            }
            case 45: 
            case 49: 
            case 53: 
            case 84: 
            case 86: 
            case 90: 
            case 93: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
    }

    public final void logicalOrExpression() throws RecognitionException, TokenStreamException {
        this.logicalAndExpression();
        while (this.LA(1) == 120) {
            this.match(120);
            this.logicalAndExpression();
        }
    }

    public final void logicalAndExpression() throws RecognitionException, TokenStreamException {
        this.inclusiveOrExpression();
        while (this.LA(1) == 121) {
            this.match(121);
            this.inclusiveOrExpression();
        }
    }

    public final void inclusiveOrExpression() throws RecognitionException, TokenStreamException {
        this.exclusiveOrExpression();
        while (this.LA(1) == 122) {
            this.match(122);
            this.exclusiveOrExpression();
        }
    }

    public final void exclusiveOrExpression() throws RecognitionException, TokenStreamException {
        this.andExpression();
        while (this.LA(1) == 123) {
            this.match(123);
            this.andExpression();
        }
    }

    public final void andExpression() throws RecognitionException, TokenStreamException {
        this.equalityExpression();
        while (this.LA(1) == 82) {
            this.match(82);
            this.equalityExpression();
        }
    }

    public final void equalityExpression() throws RecognitionException, TokenStreamException {
        this.relationalExpression();
        while (this.LA(1) == 124 || this.LA(1) == 125) {
            switch (this.LA(1)) {
                case 124: {
                    this.match(124);
                    break;
                }
                case 125: {
                    this.match(125);
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            this.relationalExpression();
        }
    }

    public final void relationalExpression() throws RecognitionException, TokenStreamException {
        this.shiftExpression();
        switch (this.LA(1)) {
            case 45: 
            case 49: 
            case 52: 
            case 53: 
            case 54: 
            case 57: 
            case 82: 
            case 84: 
            case 86: 
            case 90: 
            case 93: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: {
                while (_tokenSet_39.member(this.LA(1))) {
                    switch (this.LA(1)) {
                        case 52: {
                            this.match(52);
                            break;
                        }
                        case 57: {
                            this.match(57);
                            break;
                        }
                        case 126: {
                            this.match(126);
                            break;
                        }
                        case 127: {
                            this.match(127);
                            break;
                        }
                        default: {
                            throw new NoViableAltException(this.LT(1), this.getFilename());
                        }
                    }
                    this.shiftExpression();
                }
                break;
            }
            case 128: {
                this.match(128);
                this.typeSpec();
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
    }

    public final void shiftExpression() throws RecognitionException, TokenStreamException {
        this.additiveExpression();
        while (_tokenSet_40.member(this.LA(1))) {
            switch (this.LA(1)) {
                case 129: {
                    this.match(129);
                    break;
                }
                case 58: {
                    this.match(58);
                    break;
                }
                case 59: {
                    this.match(59);
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            this.additiveExpression();
        }
    }

    public final void additiveExpression() throws RecognitionException, TokenStreamException {
        this.multiplicativeExpression();
        while (this.LA(1) == 130 || this.LA(1) == 131) {
            switch (this.LA(1)) {
                case 130: {
                    this.match(130);
                    break;
                }
                case 131: {
                    this.match(131);
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            this.multiplicativeExpression();
        }
    }

    public final void multiplicativeExpression() throws RecognitionException, TokenStreamException {
        this.unaryExpression();
        while (_tokenSet_41.member(this.LA(1))) {
            switch (this.LA(1)) {
                case 69: {
                    this.match(69);
                    break;
                }
                case 132: {
                    this.match(132);
                    break;
                }
                case 133: {
                    this.match(133);
                    break;
                }
                default: {
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
            }
            this.unaryExpression();
        }
    }

    public final void unaryExpression() throws RecognitionException, TokenStreamException {
        switch (this.LA(1)) {
            case 134: {
                this.match(134);
                this.unaryExpression();
                break;
            }
            case 135: {
                this.match(135);
                this.unaryExpression();
                break;
            }
            case 131: {
                this.match(131);
                this.unaryExpression();
                break;
            }
            case 130: {
                this.match(130);
                this.unaryExpression();
                break;
            }
            case 50: 
            case 56: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 85: 
            case 89: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: {
                this.unaryExpressionNotPlusMinus();
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
    }

    public final void unaryExpressionNotPlusMinus() throws RecognitionException, TokenStreamException {
        switch (this.LA(1)) {
            case 136: {
                this.match(136);
                this.unaryExpression();
                break;
            }
            case 137: {
                this.match(137);
                this.unaryExpression();
                break;
            }
            case 50: 
            case 56: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 85: 
            case 89: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: {
                JavaToken t;
                if (this.LA(1) == 85 && this.LA(2) >= 60 && this.LA(2) <= 68) {
                    this.match(85);
                    JavaToken t2 = this.builtInTypeSpec();
                    this.match(86);
                    this.unaryExpression();
                    if (this.inputState.guessing != 0) break;
                    this.reference(t2);
                    break;
                }
                boolean synPredMatched239 = false;
                if (this.LA(1) == 85 && this.LA(2) == 50) {
                    int _m239 = this.mark();
                    synPredMatched239 = true;
                    ++this.inputState.guessing;
                    try {
                        this.match(85);
                        t = this.classTypeSpec();
                        this.match(86);
                        this.unaryExpressionNotPlusMinus();
                    }
                    catch (RecognitionException pe) {
                        synPredMatched239 = false;
                    }
                    this.rewind(_m239);
                    --this.inputState.guessing;
                }
                if (synPredMatched239) {
                    this.match(85);
                    t = this.classTypeSpec();
                    this.match(86);
                    this.unaryExpressionNotPlusMinus();
                    if (this.inputState.guessing != 0) break;
                    this.reference(t);
                    break;
                }
                if (_tokenSet_19.member(this.LA(1)) && _tokenSet_42.member(this.LA(2))) {
                    this.postfixExpression();
                    break;
                }
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
    }

    public final void postfixExpression() throws RecognitionException, TokenStreamException {
        Token id = null;
        int count = -1;
        JavaToken t = this.primaryExpression();
        block20: while (true) {
            switch (this.LA(1)) {
                case 51: {
                    this.match(51);
                    switch (this.LA(1)) {
                        case 52: {
                            this.typeArguments(null);
                            break;
                        }
                        case 50: 
                        case 56: 
                        case 78: 
                        case 89: 
                        case 141: {
                            break;
                        }
                        default: {
                            throw new NoViableAltException(this.LT(1), this.getFilename());
                        }
                    }
                    switch (this.LA(1)) {
                        case 50: {
                            id = this.LT(1);
                            this.match(50);
                            if (this.inputState.guessing != 0 || t == null) continue block20;
                            t.setText(t.getText() + "." + id.getText());
                            continue block20;
                        }
                        case 89: {
                            this.match(89);
                            if (this.inputState.guessing != 0 || t == null) continue block20;
                            t.setText(t.getText() + ".this");
                            continue block20;
                        }
                        case 78: {
                            this.match(78);
                            if (this.inputState.guessing != 0 || t == null) continue block20;
                            t.setText(t.getText() + ".class");
                            continue block20;
                        }
                        case 141: {
                            this.newExpression();
                            continue block20;
                        }
                        case 56: {
                            this.match(56);
                            continue block20;
                        }
                    }
                    throw new NoViableAltException(this.LT(1), this.getFilename());
                }
                case 85: {
                    this.match(85);
                    count = this.argList();
                    this.match(86);
                    if (this.inputState.guessing != 0 || t == null) continue block20;
                    t.setParamCount(count);
                    continue block20;
                }
            }
            if (this.LA(1) == 48 && this.LA(2) == 49) {
                int _cnt245 = 0;
                while (true) {
                    if (this.LA(1) != 48) {
                        if (_cnt245 >= 1) break;
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                    this.match(48);
                    this.match(49);
                    ++_cnt245;
                }
                this.match(51);
                this.match(78);
                continue;
            }
            if (this.LA(1) != 48 || !_tokenSet_32.member(this.LA(2))) break;
            this.match(48);
            this.expression();
            this.match(49);
        }
        if (this.inputState.guessing == 0 && t != null) {
            this.reference(t);
        }
        switch (this.LA(1)) {
            case 134: {
                this.match(134);
                break;
            }
            case 135: {
                this.match(135);
                break;
            }
            case 45: 
            case 49: 
            case 52: 
            case 53: 
            case 54: 
            case 57: 
            case 58: 
            case 59: 
            case 69: 
            case 82: 
            case 84: 
            case 86: 
            case 90: 
            case 93: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
    }

    public final JavaToken newExpression() throws RecognitionException, TokenStreamException {
        JavaToken t = null;
        int count = -1;
        this.match(141);
        t = this.type();
        block0 : switch (this.LA(1)) {
            case 85: {
                this.match(85);
                count = this.argList();
                this.match(86);
                if (this.inputState.guessing == 0) {
                    t.setText(t.getText() + ".~constructor~");
                    t.setParamCount(count);
                }
                switch (this.LA(1)) {
                    case 83: {
                        this.classBlock();
                        break block0;
                    }
                    case 45: 
                    case 48: 
                    case 49: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 57: 
                    case 58: 
                    case 59: 
                    case 69: 
                    case 82: 
                    case 84: 
                    case 85: 
                    case 86: 
                    case 90: 
                    case 93: 
                    case 109: 
                    case 110: 
                    case 111: 
                    case 112: 
                    case 113: 
                    case 114: 
                    case 115: 
                    case 116: 
                    case 117: 
                    case 118: 
                    case 119: 
                    case 120: 
                    case 121: 
                    case 122: 
                    case 123: 
                    case 124: 
                    case 125: 
                    case 126: 
                    case 127: 
                    case 128: 
                    case 129: 
                    case 130: 
                    case 131: 
                    case 132: 
                    case 133: 
                    case 134: 
                    case 135: {
                        break block0;
                    }
                }
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            case 48: {
                this.newArrayDeclarator();
                switch (this.LA(1)) {
                    case 83: {
                        this.arrayInitializer();
                        break block0;
                    }
                    case 45: 
                    case 48: 
                    case 49: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 57: 
                    case 58: 
                    case 59: 
                    case 69: 
                    case 82: 
                    case 84: 
                    case 85: 
                    case 86: 
                    case 90: 
                    case 93: 
                    case 109: 
                    case 110: 
                    case 111: 
                    case 112: 
                    case 113: 
                    case 114: 
                    case 115: 
                    case 116: 
                    case 117: 
                    case 118: 
                    case 119: 
                    case 120: 
                    case 121: 
                    case 122: 
                    case 123: 
                    case 124: 
                    case 125: 
                    case 126: 
                    case 127: 
                    case 128: 
                    case 129: 
                    case 130: 
                    case 131: 
                    case 132: 
                    case 133: 
                    case 134: 
                    case 135: {
                        break block0;
                    }
                }
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        return t;
    }

    public final void constant() throws RecognitionException, TokenStreamException {
        switch (this.LA(1)) {
            case 142: {
                this.match(142);
                break;
            }
            case 143: {
                this.match(143);
                break;
            }
            case 144: {
                this.match(144);
                break;
            }
            case 145: {
                this.match(145);
                break;
            }
            case 146: {
                this.match(146);
                break;
            }
            case 147: {
                this.match(147);
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
    }

    public final void newArrayDeclarator() throws RecognitionException, TokenStreamException {
        int _cnt260 = 0;
        while (true) {
            if (this.LA(1) == 48 && _tokenSet_43.member(this.LA(2))) {
                this.match(48);
                switch (this.LA(1)) {
                    case 50: 
                    case 56: 
                    case 60: 
                    case 61: 
                    case 62: 
                    case 63: 
                    case 64: 
                    case 65: 
                    case 66: 
                    case 67: 
                    case 68: 
                    case 85: 
                    case 89: 
                    case 130: 
                    case 131: 
                    case 134: 
                    case 135: 
                    case 136: 
                    case 137: 
                    case 138: 
                    case 139: 
                    case 140: 
                    case 141: 
                    case 142: 
                    case 143: 
                    case 144: 
                    case 145: 
                    case 146: 
                    case 147: {
                        this.expression();
                        break;
                    }
                    case 49: {
                        break;
                    }
                    default: {
                        throw new NoViableAltException(this.LT(1), this.getFilename());
                    }
                }
            } else {
                if (_cnt260 >= 1) break;
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
            this.match(49);
            ++_cnt260;
        }
    }

    protected final void annTypeName() throws RecognitionException, TokenStreamException {
        this.match(50);
        while (this.LA(1) == 51) {
            this.match(51);
            this.match(50);
        }
    }

    protected final void annMemberValuePair() throws RecognitionException, TokenStreamException {
        this.match(50);
        this.match(90);
        this.annMemberValue();
    }

    protected final void annMemberValueArrayInitializer() throws RecognitionException, TokenStreamException {
        this.match(83);
        switch (this.LA(1)) {
            case 50: 
            case 56: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 81: 
            case 83: 
            case 85: 
            case 89: 
            case 130: 
            case 131: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: {
                this.annMemberValues();
                break;
            }
            case 53: 
            case 84: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        switch (this.LA(1)) {
            case 53: {
                this.match(53);
                break;
            }
            case 84: {
                break;
            }
            default: {
                throw new NoViableAltException(this.LT(1), this.getFilename());
            }
        }
        this.match(84);
    }

    protected final void annMemberValues() throws RecognitionException, TokenStreamException {
        this.annMemberValue();
        while (this.LA(1) == 53 && _tokenSet_4.member(this.LA(2))) {
            this.match(53);
            this.annMemberValue();
        }
    }

    private static final long[] mk_tokenSet_0() {
        long[] data = new long[]{250138895319042L, 262080L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_1() {
        long[] data = new long[]{1305670057984002L, 262080L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_2() {
        long[] data = new long[]{179770151141376L, 262080L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_3() {
        long[] data = new long[]{-1151615834548862974L, 1310687L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_4() {
        long[] data = new long[]{-1079738010662076416L, 36306975L, 1048524L, 0L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_5() {
        long[] data = new long[]{-1138087443480707072L, 5504991L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_6() {
        long[] data = new long[]{0x838000000000L, 16320L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_7() {
        long[] data = new long[]{-1147112234921492480L, 262111L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_8() {
        long[] data = new long[]{-1133781206190522368L, 31L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_9() {
        long[] data = new long[]{-4749890231992320L, 4611650834986188831L, 8192L, 0L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_10() {
        long[] data = new long[]{-84112639524864L, -26388413284353L, 1048575L, 0L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_11() {
        long[] data = new long[]{-1151615834548862976L, 262111L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_12() {
        long[] data = new long[]{-97953291895308288L, 17301535L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_13() {
        long[] data = new long[]{-1090535764602650624L, 18612191L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_14() {
        long[] data = new long[]{-1147147419293581312L, 262111L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_15() {
        long[] data = new long[]{-1126599745993703424L, 2359263L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_16() {
        long[] data = new long[]{-1147292005072633856L, 31L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_17() {
        long[] data = new long[]{0x5D000000000000L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_18() {
        long[] data = new long[]{0x21200000000000L, 0x4000000L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_19() {
        long[] data = new long[]{-1079738010662076416L, 35651615L, 1047552L, 0L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_20() {
        long[] data = new long[]{-1077204735871680512L, 35651615L, 1048524L, 0L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_21() {
        long[] data = new long[]{-1079558240510935040L, 6593885929439L, 1048524L, 0L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_22() {
        long[] data = new long[]{-45700651052695552L, -28589881819137L, 1048575L, 0L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_23() {
        long[] data = new long[]{-1079558240510935040L, 6593884880863L, 1048524L, 0L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_24() {
        long[] data = new long[]{-1079558240510935040L, 8795065057247L, 1048524L, 0L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_25() {
        long[] data = new long[]{-45700651052695552L, -423624705L, 1048575L, 0L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_26() {
        long[] data = new long[]{-1151795054944190464L, 131103L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_27() {
        long[] data = new long[]{-1144758730282237952L, 268566559L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_28() {
        long[] data = new long[]{-1079558240510935040L, 35799007L, 1048524L, 0L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_29() {
        long[] data = new long[]{-36693451797954560L, -35184268918785L, 1048575L, 0L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_30() {
        long[] data = new long[]{-1151651018920951808L, 147423L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_31() {
        long[] data = new long[]{-1144614144503185408L, 147423L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_32() {
        long[] data = new long[]{-1079738010662076416L, 35651615L, 1048524L, 0L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_33() {
        long[] data = new long[]{-45845236831748096L, -35184269066177L, 1048575L, 0L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_34() {
        long[] data = new long[]{0x838000000000L, 163776L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_35() {
        long[] data = new long[]{1270485685895168L, 163776L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_36() {
        long[] data = new long[]{-1079738010662076416L, 36175903L, 1048524L, 0L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_37() {
        long[] data = new long[]{-1079738010662076416L, 572522527L, 1048524L, 0L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_38() {
        long[] data = new long[]{-36838037577007104L, -35184269066177L, 1048575L, 0L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_39() {
        long[] data = new long[]{0x210000000000000L, -4611686018427387904L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_40() {
        long[] data = new long[]{0xC00000000000000L, 0L, 2L, 0L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_41() {
        long[] data = new long[]{0L, 32L, 48L, 0L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_42() {
        long[] data = new long[]{-36275087623585792L, -35183726952385L, 1048575L, 0L, 0L, 0L};
        return data;
    }

    private static final long[] mk_tokenSet_43() {
        long[] data = new long[]{-1079175060708655104L, 35651615L, 1048524L, 0L, 0L, 0L};
        return data;
    }
}

