/*
 * Decompiled with CFR 0.152.
 */
package bluej.extmgr;

import bluej.extmgr.ExtensionWrapper;
import bluej.prefmgr.PrefPanelListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;

public class ExtensionPrefManager
implements PrefPanelListener {
    private List extensionsList;
    private final int DO_panelUpdate = 1;
    private final int DO_loadValues = 2;
    private final int DO_saveValues = 3;
    private JPanel drawPanel;
    private JPanel rootPanel;

    public ExtensionPrefManager(List i_extensionsList) {
        this.extensionsList = i_extensionsList;
        this.drawPanel = new JPanel();
        this.drawPanel.setLayout(new BoxLayout(this.drawPanel, 1));
        JPanel middlePanel = new JPanel(new BorderLayout());
        middlePanel.add((Component)this.drawPanel, "North");
        JScrollPane drawScroll = new JScrollPane(middlePanel);
        drawScroll.setBorder(new EmptyBorder(0, 0, 0, 0));
        drawScroll.setHorizontalScrollBarPolicy(31);
        this.rootPanel = new JPanel(new BorderLayout());
        this.rootPanel.add((Component)drawScroll, "Center");
    }

    public JPanel getPanel() {
        return this.rootPanel;
    }

    private void doWorkLoop(int doAction) {
        if (doAction == 1) {
            this.drawPanel.removeAll();
        }
        Iterator iter = this.extensionsList.iterator();
        while (iter.hasNext()) {
            this.doWorkItem((ExtensionWrapper)iter.next(), doAction);
        }
    }

    private void doWorkItem(ExtensionWrapper aWrapper, int doAction) {
        if (!aWrapper.isValid()) {
            return;
        }
        String extensionName = aWrapper.safeGetExtensionName();
        switch (doAction) {
            case 2: {
                aWrapper.safePrefGenLoadValues();
                return;
            }
            case 3: {
                aWrapper.safePrefGenSaveValues();
                return;
            }
            case 1: {
                this.addUserPanel(aWrapper, extensionName);
                return;
            }
        }
    }

    private void addUserPanel(ExtensionWrapper aWrapper, String extensionName) {
        JPanel aPanel = aWrapper.safePrefGenGetPanel();
        if (aPanel == null) {
            return;
        }
        JPanel framePanel = new JPanel(new BorderLayout());
        framePanel.setBorder(BorderFactory.createTitledBorder(extensionName));
        framePanel.add((Component)aPanel, "North");
        this.drawPanel.add(framePanel);
    }

    public void panelRevalidate() {
        EventQueue.invokeLater(new DoPanelUpdate());
    }

    public void beginEditing() {
    }

    public void revertEditing() {
        this.doWorkLoop(2);
    }

    public void commitEditing() {
        this.doWorkLoop(3);
    }

    private class DoPanelUpdate
    implements Runnable {
        private DoPanelUpdate() {
        }

        public void run() {
            ExtensionPrefManager.this.doWorkLoop(1);
        }
    }
}

