/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugmgr.objectbench;

import bluej.BlueJEvent;
import bluej.Config;
import bluej.debugger.DebuggerObject;
import bluej.debugger.gentype.GenTypeClass;
import bluej.debugger.gentype.GenTypeDeclTpar;
import bluej.debugger.gentype.Reflective;
import bluej.debugmgr.ExpressionInformation;
import bluej.debugmgr.Invoker;
import bluej.debugmgr.ResultWatcher;
import bluej.debugmgr.inspector.Inspector;
import bluej.debugmgr.inspector.ObjectInspector;
import bluej.debugmgr.inspector.ResultInspector;
import bluej.debugmgr.objectbench.ArrayWrapper;
import bluej.debugmgr.objectbench.ObjectBench;
import bluej.extmgr.MenuManager;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.prefmgr.PrefMgr;
import bluej.testmgr.record.InvokerRecord;
import bluej.testmgr.record.ObjectInspectInvokerRecord;
import bluej.utility.Debug;
import bluej.utility.JavaNames;
import bluej.utility.Utility;
import bluej.views.MethodView;
import bluej.views.View;
import bluej.views.ViewFilter;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class ObjectWrapper
extends JComponent {
    static String methodException = Config.getString("debugger.objectwrapper.methodException");
    static String invocationException = Config.getString("debugger.objectwrapper.invocationException");
    static String inspect = Config.getString("debugger.objectwrapper.inspect");
    static String remove = Config.getString("debugger.objectwrapper.remove");
    static String redefinedIn = Config.getString("debugger.objectwrapper.redefined");
    static String inheritedFrom = Config.getString("debugger.objectwrapper.inherited");
    static final Color bg = Config.getItemColour("colour.wrapper.bg");
    static final Color envOpColour = Config.getItemColour("colour.menu.environOp");
    static final Color textColour = Color.white;
    static final Stroke selectedStroke = new BasicStroke(2.0f);
    static final Stroke normalStroke = new BasicStroke(1.0f);
    protected static final int HGAP = 5;
    protected static final int VGAP = 6;
    public static final int WIDTH = 95;
    public static final int HEIGHT = 66;
    public static final int WORD_GAP = 20;
    public static final int SHADOW_SIZE = 5;
    private static int itemHeight = 19;
    private static boolean itemHeightKnown = false;
    private static int itemsOnScreen;
    protected DebuggerObject obj;
    private String className;
    private String instanceName;
    protected String displayClassName;
    protected JPopupMenu menu;
    private Package pkg;
    private PkgMgrFrame pmf;
    private ObjectBench ob;
    private Hashtable methodsUsed;
    private Hashtable actions;
    private boolean isSelected = false;
    private Color[] colours = new Color[]{new Color(0, 0, 0, 11), new Color(0, 0, 0, 22), new Color(0, 0, 0, 33), new Color(0, 0, 0, 66)};

    public static ObjectWrapper getWrapper(PkgMgrFrame pmf, ObjectBench ob, DebuggerObject obj, String instanceName) {
        if (pmf.isEmptyFrame()) {
            throw new IllegalArgumentException();
        }
        if (obj.isArray()) {
            return new ArrayWrapper(pmf, ob, obj, instanceName);
        }
        return new ObjectWrapper(pmf, ob, obj, instanceName);
    }

    protected ObjectWrapper(PkgMgrFrame pmf, ObjectBench ob, DebuggerObject obj, String instanceName) {
        if (pmf.isEmptyFrame()) {
            throw new IllegalArgumentException();
        }
        if (!itemHeightKnown) {
            itemsOnScreen = (int)Config.screenBounds.getHeight() / itemHeight;
        }
        this.pmf = pmf;
        this.pkg = pmf.getPackage();
        this.ob = ob;
        this.obj = obj;
        this.setName(instanceName);
        this.createMenu(obj.getClassName());
        this.className = obj.getGenClassName();
        this.displayClassName = obj.getStrippedGenClassName();
        this.enableEvents(16L);
        this.setMinimumSize(new Dimension(95, 66));
        this.setSize(95, 66);
        this.setFocusable(false);
        this.setCursor(Cursor.getPredefinedCursor(12));
        ob.setSelectedObject(this);
    }

    public Package getPackage() {
        return this.pkg;
    }

    public PkgMgrFrame getFrame() {
        return this.pmf;
    }

    public String getClassName() {
        return this.obj.getClassName();
    }

    public String getTypeName() {
        return this.className;
    }

    public GenTypeClass getGenType() {
        return this.obj.getGenType();
    }

    public void prepareRemove() {
        Inspector.removeInstance(this.obj);
    }

    protected void createMenu(String className) {
        Class cl = this.pkg.loadClass(className);
        List classes = this.getClassHierarchy(cl);
        this.menu = new JPopupMenu(this.getName() + " operations");
        if (cl != null) {
            View view = View.getView(cl);
            this.actions = new Hashtable();
            this.methodsUsed = new Hashtable();
            ViewFilter filter = new ViewFilter(196613);
            this.menu.addSeparator();
            MethodView[] declaredMethods = view.getDeclaredMethods();
            Map tparTypes = this.obj.getGenericParams();
            Reflective reflective = this.obj.getGenType().getReflective();
            if (tparTypes != null) {
                Iterator i = reflective.getTypeParams().iterator();
                while (i.hasNext()) {
                    GenTypeDeclTpar tpar = (GenTypeDeclTpar)i.next();
                    String paramName = tpar.getTparName();
                    if (tparTypes.containsKey(paramName)) continue;
                    tparTypes.put(paramName, tpar.getBound());
                }
            }
            int itemLimit = itemsOnScreen - 8 - classes.size();
            this.createMenuItems(this.menu, declaredMethods, filter, itemLimit, tparTypes);
            for (int i = 1; i < classes.size(); ++i) {
                Class currentClass = (Class)classes.get(i);
                view = View.getView(currentClass);
                GenTypeClass c = new GenTypeClass(reflective, tparTypes);
                tparTypes = c.mapToSuper(currentClass.getName());
                reflective = reflective.superTypeByName(currentClass.getName()).getReflective();
                declaredMethods = view.getDeclaredMethods();
                JMenu subMenu = new JMenu(inheritedFrom + " " + JavaNames.stripPrefix(currentClass.getName()));
                subMenu.setFont(PrefMgr.getStandoutMenuFont());
                this.createMenuItems(subMenu, declaredMethods, filter, itemsOnScreen / 2, tparTypes);
                this.menu.insert(subMenu, 0);
            }
            this.menu.addSeparator();
        }
        JMenuItem item = new JMenuItem(inspect);
        this.menu.add(item);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ObjectWrapper.this.inspectObject();
            }
        });
        item.setFont(PrefMgr.getStandoutMenuFont());
        item.setForeground(envOpColour);
        item = new JMenuItem(remove);
        this.menu.add(item);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ObjectWrapper.this.removeObject();
            }
        });
        item.setFont(PrefMgr.getStandoutMenuFont());
        item.setForeground(envOpColour);
        MenuManager menuManager = new MenuManager(this.menu);
        menuManager.setAttachedObject(this);
        menuManager.addExtensionMenu(this.pkg.getProject());
        this.add(this.menu);
    }

    private void createMenuItems(JComponent menu, MethodView[] methods, ViewFilter filter, int sizeLimit, Map genericParams) {
        Arrays.sort(methods);
        for (int i = 0; i < methods.length; ++i) {
            try {
                MethodView m = methods[i];
                if (!filter.accept(m)) continue;
                String methodSignature = m.getCallSignature();
                String methodDescription = m.getLongDesc(genericParams);
                if (this.methodsUsed.containsKey(methodSignature)) {
                    methodDescription = methodDescription + "   [ " + redefinedIn + " " + JavaNames.stripPrefix((String)this.methodsUsed.get(methodSignature)) + " ]";
                } else {
                    this.methodsUsed.put(methodSignature, m.getClassName());
                }
                JMenuItem item = new JMenuItem(methodDescription);
                item.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        ObjectWrapper.this.invokeMethod(e.getSource());
                    }
                });
                item.setFont(PrefMgr.getPopupMenuFont());
                this.actions.put(item, m);
                int itemCount = menu instanceof JMenu ? ((JMenu)menu).getMenuComponentCount() : menu.getComponentCount();
                if (itemCount >= sizeLimit) {
                    JMenu subMenu = new JMenu("more methods");
                    subMenu.setFont(PrefMgr.getStandoutMenuFont());
                    subMenu.setForeground(envOpColour);
                    menu.add(subMenu);
                    menu = subMenu;
                    sizeLimit = itemsOnScreen / 2;
                }
                menu.add(item);
                continue;
            }
            catch (Exception e) {
                Debug.reportError(methodException + e);
                e.printStackTrace();
            }
        }
    }

    public JPopupMenu getMenu() {
        return this.menu;
    }

    public List getClassHierarchy(Class derivedClass) {
        ArrayList classVector = new ArrayList();
        for (Class currentClass = derivedClass; currentClass != null; currentClass = currentClass.getSuperclass()) {
            classVector.add(currentClass);
        }
        return classVector;
    }

    public Dimension getMinimumSize() {
        return new Dimension(95, 66);
    }

    public Dimension getPreferredSize() {
        return new Dimension(95, 66);
    }

    public Dimension getMaximumSize() {
        return new Dimension(95, 66);
    }

    public String getName() {
        return this.instanceName;
    }

    public void setName(String newName) {
        this.instanceName = newName;
    }

    public DebuggerObject getObject() {
        return this.obj;
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        this.drawUMLStyle(g2);
    }

    protected void drawUMLObjectShape(Graphics2D g, int x, int y, int w, int h, int shad, int corner) {
        boolean isSelected = this.isSelected() && this.ob.hasFocus();
        this.drawShadow(g, x, y, w, h, shad, corner);
        g.setColor(bg);
        g.fillRoundRect(x, y, w - shad, h - shad, corner, corner);
        g.setColor(Color.BLACK);
        if (isSelected) {
            g.setStroke(selectedStroke);
        }
        g.drawRoundRect(x, y, w - shad, h - shad, corner, corner);
        if (isSelected) {
            g.setStroke(normalStroke);
        }
    }

    private void drawShadow(Graphics2D g, int x, int y, int w, int h, int shad, int corner) {
        g.setColor(this.colours[0]);
        g.fillRoundRect(x + shad, y + shad, w - shad, h - shad, corner, corner);
        g.setColor(this.colours[1]);
        g.fillRoundRect(x + shad, y + shad, w - shad - 1, h - shad - 1, corner, corner);
        g.setColor(this.colours[2]);
        g.fillRoundRect(x + shad, y + shad, w - shad - 2, h - shad - 2, corner, corner);
        g.setColor(this.colours[3]);
        g.fillRoundRect(x + shad, y + shad, w - shad - 3, h - shad - 3, corner, corner);
    }

    protected void drawUMLObjectText(Graphics2D g, int x, int y, int w, int shad, String objName, String className) {
        g.setColor(textColour);
        g.setFont(PrefMgr.getStandardFont());
        FontMetrics fm = g.getFontMetrics();
        int fontHeight = fm.getAscent() + 5;
        int maxWidth = w - shad - 4;
        int aWidth = fm.stringWidth(objName);
        if (aWidth > maxWidth) {
            aWidth = maxWidth;
        }
        Utility.drawCentredText(g, objName, x + 2, y + 5, maxWidth, fontHeight);
        int lineX = x + 2 + (maxWidth - aWidth) / 2;
        int lineY = y + 5 + fontHeight;
        g.drawLine(lineX, lineY, lineX + aWidth, lineY);
        int bWidth = fm.stringWidth(className);
        if (bWidth > maxWidth) {
            bWidth = maxWidth;
        }
        Utility.drawCentredText(g, className, x + 2, y + 25, maxWidth, fontHeight);
        lineX = x + 2 + (maxWidth - bWidth) / 2;
        lineY = y + 25 + fontHeight;
        g.drawLine(lineX, lineY, lineX + bWidth, lineY);
    }

    protected void drawUMLStyle(Graphics2D g) {
        this.drawUMLObjectShape(g, 5, 3, 90, 60, 5, 8);
        this.drawUMLObjectText(g, 5, 3, 90, 5, this.getName() + ":", this.displayClassName);
    }

    protected void processMouseEvent(MouseEvent evt) {
        super.processMouseEvent(evt);
        if (evt.isPopupTrigger()) {
            this.showMenu(evt.getX(), evt.getY());
        } else if (evt.getID() == 500) {
            if (evt.getClickCount() > 1) {
                this.inspectObject();
            } else {
                this.ob.fireObjectEvent(this);
            }
        }
        if (evt.getID() == 500 || evt.isPopupTrigger()) {
            this.ob.setSelectedObject(this);
            this.ob.requestFocusInWindow();
        }
    }

    private int calcOffset() {
        int height;
        if (!itemHeightKnown && (height = ((JComponent)this.menu.getComponent(0)).getHeight()) > 1) {
            itemHeight = height;
            itemsOnScreen = (int)Config.screenBounds.getHeight() / itemHeight;
            itemHeightKnown = true;
        }
        int offsetFactor = 4;
        int menuCount = this.menu.getComponentCount();
        if (menuCount < 4) {
            offsetFactor = menuCount;
        }
        int menuOffset = (this.menu.getComponentCount() - offsetFactor) * itemHeight;
        return menuOffset;
    }

    public void showMenu(int x, int y) {
        if (this.menu == null) {
            return;
        }
        int menuOffset = this.calcOffset();
        this.menu.show(this, x + 1, y - menuOffset);
    }

    public void showMenu() {
        this.showMenu(47, 33);
    }

    protected void invokeMethod(Object eventSource) {
        MethodView method = (MethodView)this.actions.get(eventSource);
        if (method != null) {
            this.executeMethod(method);
        }
    }

    protected void inspectObject() {
        ObjectInspectInvokerRecord ir = new ObjectInspectInvokerRecord(this.getTypeName(), this.getName());
        ObjectInspector.getInstance(this.obj, this.getName(), this.pkg, ir, this.pmf);
    }

    protected void removeObject() {
        this.ob.removeObject(this, this.pkg.getId());
    }

    private void executeMethod(final MethodView method) {
        ResultWatcher watcher = null;
        this.pkg.forgetLastSource();
        watcher = new ResultWatcher(){
            private ExpressionInformation expressionInformation;
            {
                this.expressionInformation = new ExpressionInformation(method, ObjectWrapper.this.getName(), ObjectWrapper.this.obj.getGenType());
            }

            public void putResult(DebuggerObject result, String name, InvokerRecord ir) {
                ObjectWrapper.this.ob.addInteraction(ir);
                if (name == null) {
                    return;
                }
                ResultInspector viewer = ResultInspector.getInstance(result, name, ObjectWrapper.this.pkg, ir, this.expressionInformation, ObjectWrapper.this.pmf);
                BlueJEvent.raiseEvent(3, viewer.getResult());
            }

            public void putError(String msg) {
            }

            public ExpressionInformation getExpressionInformation() {
                return this.expressionInformation;
            }
        };
        Invoker invoker = new Invoker(this.pmf, method, this, watcher);
        invoker.invokeInteractive();
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public void setSelected(boolean isSelected) {
        this.isSelected = isSelected;
        if (isSelected) {
            this.pmf.setStatus(this.getName() + " : " + this.displayClassName);
        }
        this.repaint();
        this.scrollRectToVisible(new Rectangle(0, 0, 95, 66));
    }
}

