/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugmgr;

import bluej.BlueJTheme;
import bluej.Config;
import bluej.debugger.gentype.GenType;
import bluej.debugger.gentype.GenTypeArray;
import bluej.debugmgr.CallDialog;
import bluej.debugmgr.CallHistory;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.utility.ComponentFactory;
import bluej.utility.GrowableBox;
import bluej.utility.JavaNames;
import bluej.utility.MultiLineLabel;
import bluej.views.CallableView;
import bluej.views.ConstructorView;
import bluej.views.LabelPrintWriter;
import bluej.views.MethodView;
import bluej.views.TypeParamView;
import bluej.views.View;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;

public class MethodDialog
extends CallDialog
implements FocusListener {
    private static final Insets INSETS = new Insets(2, 2, 2, 2);
    private static final int MD_CREATE = 0;
    private static final int MD_CALL = 1;
    private int dialogType;
    private boolean listeningObjects;
    private boolean okCalled;
    static final String wCreateTitle = Config.getString("pkgmgr.methodCall.titleCreate");
    static final String wCallRoutineTitle = Config.getString("pkgmgr.methodCall.titleCall");
    static final String sNameOfInstance = Config.getString("pkgmgr.methodCall.namePrompt");
    static final String sTypeParameters = Config.getString("pkgmgr.methodCall.typeParametersPrompt");
    static final String sTypeParameter = Config.getString("pkgmgr.methodCall.typeParameterPrompt");
    static final String emptyFieldMsg = Config.getString("error.methodCall.emptyField");
    static final String emptyTypeFieldMsg = Config.getString("error.methodCall.emptyTypeField");
    static final String illegalNameMsg = Config.getString("error.methodCall.illegalName");
    static final String duplicateNameMsg = Config.getString("error.methodCall.duplicateName");
    static final String commentSlash = "   ";
    private String methodName;
    private CallableView method;
    private Map typeParameterMap;
    private JPanel descPanel;
    private ParameterList parameterList;
    private ParameterList typeParameterList;
    private JTextField instanceNameText;
    private JTextField focusedTextField;
    private JLabel callLabel;
    private CallHistory history;
    private String defaultParamValue = "";

    public MethodDialog(PkgMgrFrame pmf, String instanceName, CallableView method, Map typeMap) {
        super(pmf, "");
        Package pkg = pmf.getPackage();
        this.history = pkg.getCallHistory();
        if (method instanceof MethodView) {
            this.dialogType = 1;
            this.methodName = ((MethodView)method).getName();
        } else if (method instanceof ConstructorView) {
            this.dialogType = 0;
        }
        this.makeDialog(method.getClassName(), instanceName, method);
        this.setInstanceInfo(instanceName, typeMap);
    }

    public void setVisible(boolean show) {
        if (!show) {
            if (this.listeningObjects) {
                this.stopObjectBenchListening();
            }
            this.listeningObjects = false;
            super.setVisible(false);
        }
    }

    public void doOk() {
        if (!this.okCalled) {
            if (this.dialogType == 0) {
                if (!JavaNames.isIdentifier(this.getNewInstanceName())) {
                    this.setErrorMessage(illegalNameMsg);
                    return;
                }
                if (this.getObjectBench().hasObject(this.getNewInstanceName())) {
                    this.setErrorMessage(duplicateNameMsg);
                    return;
                }
            }
            if (!this.parameterFieldsOk()) {
                this.setErrorMessage(emptyFieldMsg);
            } else if (!this.typeParameterFieldsOk()) {
                this.setErrorMessage(emptyTypeFieldMsg);
            } else {
                this.setWaitCursor(true);
                this.callWatcher(0);
                this.okCalled = true;
            }
        }
    }

    public void doCancel() {
        this.callWatcher(1);
    }

    private void setDescription(MultiLineLabel label) {
        label.setAlignmentX(0.0f);
        this.descPanel.removeAll();
        this.descPanel.add(label);
        this.invalidate();
        this.validate();
    }

    public String[] getArgs() {
        String[] args = null;
        if (this.parameterList != null) {
            args = new String[this.parameterList.size()];
            for (int i = 0; i < this.parameterList.size(); ++i) {
                args[i] = (String)this.parameterList.getParameter(i).getEditor().getItem();
            }
        }
        return args;
    }

    public boolean parameterFieldsOk() {
        if (this.parameterList != null) {
            for (int i = 0; i < this.parameterList.size(); ++i) {
                String arg = (String)this.parameterList.getParameter(i).getEditor().getItem();
                if (arg != null && !arg.trim().equals("")) continue;
                return false;
            }
        }
        return true;
    }

    public boolean typeParameterFieldsOk() {
        boolean oneIsTypedIn = false;
        boolean oneIsEmpty = false;
        if (this.typeParameterList != null) {
            for (int i = 0; i < this.typeParameterList.size(); ++i) {
                String arg = (String)this.typeParameterList.getParameter(i).getEditor().getItem();
                if (arg == null || arg.trim().equals("")) {
                    oneIsEmpty = true;
                } else {
                    oneIsTypedIn = true;
                }
                if (!oneIsEmpty || !oneIsTypedIn) continue;
                return false;
            }
        }
        return true;
    }

    public String[] getTypeParams() {
        if (this.typeParameterList == null) {
            return new String[0];
        }
        String[] typeParams = new String[this.typeParameterList.size()];
        for (int i = 0; i < this.typeParameterList.size(); ++i) {
            typeParams[i] = (String)this.typeParameterList.getParameter(i).getEditor().getItem();
            if (!typeParams[i].equals("")) continue;
            return new String[0];
        }
        return typeParams;
    }

    public void insertText(String text) {
        if (this.parameterList != null && this.focusedTextField != null) {
            this.focusedTextField.setText(text);
            this.show();
        }
    }

    public void setInstanceInfo(String instanceName, Map typeParams) {
        if (this.dialogType == 1) {
            this.typeParameterMap = typeParams;
            this.setCallLabel(instanceName, this.methodName);
        } else {
            this.instanceNameText.setText(instanceName);
        }
        this.createDescription();
        this.setErrorMessage("");
        this.clearParameters();
        if (!this.listeningObjects) {
            this.startObjectBenchListening();
            this.listeningObjects = true;
        }
        this.show();
        if (this.parameterList != null) {
            this.parameterList.getParameter(0).getEditor().getEditorComponent().requestFocus();
        } else if (this.dialogType == 0) {
            this.instanceNameText.selectAll();
            this.instanceNameText.requestFocus();
        }
        if (this.typeParameterList != null) {
            this.typeParameterList.getParameter(0).getEditor().getEditorComponent().requestFocus();
        }
    }

    private void createDescription() {
        LabelPrintWriter writer = new LabelPrintWriter();
        if (this.dialogType == 1) {
            ((MethodView)this.method).print(writer, this.typeParameterMap, 0);
        } else {
            this.method.print(writer);
        }
        this.setDescription(writer.getLabel());
        this.setVisible(true);
    }

    public String getNewInstanceName() {
        if (this.instanceNameText == null) {
            return "";
        }
        return this.instanceNameText.getText().trim();
    }

    public Class[] getArgTypes(boolean varArgsExpanded) {
        boolean hasVarArgs;
        Class[] params = this.method.getParameters();
        boolean bl = hasVarArgs = this.method.isVarArgs() && this.parameterList != null && this.parameterList.size() >= params.length;
        if (hasVarArgs && varArgsExpanded) {
            int totalParams = this.parameterList.size();
            Class[] allParams = new Class[totalParams];
            System.arraycopy(params, 0, allParams, 0, params.length);
            Class<?> varArgType = params[params.length - 1].getComponentType();
            for (int i = params.length - 1; i < totalParams; ++i) {
                allParams[i] = varArgType;
            }
            return allParams;
        }
        return params;
    }

    public GenType[] getArgGenTypes(boolean varArgsExpanded, boolean raw) {
        boolean hasVarArgs;
        GenType[] params = this.method.getParamTypes(raw);
        boolean bl = hasVarArgs = this.method.isVarArgs() && this.parameterList != null && this.parameterList.size() >= params.length;
        if (hasVarArgs && varArgsExpanded) {
            int totalParams = this.parameterList.size();
            GenType[] allParams = new GenType[totalParams];
            System.arraycopy(params, 0, allParams, 0, params.length);
            GenType varArgType = ((GenTypeArray)params[params.length - 1]).getBaseType();
            for (int i = params.length - 1; i < totalParams; ++i) {
                allParams[i] = varArgType;
            }
            return allParams;
        }
        return params;
    }

    public TypeParamView[] getFormalTypeParams() {
        View clazz = this.method.getDeclaringView();
        return clazz.getTypeParams();
    }

    public void updateParameters() {
        if (this.parameterList != null) {
            int i;
            Class[] paramClasses = this.getArgTypes(true);
            for (i = 0; i < this.parameterList.size(); ++i) {
                this.history.addCall(paramClasses[i], (String)this.parameterList.getParameter(i).getEditor().getItem());
            }
            for (i = 0; i < this.parameterList.size(); ++i) {
                List historyList = this.history.getHistory(paramClasses[i]);
                this.parameterList.setHistory(i, historyList);
            }
        }
        if (this.typeParameterList != null) {
            int i;
            TypeParamView[] formalTypeParams = this.getFormalTypeParams();
            String[] typeParams = this.getTypeParams();
            for (i = 0; i < typeParams.length; ++i) {
                this.history.addCall(formalTypeParams[i], typeParams[i]);
            }
            for (i = 0; i < typeParams.length; ++i) {
                List historyList = this.history.getHistory(formalTypeParams[i]);
                this.typeParameterList.setHistory(i, historyList);
            }
        }
    }

    private void clearParameters() {
        if (this.parameterList != null) {
            this.parameterList.clear();
        }
        if (this.typeParameterList != null) {
            this.typeParameterList.clear();
        }
    }

    public void focusGained(FocusEvent fe) {
        if (fe.getComponent() instanceof JTextField) {
            this.focusedTextField = (JTextField)fe.getComponent();
            this.focusedTextField.selectAll();
        }
    }

    public void focusLost(FocusEvent fe) {
    }

    private void makeDialog(String className, String instanceName, CallableView method) {
        this.method = method;
        JPanel dialogPanel = new JPanel();
        this.descPanel = new JPanel();
        this.descPanel.setLayout(new BoxLayout(this.descPanel, 1));
        this.descPanel.setAlignmentX(0.0f);
        JPanel centerPanel = new JPanel();
        centerPanel.setLayout(new BoxLayout(centerPanel, 1));
        centerPanel.setAlignmentX(0.0f);
        switch (this.dialogType) {
            case 1: {
                this.makeCallDialog(className, instanceName, method, centerPanel);
                break;
            }
            case 0: {
                this.makeCreateDialog(className, instanceName, method, centerPanel);
                break;
            }
            default: {
                throw new Error("Invalid MethodDialog type " + this.dialogType);
            }
        }
        dialogPanel.setLayout(new BoxLayout(dialogPanel, 1));
        dialogPanel.setBorder(BlueJTheme.generalBorder);
        dialogPanel.add(this.descPanel);
        dialogPanel.add(Box.createVerticalStrut(5));
        dialogPanel.add(new JSeparator());
        dialogPanel.add(Box.createVerticalStrut(5));
        dialogPanel.add(centerPanel);
        dialogPanel.add(this.getErrorLabel());
        super.makeDialog(null, dialogPanel);
    }

    private void makeCallDialog(String className, String instanceName, CallableView method, JPanel panel) {
        this.setTitle(wCallRoutineTitle);
        MethodView methView = (MethodView)method;
        JPanel tmpPanel = new JPanel();
        GridBagLayout gridBag = new GridBagLayout();
        tmpPanel.setLayout(gridBag);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.insets = INSETS;
        this.callLabel = new JLabel("", 4);
        if (method.isStatic()) {
            this.setCallLabel(className, this.methodName);
        } else {
            this.setCallLabel(instanceName, this.methodName);
        }
        if (methView.isMain()) {
            this.defaultParamValue = "{ }";
        }
        this.setPreferredHeight(this.callLabel, this.getComboBoxHeight());
        constraints.anchor = 18;
        gridBag.setConstraints(this.callLabel, constraints);
        tmpPanel.add(this.callLabel);
        JPanel parameterPanel = this.createParameterPanel();
        ++constraints.gridy;
        tmpPanel.add((Component)parameterPanel, constraints);
        tmpPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        tmpPanel.setAlignmentX(0.0f);
        panel.add(tmpPanel);
    }

    private void makeCreateDialog(String className, String instanceName, CallableView method, JPanel panel) {
        JLabel name;
        this.setTitle(wCreateTitle);
        JLabel instName = new JLabel(sNameOfInstance);
        this.instanceNameText = new JTextField(instanceName, 16);
        this.instanceNameText.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MethodDialog.this.doOk();
            }
        });
        this.instanceNameText.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent fe) {
                ((JTextField)fe.getComponent()).selectAll();
            }

            public void focusLost(FocusEvent fe) {
            }
        });
        JPanel tmpPanel = new JPanel();
        GridBagLayout gridBag = new GridBagLayout();
        tmpPanel.setLayout(gridBag);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.insets = INSETS;
        constraints.gridy = 0;
        constraints.gridx = 0;
        gridBag.setConstraints(instName, constraints);
        tmpPanel.add(instName);
        constraints.gridx = 1;
        constraints.gridwidth = 1;
        constraints.anchor = 17;
        constraints.fill = 2;
        gridBag.setConstraints(this.instanceNameText, constraints);
        tmpPanel.add(this.instanceNameText);
        View clazz = method.getDeclaringView();
        if (clazz.isGeneric()) {
            name = null;
            name = this.getFormalTypeParams().length > 1 ? new JLabel(sTypeParameters) : new JLabel(sTypeParameter);
            constraints.gridwidth = 1;
            constraints.gridx = 0;
            ++constraints.gridy;
            constraints.anchor = 18;
            constraints.fill = 0;
            this.setPreferredHeight(name, this.getComboBoxHeight());
            gridBag.setConstraints(name, constraints);
            tmpPanel.add(name);
            JPanel typeParameterPanel = this.createTypeParameterPanel();
            constraints.gridwidth = 1;
            constraints.gridx = 1;
            constraints.anchor = 17;
            constraints.fill = 0;
            tmpPanel.add((Component)typeParameterPanel, constraints);
        }
        if (method.hasParameters()) {
            name = new JLabel("new " + className, 4);
            constraints.gridwidth = 1;
            constraints.gridx = 0;
            ++constraints.gridy;
            constraints.anchor = 12;
            constraints.fill = 0;
            this.setPreferredHeight(name, this.getComboBoxHeight());
            gridBag.setConstraints(name, constraints);
            tmpPanel.add(name);
            constraints.anchor = 17;
            constraints.gridx = 1;
            constraints.fill = 2;
            JPanel parameterPanel = this.createParameterPanel();
            tmpPanel.add((Component)parameterPanel, constraints);
            constraints.gridx = 3;
            constraints.gridy = 0;
            constraints.weightx = 1.0;
            JPanel filler = new JPanel();
            gridBag.setConstraints(filler, constraints);
            tmpPanel.add(filler);
        }
        tmpPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        panel.add((Component)tmpPanel, "North");
    }

    private JPanel createTypeParameterPanel() {
        TypeParamView[] formalTypeParams = this.getFormalTypeParams();
        this.typeParameterList = new ParameterList(formalTypeParams.length, this.defaultParamValue, false);
        for (int i = 0; i < formalTypeParams.length; ++i) {
            List historyList = this.history.getHistory(formalTypeParams[i]);
            JComboBox component = this.createComboBox(historyList);
            this.typeParameterList.addParameter(i, component, formalTypeParams[i].toString());
        }
        String startString = "<";
        String endString = ">";
        ParameterList superParamList = this.typeParameterList;
        return this.createParameterPanel(startString, endString, superParamList);
    }

    private JPanel createParameterPanel() {
        Class[] paramClasses = this.getArgTypes(false);
        String[] paramNames = this.method.getParamNames();
        String[] paramTypes = this.method.getParamTypeStrings();
        this.parameterList = new ParameterList(paramClasses.length, this.defaultParamValue, this.method.isVarArgs());
        for (int i = 0; i < paramTypes.length; ++i) {
            JComponent component;
            List historyList;
            String paramString = paramTypes[i];
            if (paramNames != null) {
                paramString = paramString + " " + paramNames[i];
            }
            if (this.method.isVarArgs() && i == paramClasses.length - 1) {
                historyList = this.history.getHistory(paramClasses[i].getComponentType());
                component = new GrowableBox(new VarArgFactory(this, historyList), 1, MethodDialog.INSETS.top + MethodDialog.INSETS.bottom);
                component.addComponentListener(new ComponentListener(){

                    public void componentResized(ComponentEvent e) {
                        MethodDialog.this.pack();
                    }

                    public void componentMoved(ComponentEvent e) {
                    }

                    public void componentShown(ComponentEvent e) {
                    }

                    public void componentHidden(ComponentEvent e) {
                    }
                });
                this.parameterList.setVarArg((GrowableBox)component, paramString);
                continue;
            }
            historyList = this.history.getHistory(paramClasses[i]);
            component = this.createComboBox(historyList);
            this.parameterList.addParameter(i, (JComboBox)component, paramString);
        }
        return this.createParameterPanel("(", ")", this.parameterList);
    }

    private JPanel createParameterPanel(String startString, String endString, ParameterList parameterList) {
        JPanel tmpPanel = new JPanel();
        GridBagLayout gridBag = new GridBagLayout();
        tmpPanel.setLayout(gridBag);
        JLabel startParenthesis = new JLabel(startString);
        double comboHeight = this.getComboBoxHeight();
        double parenthesisHeight = startParenthesis.getPreferredSize().getHeight();
        double parenthesisScale = comboHeight / parenthesisHeight;
        Font f = startParenthesis.getFont();
        Font parenthesisFont = f.deriveFont(AffineTransform.getScaleInstance(parenthesisScale, parenthesisScale));
        startParenthesis.setFont(parenthesisFont);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.insets = INSETS;
        constraints.gridx = 0;
        constraints.anchor = 12;
        tmpPanel.add((Component)startParenthesis, constraints);
        for (int i = 0; i < parameterList.size(); ++i) {
            constraints.gridx = 1;
            constraints.gridy = i;
            constraints.anchor = 17;
            JComponent component = parameterList.getParameterComponent(i);
            gridBag.setConstraints(component, constraints);
            tmpPanel.add(component);
            JLabel eol = new JLabel(",", 2);
            JLabel type = new JLabel(" " + parameterList.getType(i), 2);
            if (i == parameterList.size() - 1) {
                eol.setText(endString);
                eol.setFont(parenthesisFont);
                if (parameterList.size() == 1) {
                    type = null;
                } else {
                    this.setPreferredHeight(type, comboHeight);
                    constraints.anchor = 11;
                }
            }
            if (type != null) {
                constraints.gridx = 3;
                tmpPanel.add((Component)type, constraints);
            }
            constraints.gridx = 2;
            this.setPreferredHeight(eol, comboHeight);
            constraints.anchor = 16;
            gridBag.setConstraints(eol, constraints);
            tmpPanel.add(eol);
        }
        return tmpPanel;
    }

    private void setPreferredHeight(JComponent c, double height) {
        int lastTypeWidth = (int)c.getPreferredSize().getWidth();
        c.setPreferredSize(new Dimension(lastTypeWidth, (int)height));
    }

    private double getComboBoxHeight() {
        JComboBox comboBox = this.createComboBox(new ArrayList());
        double comboHeight = comboBox.getPreferredSize().getHeight();
        return comboHeight;
    }

    private void setCallLabel(String instanceName, String methodName) {
        if (this.callLabel != null) {
            this.callLabel.setText(JavaNames.stripPrefix(instanceName) + "." + methodName);
        }
    }

    private JComboBox createComboBox(List history) {
        if (history == null) {
            history = new ArrayList();
        }
        JComboBox<Object> component = new JComboBox<Object>(history.toArray());
        component.insertItemAt(this.defaultParamValue, 0);
        component.setEditable(true);
        component.getEditor().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MethodDialog.this.doOk();
            }
        });
        ((JTextField)component.getEditor().getEditorComponent()).addFocusListener(this);
        return component;
    }

    public void setEnabled(boolean state) {
        this.okButton.setEnabled(state);
        super.setEnabled(state);
        if (state) {
            this.okCalled = false;
        }
    }

    public static class ParameterList {
        private List parameters;
        private List types;
        private boolean isVarArgs;
        private String defaultParamValue;

        public ParameterList(int initialSize, String defaultParamValue, boolean isVarArgs) {
            this.parameters = new ArrayList(initialSize);
            this.types = new ArrayList(initialSize);
            this.defaultParamValue = defaultParamValue;
            this.isVarArgs = isVarArgs;
        }

        public JComboBox getParameter(int index) {
            if (this.isVarArgs && index >= this.parameters.size() - 1) {
                GrowableBox box = this.getGrowableBox();
                int boxIndex = index - this.parameters.size() + 1;
                return (JComboBox)((Container)box.getComponent(boxIndex)).getComponent(0);
            }
            return (JComboBox)this.parameters.get(index);
        }

        public JComponent getParameterComponent(int index) {
            return (JComponent)this.parameters.get(index);
        }

        public String getType(int index) {
            if (this.isVarArgs && index >= this.parameters.size() - 1) {
                return (String)this.types.get(this.types.size() - 1);
            }
            return (String)this.types.get(index);
        }

        private GrowableBox getGrowableBox() {
            if (this.parameters.size() < 1) {
                return null;
            }
            Object c = this.parameters.get(this.parameters.size() - 1);
            if (c instanceof GrowableBox) {
                return (GrowableBox)this.parameters.get(this.parameters.size() - 1);
            }
            return null;
        }

        public void addParameter(int index, JComboBox component, String type) {
            this.parameters.add(index, component);
            this.types.add(index, type);
        }

        public void setVarArg(GrowableBox component, String type) {
            GrowableBox box = this.getGrowableBox();
            if (box != null) {
                this.parameters.remove(box);
            }
            this.parameters.add(component);
            this.types.add(type);
        }

        public int size() {
            if (this.isVarArgs) {
                return this.parameters.size() + this.getGrowableBox().getComponentCountWithoutEmpty() - 1;
            }
            return this.parameters.size();
        }

        public void clear() {
            Iterator iter = this.parameters.iterator();
            while (iter.hasNext()) {
                Object element = iter.next();
                if (this.isVarArgs && !iter.hasNext()) {
                    ((GrowableBox)element).clear();
                    continue;
                }
                ((JComboBox)element).setSelectedIndex(0);
            }
        }

        public void setHistory(int i, List historyList) {
            if (historyList == null) {
                return;
            }
            if (this.isVarArgs && i >= this.parameters.size() - 1) {
                GrowableBox varArgs = this.getGrowableBox();
                VarArgFactory factory = (VarArgFactory)varArgs.getComponentFactory();
                factory.setHistory(historyList);
            } else {
                this.getParameter(i).setModel(new DefaultComboBoxModel<Object>(historyList.toArray()));
                this.getParameter(i).insertItemAt(this.defaultParamValue, 0);
            }
        }
    }

    public static class VarArgFactory
    implements ComponentFactory {
        private List history;
        private MethodDialog dialog;

        public VarArgFactory(MethodDialog dialog, List history) {
            this.history = history;
            this.dialog = dialog;
        }

        public void setHistory(List history) {
            this.history = history;
        }

        public JComponent createComponent(JButton addButton, JButton removeButton) {
            Box container = new Box(0);
            JComboBox comboBox = this.dialog.createComboBox(this.history);
            comboBox.setSelectedIndex(0);
            container.add(comboBox);
            container.add(Box.createHorizontalStrut(5));
            container.add(new JLabel(" , "));
            container.add(Box.createHorizontalStrut(5));
            container.add(addButton);
            container.add(Box.createHorizontalStrut(5));
            container.add(removeButton);
            return container;
        }
    }
}

