/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugmgr;

import bluej.BlueJTheme;
import bluej.Config;
import bluej.classmgr.ClassMgr;
import bluej.debugmgr.ClassHistory;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.utility.DialogManager;
import bluej.utility.Utility;
import bluej.views.CallableView;
import bluej.views.View;
import bluej.views.ViewFilter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class LibraryCallDialog
extends JDialog
implements ActionListener,
ListSelectionListener {
    private static final String[] clickHere = new String[]{"    ", "    " + Config.getString("callLibraryDialog.clickHere1"), "    " + Config.getString("callLibraryDialog.clickHere2")};
    private static final String[] classNotFound = new String[]{"    ", "    " + Config.getString("callLibraryDialog.classNotFound1"), "    " + Config.getString("callLibraryDialog.classNotFound2")};
    private JComboBox classField;
    private JList methodList;
    private JButton docButton;
    private JButton okButton;
    private JButton cancelButton;
    private ClassHistory history;
    private Package pkg;
    private CallableView viewToCall;
    private List currentViews;

    public LibraryCallDialog(PkgMgrFrame pmf) {
        super(pmf, Config.getString("callLibraryDialog.title"), false);
        this.pkg = pmf.getPackage();
        this.currentViews = new ArrayList();
        this.viewToCall = null;
        this.history = ClassHistory.getClassHistory(10);
        this.makeDialog();
    }

    public void setVisible(boolean show) {
        super.setVisible(show);
        if (show) {
            this.okButton.setEnabled(false);
            this.classField.setModel(new DefaultComboBoxModel<Object>(this.history.getHistory().toArray()));
            this.classSelected();
            this.classField.requestFocus();
        }
    }

    public void actionPerformed(ActionEvent event) {
        Object eventSource = event.getSource();
        if (eventSource == this.classField) {
            this.classSelected();
        } else if (eventSource == this.docButton) {
            this.showDocumentation();
        } else if (eventSource == this.okButton) {
            this.doOk();
        } else if (eventSource == this.cancelButton) {
            this.doCancel();
        }
    }

    private void showDocumentation() {
        String className = (String)this.classField.getEditor().getItem();
        if (className.indexOf(46) == -1) {
            className = "java.lang." + className;
        }
        Utility.showClassDocumentation(className, "#constructor_summary");
    }

    private void doOk() {
        if (this.viewToCall == null) {
            return;
        }
        this.history.add((String)this.classField.getEditor().getItem());
        this.setVisible(false);
        this.pkg.getEditor().raiseMethodCallEvent(this.pkg, this.viewToCall);
    }

    private void doCancel() {
        this.setVisible(false);
    }

    private void classSelected() {
        boolean loaded;
        File file;
        Class<?> cl = null;
        this.currentViews.clear();
        this.viewToCall = null;
        this.okButton.setEnabled(false);
        String className = (String)this.classField.getEditor().getItem();
        if (className.length() == 0) {
            this.displayTextInClassList(clickHere);
            return;
        }
        try {
            file = this.pkg.getProject().getProjectDir();
            cl = Class.forName(className, true, ClassMgr.getProjectLoader(file));
            loaded = true;
        }
        catch (Exception exc) {
            loaded = false;
        }
        if (!loaded) {
            try {
                file = this.pkg.getProject().getProjectDir();
                cl = Class.forName("java.lang." + className, true, ClassMgr.getProjectLoader(file));
            }
            catch (Exception exc) {
                this.displayTextInClassList(classNotFound);
                return;
            }
        }
        this.displayMethodsForClass(cl);
    }

    private void displayMethodsForClass(Class cl) {
        View classView = View.getView(cl);
        ArrayList list = new ArrayList();
        CallableView[] constructors = classView.getConstructors();
        ViewFilter filter = new ViewFilter(196609);
        this.addMethods(list, constructors, filter);
        CallableView[] methods = classView.getAllMethods();
        filter = new ViewFilter(65549);
        this.addMethods(list, methods, filter);
        this.methodList.setListData(list.toArray());
        this.methodList.clearSelection();
        this.methodList.setEnabled(true);
        this.docButton.setEnabled(true);
    }

    private void displayTextInClassList(String[] text) {
        this.methodList.setListData(text);
        this.methodList.setEnabled(false);
        this.docButton.setEnabled(false);
    }

    public void addMethods(List list, CallableView[] methods, ViewFilter filter) {
        for (int i = 0; i < methods.length; ++i) {
            if (!filter.accept(methods[i])) continue;
            this.currentViews.add(methods[i]);
            list.add(methods[i].getShortDesc());
        }
    }

    public void valueChanged(ListSelectionEvent event) {
        if (event.getValueIsAdjusting()) {
            return;
        }
        int index = this.methodList.getSelectedIndex();
        if (index == -1) {
            return;
        }
        String text = (String)this.methodList.getSelectedValue();
        if (text.charAt(0) == ' ') {
            return;
        }
        this.viewToCall = (CallableView)this.currentViews.get(index);
        this.okButton.setEnabled(true);
    }

    private void makeDialog() {
        JPanel contentPane = (JPanel)this.getContentPane();
        JPanel classPanel = new JPanel(new BorderLayout(4, 6));
        classPanel.add((Component)new JLabel(Config.getString("callLibraryDialog.classLabel")), "West");
        this.classField = new JComboBox<Object>(this.history.getHistory().toArray());
        this.classField.setEditable(true);
        this.classField.setMaximumRowCount(10);
        JTextField textField = (JTextField)this.classField.getEditor().getEditorComponent();
        textField.setColumns(16);
        this.classField.addActionListener(this);
        classPanel.add((Component)this.classField, "Center");
        this.docButton = new JButton(Config.getString("callLibraryDialog.docButton"));
        this.docButton.addActionListener(this);
        this.docButton.setEnabled(false);
        classPanel.add((Component)this.docButton, "East");
        JPanel centrePanel = new JPanel(new BorderLayout());
        this.methodList = new JList();
        this.methodList.setSelectionMode(0);
        this.methodList.addListSelectionListener(this);
        this.methodList.setVisibleRowCount(8);
        JScrollPane methodScrollPane = new JScrollPane(this.methodList);
        methodScrollPane.setColumnHeaderView(new JLabel(Config.getString("callLibraryDialog.listHeading")));
        MouseAdapter mouseListener = new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    LibraryCallDialog.this.doOk();
                }
            }
        };
        this.methodList.addMouseListener(mouseListener);
        centrePanel.add((Component)methodScrollPane, "Center");
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(2));
        this.okButton = BlueJTheme.getOkButton();
        this.okButton.addActionListener(this);
        this.cancelButton = BlueJTheme.getCancelButton();
        this.cancelButton.addActionListener(this);
        buttonPanel.add(this.okButton);
        buttonPanel.add(this.cancelButton);
        this.getRootPane().setDefaultButton(this.okButton);
        this.okButton.setEnabled(false);
        contentPane.setLayout(new BorderLayout(6, 6));
        contentPane.setBorder(BlueJTheme.generalBorder);
        contentPane.add((Component)classPanel, "North");
        contentPane.add((Component)centrePanel, "Center");
        contentPane.add((Component)buttonPanel, "South");
        this.pack();
        DialogManager.centreDialog(this);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent event) {
                LibraryCallDialog.this.setVisible(false);
            }
        });
    }
}

