/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugmgr;

import bluej.BlueJTheme;
import bluej.Config;
import bluej.debugger.Debugger;
import bluej.debugger.DebuggerClass;
import bluej.debugger.DebuggerEvent;
import bluej.debugger.DebuggerObject;
import bluej.debugger.DebuggerThread;
import bluej.debugger.DebuggerThreadTreeModel;
import bluej.debugmgr.inspector.ObjectInspector;
import bluej.pkgmgr.Project;
import bluej.utility.Debug;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class ExecControls
extends JFrame
implements ListSelectionListener,
TreeSelectionListener,
TreeModelListener {
    private static final String stackTitle = Config.getString("debugger.execControls.stackTitle");
    private static final String staticTitle = Config.getString("debugger.execControls.staticTitle");
    private static final String instanceTitle = Config.getString("debugger.execControls.instanceTitle");
    private static final String localTitle = Config.getString("debugger.execControls.localTitle");
    private static final String threadTitle = Config.getString("debugger.execControls.threadTitle");
    private static final String haltButtonText = Config.getString("debugger.execControls.haltButtonText");
    private static final String stepButtonText = Config.getString("debugger.execControls.stepButtonText");
    private static final String stepIntoButtonText = Config.getString("debugger.execControls.stepIntoButtonText");
    private static final String continueButtonText = Config.getString("debugger.execControls.continueButtonText");
    private static final String terminateButtonText = Config.getString("debugger.execControls.terminateButtonText");
    private static final int SHORTCUT_MASK = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
    private static String[] empty = new String[0];
    private JTree threadTree;
    private DebuggerThreadTreeModel threadModel;
    private JSplitPane mainPanel;
    private JList stackList;
    private JList staticList;
    private JList instanceList;
    private JList localList;
    private JButton stopButton;
    private JButton stepButton;
    private JButton stepIntoButton;
    private JButton continueButton;
    private JButton terminateButton;
    private CardLayout cardLayout;
    private JPanel flipPanel;
    private JCheckBoxMenuItem systemThreadItem;
    private Project project;
    private Debugger debugger = null;
    private DebuggerThread selectedThread;
    private DebuggerClass currentClass;
    private DebuggerObject currentObject;
    private int currentFrame = 0;
    private boolean autoSelectionEvent = false;

    public ExecControls(Project project, Debugger debugger) {
        super(Config.getString("debugger.execControls.windowTitle"));
        if (project == null || debugger == null) {
            throw new NullPointerException("project or debugger null in ExecControls");
        }
        this.project = project;
        this.debugger = debugger;
        this.createWindow();
    }

    public void showHide(boolean show) {
        this.setVisible(show);
    }

    public void valueChanged(ListSelectionEvent event) {
        if (event.getValueIsAdjusting()) {
            return;
        }
        if (event.getSource() == this.stackList) {
            this.selectStackFrame(this.stackList.getSelectedIndex());
        }
    }

    public void valueChanged(TreeSelectionEvent event) {
        Object src = event.getSource();
        if (src == this.threadTree) {
            this.clearThreadDetails();
            if (!event.isAddedPath()) {
                this.setSelectedThread(null);
                return;
            }
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.threadTree.getLastSelectedPathComponent();
            if (node == null) {
                return;
            }
            DebuggerThread dt = this.threadModel.getNodeAsDebuggerThread(node);
            this.setSelectedThread(dt);
        }
    }

    public void treeNodesChanged(TreeModelEvent e) {
        if (this.selectedThread == null) {
            return;
        }
        Object[] nodes = e.getChildren();
        for (int i = 0; i < nodes.length; ++i) {
            if (nodes[i] == null || !this.selectedThread.equals(this.threadModel.getNodeAsDebuggerThread(nodes[i]))) continue;
            this.setSelectedThread(this.selectedThread);
        }
    }

    public void treeNodesInserted(TreeModelEvent e) {
    }

    public void treeNodesRemoved(TreeModelEvent e) {
    }

    public void treeStructureChanged(TreeModelEvent e) {
    }

    private void listDoubleClick(MouseEvent event) {
        Component src = event.getComponent();
        if (src == this.staticList && this.staticList.getSelectedIndex() >= 0) {
            this.viewStaticField(this.staticList.getSelectedIndex());
        } else if (src == this.instanceList && this.instanceList.getSelectedIndex() >= 0) {
            this.viewInstanceField(this.instanceList.getSelectedIndex());
        } else if (src == this.localList && this.localList.getSelectedIndex() >= 0) {
            this.viewLocalVar(this.localList.getSelectedIndex());
        }
    }

    public void makeSureThreadIsSelected(DebuggerThread dt) {
        TreePath tp = this.threadModel.findNodeForThread(dt);
        if (tp != null) {
            if (!tp.equals(this.threadTree.getSelectionPath())) {
                this.threadTree.clearSelection();
                this.threadTree.addSelectionPath(tp);
            }
        } else {
            Debug.message("Thread " + dt + " no longer available for selection");
        }
        this.mainPanel.paintImmediately(0, 0, this.mainPanel.getSize().width, this.mainPanel.getSize().height);
    }

    private void setSelectedThread(DebuggerThread dt) {
        this.selectedThread = dt;
        if (dt == null) {
            this.stopButton.setEnabled(false);
            this.stepButton.setEnabled(false);
            this.stepIntoButton.setEnabled(false);
            this.continueButton.setEnabled(false);
            this.cardLayout.show(this.flipPanel, "blank");
        } else {
            boolean isSuspended = this.selectedThread.isSuspended();
            this.stopButton.setEnabled(!isSuspended);
            this.stepButton.setEnabled(isSuspended);
            this.stepIntoButton.setEnabled(isSuspended);
            this.continueButton.setEnabled(isSuspended);
            this.cardLayout.show(this.flipPanel, isSuspended ? "split" : "blank");
            this.setThreadDetails();
        }
    }

    private void setThreadDetails() {
        this.stackList.setFixedCellWidth(-1);
        List stack = this.selectedThread.getStack();
        if (stack.size() > 0) {
            this.stackList.setListData(stack.toArray(new Object[0]));
            this.autoSelectionEvent = true;
            this.selectStackFrame(0);
            this.autoSelectionEvent = false;
        }
    }

    private void clearThreadDetails() {
        this.stackList.setListData(empty);
        this.staticList.setListData(empty);
        this.instanceList.setListData(empty);
        this.localList.setListData(empty);
    }

    private void selectStackFrame(int index) {
        if (this.stackList.getSelectedIndex() != index) {
            this.stackList.setSelectedIndex(index);
        } else if (index >= 0) {
            this.setStackFrameDetails(index);
            this.selectedThread.setSelectedFrame(index);
            if (!this.autoSelectionEvent) {
                this.project.debuggerEvent(new DebuggerEvent(this, 6, this.selectedThread));
            }
            this.currentFrame = index;
        }
    }

    private void setStackFrameDetails(int frameNo) {
        this.currentClass = this.selectedThread.getCurrentClass(frameNo);
        this.currentObject = this.selectedThread.getCurrentObject(frameNo);
        if (this.currentClass != null) {
            this.staticList.setFixedCellWidth(-1);
            this.staticList.setListData(this.currentClass.getStaticFields(false).toArray(new Object[0]));
        }
        if (this.currentObject != null) {
            this.instanceList.setFixedCellWidth(-1);
            this.instanceList.setListData(this.currentObject.getInstanceFields(false).toArray(new Object[0]));
        }
        if (this.selectedThread != null) {
            this.localList.setFixedCellWidth(-1);
            this.localList.setListData(this.selectedThread.getLocalVariables(frameNo).toArray(new Object[0]));
        }
    }

    private void viewStaticField(int index) {
        if (this.currentClass.staticFieldIsObject(index)) {
            ObjectInspector objectInspector = ObjectInspector.getInstance(this.currentClass.getStaticFieldObject(index), null, null, null, this);
        }
    }

    private void viewInstanceField(int index) {
        if (this.currentObject.instanceFieldIsObject(index)) {
            ObjectInspector objectInspector = ObjectInspector.getInstance(this.currentObject.getInstanceFieldObject(index), null, null, null, this);
        }
    }

    private void viewLocalVar(int index) {
        if (this.selectedThread.varIsObject(this.currentFrame, index)) {
            ObjectInspector objectInspector = ObjectInspector.getInstance(this.selectedThread.getStackObject(this.currentFrame, index), null, null, null, this);
        }
    }

    private void createWindow() {
        this.setIconImage(BlueJTheme.getIconImage());
        this.setJMenuBar(this.makeMenuBar());
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout(6, 6));
        contentPane.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        JPanel buttonBox = new JPanel();
        buttonBox.setLayout(new GridLayout(1, 0));
        this.stopButton = this.addButton(new StopAction(), buttonBox);
        this.stepButton = this.addButton(new StepAction(), buttonBox);
        this.stepIntoButton = this.addButton(new StepIntoAction(), buttonBox);
        this.continueButton = this.addButton(new ContinueAction(), buttonBox);
        this.terminateButton = this.addButton(new TerminateAction(), buttonBox);
        this.terminateButton.setEnabled(true);
        contentPane.add((Component)buttonBox, "South");
        MouseAdapter mouseListener = new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ExecControls.this.listDoubleClick(e);
                }
            }
        };
        JScrollPane staticScrollPane = new JScrollPane();
        this.staticList = new JList(new DefaultListModel());
        this.staticList.setSelectionMode(0);
        this.staticList.addListSelectionListener(this);
        this.staticList.setVisibleRowCount(3);
        this.staticList.setFixedCellWidth(150);
        this.staticList.addMouseListener(mouseListener);
        staticScrollPane.setViewportView(this.staticList);
        JLabel lbl = new JLabel(staticTitle);
        lbl.setOpaque(true);
        staticScrollPane.setColumnHeaderView(lbl);
        JScrollPane instanceScrollPane = new JScrollPane();
        this.instanceList = new JList(new DefaultListModel());
        this.instanceList.setSelectionMode(0);
        this.instanceList.addListSelectionListener(this);
        this.instanceList.setVisibleRowCount(4);
        this.instanceList.setFixedCellWidth(150);
        this.instanceList.addMouseListener(mouseListener);
        instanceScrollPane.setViewportView(this.instanceList);
        JLabel lbl2 = new JLabel(instanceTitle);
        lbl2.setOpaque(true);
        instanceScrollPane.setColumnHeaderView(lbl2);
        JScrollPane localScrollPane = new JScrollPane();
        this.localList = new JList(new DefaultListModel());
        this.localList.setSelectionMode(0);
        this.localList.addListSelectionListener(this);
        this.localList.setVisibleRowCount(4);
        this.localList.setFixedCellWidth(150);
        this.localList.addMouseListener(mouseListener);
        localScrollPane.setViewportView(this.localList);
        JLabel lbl3 = new JLabel(localTitle);
        lbl3.setOpaque(true);
        localScrollPane.setColumnHeaderView(lbl3);
        JSplitPane innerVarPane = new JSplitPane(0, staticScrollPane, instanceScrollPane);
        innerVarPane.setDividerSize(6);
        innerVarPane.setBorder(null);
        JSplitPane varPane = new JSplitPane(0, innerVarPane, localScrollPane);
        varPane.setDividerSize(6);
        varPane.setBorder(null);
        this.stackList = new JList(new DefaultListModel());
        this.stackList.setSelectionMode(0);
        this.stackList.addListSelectionListener(this);
        this.stackList.setFixedCellWidth(150);
        JScrollPane stackScrollPane = new JScrollPane(this.stackList);
        JLabel lbl4 = new JLabel(stackTitle);
        lbl4.setOpaque(true);
        stackScrollPane.setColumnHeaderView(lbl4);
        JSplitPane splitPane = new JSplitPane(1, stackScrollPane, varPane);
        splitPane.setDividerSize(6);
        splitPane.setBorder(null);
        JPanel threadPanel = new JPanel(new BorderLayout());
        MouseAdapter treeMouseListener = new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                DebuggerThread dt;
                DefaultMutableTreeNode node;
                TreePath selPath = ExecControls.this.threadTree.getPathForLocation(e.getX(), e.getY());
                if (selPath != null && (node = (DefaultMutableTreeNode)selPath.getLastPathComponent()) != null && (dt = ExecControls.this.threadModel.getNodeAsDebuggerThread(node)) != null) {
                    ExecControls.this.setSelectedThread(dt);
                }
            }
        };
        this.threadModel = this.debugger.getThreadTreeModel();
        this.threadModel.setSyncMechanism(new DebuggerThreadTreeModel.SyncMechanism(){

            public void invokeLater(Runnable r) {
                if (EventQueue.isDispatchThread()) {
                    r.run();
                } else {
                    EventQueue.invokeLater(r);
                }
            }
        });
        this.threadModel.addTreeModelListener(this);
        this.threadTree = new JTree(this.threadModel);
        this.threadTree.getSelectionModel().setSelectionMode(1);
        this.threadTree.setVisibleRowCount(5);
        this.threadTree.setShowsRootHandles(false);
        this.threadTree.setRootVisible(false);
        this.threadTree.addTreeSelectionListener(this);
        this.threadTree.addMouseListener(treeMouseListener);
        JScrollPane threadScrollPane = new JScrollPane(this.threadTree);
        lbl4 = new JLabel(threadTitle);
        lbl4.setOpaque(true);
        threadScrollPane.setColumnHeaderView(lbl4);
        threadPanel.add((Component)threadScrollPane, "Center");
        this.flipPanel = new JPanel();
        this.cardLayout = new CardLayout();
        this.flipPanel.setLayout(this.cardLayout);
        this.flipPanel.add((Component)splitPane, "split");
        JPanel tempPanel = new JPanel();
        JLabel infoLabel = new JLabel(Config.getString("debugger.threadRunning"));
        infoLabel.setForeground(Color.gray);
        tempPanel.add(infoLabel);
        this.flipPanel.add((Component)tempPanel, "blank");
        this.mainPanel = new JSplitPane(0, threadPanel, this.flipPanel);
        this.mainPanel.setDividerSize(6);
        contentPane.add((Component)this.mainPanel, "Center");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent event) {
                Window win = (Window)event.getSource();
                win.setVisible(false);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentMoved(ComponentEvent event) {
                Config.putLocation("bluej.debugger", ExecControls.this.getLocation());
            }
        });
        this.setLocation(Config.getLocation("bluej.debugger"));
        this.pack();
    }

    private JMenuBar makeMenuBar() {
        JMenuBar menubar = new JMenuBar();
        JMenu menu = new JMenu(Config.getString("terminal.options"));
        this.systemThreadItem = new JCheckBoxMenuItem(new HideSystemThreadAction());
        this.systemThreadItem.setSelected(true);
        this.debugger.hideSystemThreads(true);
        menu.add(this.systemThreadItem);
        menu.add(new JSeparator());
        JMenuItem item = menu.add(new CloseAction());
        menubar.add(menu);
        return menubar;
    }

    private JButton addButton(Action action, JPanel panel) {
        JButton button = new JButton(action);
        button.setVerticalTextPosition(3);
        button.setHorizontalTextPosition(0);
        button.setEnabled(false);
        panel.add(button);
        return button;
    }

    private class HideSystemThreadAction
    extends AbstractAction {
        public HideSystemThreadAction() {
            super(Config.getString("debugger.hideSystemThreads"));
        }

        public void actionPerformed(ActionEvent e) {
            ExecControls.this.debugger.hideSystemThreads(ExecControls.this.systemThreadItem.isSelected());
        }
    }

    private class CloseAction
    extends AbstractAction {
        public CloseAction() {
            super(Config.getString("close"));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(87, SHORTCUT_MASK));
        }

        public void actionPerformed(ActionEvent e) {
            ExecControls.this.setVisible(false);
        }
    }

    private class TerminateAction
    extends AbstractAction {
        public TerminateAction() {
            super(terminateButtonText, Config.getImageAsIcon("image.debug.terminate"));
        }

        public void actionPerformed(ActionEvent e) {
            try {
                ExecControls.this.project.restartVM();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    private class ContinueAction
    extends AbstractAction {
        public ContinueAction() {
            super(continueButtonText, Config.getImageAsIcon("image.debug.continue"));
        }

        public void actionPerformed(ActionEvent e) {
            if (ExecControls.this.selectedThread == null) {
                return;
            }
            ExecControls.this.clearThreadDetails();
            ExecControls.this.project.removeStepMarks();
            if (ExecControls.this.selectedThread.isSuspended()) {
                ExecControls.this.selectedThread.cont();
            }
        }
    }

    private class StepIntoAction
    extends AbstractAction {
        public StepIntoAction() {
            super(stepIntoButtonText, Config.getImageAsIcon("image.debug.step_into"));
        }

        public void actionPerformed(ActionEvent e) {
            if (ExecControls.this.selectedThread == null) {
                return;
            }
            ExecControls.this.clearThreadDetails();
            ExecControls.this.project.removeStepMarks();
            if (ExecControls.this.selectedThread.isSuspended()) {
                ExecControls.this.selectedThread.stepInto();
            }
        }
    }

    private class StepAction
    extends AbstractAction {
        public StepAction() {
            super(stepButtonText, Config.getImageAsIcon("image.debug.step"));
        }

        public void actionPerformed(ActionEvent e) {
            if (ExecControls.this.selectedThread == null) {
                return;
            }
            ExecControls.this.clearThreadDetails();
            ExecControls.this.project.removeStepMarks();
            if (ExecControls.this.selectedThread.isSuspended()) {
                ExecControls.this.selectedThread.step();
            }
            ObjectInspector.updateInspectors();
        }
    }

    private class StopAction
    extends AbstractAction {
        public StopAction() {
            super(haltButtonText, Config.getImageAsIcon("image.debug.stop"));
        }

        public void actionPerformed(ActionEvent e) {
            if (ExecControls.this.selectedThread == null) {
                return;
            }
            ExecControls.this.clearThreadDetails();
            if (!ExecControls.this.selectedThread.isSuspended()) {
                ExecControls.this.selectedThread.halt();
            }
        }
    }
}

