/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugger.jdi;

import bluej.BlueJEvent;
import bluej.Config;
import bluej.debugger.Debugger;
import bluej.debugger.DebuggerClass;
import bluej.debugger.DebuggerEvent;
import bluej.debugger.DebuggerListener;
import bluej.debugger.DebuggerObject;
import bluej.debugger.DebuggerTerminal;
import bluej.debugger.DebuggerTestResult;
import bluej.debugger.DebuggerThreadTreeModel;
import bluej.debugger.ExceptionDescription;
import bluej.debugger.SourceLocation;
import bluej.debugger.gentype.GenType;
import bluej.debugger.jdi.JdiClass;
import bluej.debugger.jdi.JdiObject;
import bluej.debugger.jdi.JdiReflective;
import bluej.debugger.jdi.JdiTestResult;
import bluej.debugger.jdi.JdiTestResultError;
import bluej.debugger.jdi.JdiTestResultFailure;
import bluej.debugger.jdi.JdiThread;
import bluej.debugger.jdi.JdiThreadNode;
import bluej.debugger.jdi.JdiThreadSet;
import bluej.debugger.jdi.JdiThreadTreeModel;
import bluej.debugger.jdi.JdiUtils;
import bluej.debugger.jdi.JdiVmCreationException;
import bluej.debugger.jdi.VMReference;
import bluej.utility.Debug;
import bluej.utility.JavaNames;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.InvocationException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StringReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.event.EventListenerList;

public class JdiDebugger
extends Debugger {
    private static final int loaderPriority = 3;
    private volatile boolean vmRunning = false;
    private boolean autoRestart = true;
    private boolean selfRestart = false;
    private VMReference vmRef;
    private MachineLoaderThread machineLoader;
    private JdiThreadSet allThreads;
    private JdiThreadTreeModel treeModel;
    private EventListenerList listenerList = new EventListenerList();
    private File startingDirectory;
    private DebuggerTerminal terminal;
    private Set usedNames;
    private boolean hideSystemThreads;
    private int machineState = 1;
    static /* synthetic */ Class class$bluej$debugger$DebuggerListener;

    public JdiDebugger(File startingDirectory, DebuggerTerminal terminal) {
        this.startingDirectory = startingDirectory;
        this.terminal = terminal;
        this.allThreads = new JdiThreadSet();
        this.treeModel = new JdiThreadTreeModel(new JdiThreadNode());
        this.usedNames = new TreeSet();
        this.hideSystemThreads = true;
    }

    public synchronized void launch() {
        if (this.vmRunning) {
            throw new IllegalStateException("JdiDebugger.launch() was called but the debugger was already loaded");
        }
        if (this.machineLoader != null && !this.selfRestart) {
            return;
        }
        this.autoRestart = true;
        this.raiseStateChangeEvent(1);
        if (!this.selfRestart) {
            this.machineLoader = new MachineLoaderThread();
        }
        this.selfRestart = false;
        this.machineLoader.setPriority(3);
        this.machineLoader.start();
    }

    public synchronized void close(boolean restart) {
        if (this.vmRunning) {
            this.autoRestart = restart;
            this.selfRestart = restart;
            if (this.selfRestart) {
                this.machineLoader = new MachineLoaderThread();
            }
            this.vmRef.close();
        } else if (!restart) {
            this.autoRestart = false;
            this.selfRestart = false;
            this.machineLoader = null;
            if (this.machineLoader != null && !this.selfRestart) {
                this.vmRef.close();
            }
        }
    }

    public void addDebuggerListener(DebuggerListener l) {
        this.listenerList.add(class$bluej$debugger$DebuggerListener == null ? (class$bluej$debugger$DebuggerListener = JdiDebugger.class$("bluej.debugger.DebuggerListener")) : class$bluej$debugger$DebuggerListener, l);
    }

    public void removeDebuggerListener(DebuggerListener l) {
        this.listenerList.remove(class$bluej$debugger$DebuggerListener == null ? (class$bluej$debugger$DebuggerListener = JdiDebugger.class$("bluej.debugger.DebuggerListener")) : class$bluej$debugger$DebuggerListener, l);
    }

    public String guessNewName(String className) {
        String baseName = JavaNames.getBase(className = className.replace('[', ' ').replace(']', ' ').trim());
        int stringEndIndex = baseName.length() > 8 ? 8 : baseName.length();
        String newName = Character.toLowerCase(baseName.charAt(0)) + baseName.substring(1, stringEndIndex);
        int num = 1;
        while (this.usedNames.contains(newName + num)) {
            ++num;
        }
        return newName + num;
    }

    public String guessNewName(DebuggerObject obj) {
        String name = null;
        DebuggerClass cls = obj.getClassRef();
        if (cls.isEnum()) {
            ObjectReference val = obj.getObjectReference();
            name = JdiUtils.getJdiUtils().getValueString(val);
        }
        if (name == null) {
            name = cls.getName();
        }
        return this.guessNewName(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void newClassLoader(String classPath) {
        VMReference vmr;
        JdiDebugger jdiDebugger = this;
        synchronized (jdiDebugger) {
            if (!this.vmRunning) {
                return;
            }
            this.usedNames.clear();
            vmr = this.getVM();
        }
        if (vmr != null) {
            try {
                vmr.newClassLoader(classPath);
            }
            catch (VMDisconnectedException vMDisconnectedException) {
                // empty catch block
            }
        }
    }

    public void newClassLoaderLeavingBreakpoints(String classPath) {
        List savedBreakpoints = this.getVM().getBreakpoints();
        this.newClassLoader(classPath);
        this.getVM().restoreBreakpoints(savedBreakpoints);
    }

    public boolean addObject(String newInstanceName, DebuggerObject dob) {
        this.getVM().addObject(newInstanceName, ((JdiObject)dob).getObjectReference());
        this.usedNames.add(newInstanceName);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeObject(String instanceName) {
        VMReference vmr;
        JdiDebugger jdiDebugger = this;
        synchronized (jdiDebugger) {
            if (!this.vmRunning) {
                return;
            }
            vmr = this.getVM();
        }
        Object[] args = new Object[]{instanceName};
        vmr.removeObject(instanceName);
    }

    public Map getObjects() {
        throw new IllegalStateException("not implemented");
    }

    public Map runTestSetUp(String className) {
        ArrayReference arrayRef = null;
        try {
            arrayRef = (ArrayReference)this.getVM().invokeTestSetup(className);
        }
        catch (InvocationException ie) {
            return null;
        }
        HashMap<String, JdiObject> returnMap = new HashMap<String, JdiObject>();
        ObjectReference testObject = (ObjectReference)arrayRef.getValue(arrayRef.length() - 1);
        JdiObject jdiTestObject = JdiObject.getDebuggerObject(testObject);
        if (arrayRef != null) {
            for (int i = 0; i < arrayRef.length() - 1; i += 2) {
                String fieldName = ((StringReference)arrayRef.getValue(i)).value();
                Field testField = testObject.referenceType().fieldByName(fieldName);
                returnMap.put(fieldName, JdiObject.getDebuggerObject((ObjectReference)arrayRef.getValue(i + 1), testField, jdiTestObject));
            }
        }
        return returnMap;
    }

    public DebuggerTestResult runTestMethod(String className, String methodName) {
        ArrayReference arrayRef = null;
        try {
            arrayRef = (ArrayReference)this.getVM().invokeRunTest(className, methodName);
        }
        catch (InvocationException ie) {
            return null;
        }
        catch (VMDisconnectedException vmde) {
            return new JdiTestResultError(className, methodName, "VM restarted", "", null);
        }
        if (arrayRef != null && arrayRef.length() > 5) {
            String failureType = ((StringReference)arrayRef.getValue(0)).value();
            String exMsg = ((StringReference)arrayRef.getValue(1)).value();
            String traceMsg = ((StringReference)arrayRef.getValue(2)).value();
            String failureClass = ((StringReference)arrayRef.getValue(3)).value();
            String failureSource = ((StringReference)arrayRef.getValue(4)).value();
            String failureMethod = ((StringReference)arrayRef.getValue(5)).value();
            int lineNo = Integer.parseInt(((StringReference)arrayRef.getValue(6)).value());
            SourceLocation failPoint = new SourceLocation(failureClass, failureSource, failureMethod, lineNo);
            if (failureType.equals("failure")) {
                return new JdiTestResultFailure(className, methodName, exMsg, traceMsg, failPoint);
            }
            return new JdiTestResultError(className, methodName, exMsg, traceMsg, failPoint);
        }
        return new JdiTestResult(className, methodName);
    }

    public int getStatus() {
        return this.machineState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disposeWindows() {
        VMReference vmr;
        JdiDebugger jdiDebugger = this;
        synchronized (jdiDebugger) {
            if (!this.vmRunning) {
                return;
            }
            vmr = this.getVM();
        }
        try {
            vmr.disposeWindows();
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            // empty catch block
        }
    }

    public void runClassMain(String className) throws ClassNotFoundException {
        this.getVM().runShellClass(className);
    }

    public DebuggerClass getClass(String className) throws ClassNotFoundException {
        ReferenceType classMirror = this.getVM().loadClass(className);
        return new JdiClass(classMirror);
    }

    public DebuggerObject getStaticValue(String className, String fieldName) throws ClassNotFoundException {
        ClassType rt = (ClassType)this.getVM().findClassByName(className);
        Field f = rt.fieldByName(fieldName);
        if (f == null) {
            return null;
        }
        ObjectReference ob = this.getVM().getStaticFieldObject(rt, fieldName);
        GenType expectedType = JdiReflective.fromField(f, rt);
        if (ob != null) {
            return JdiObject.getDebuggerObject(ob, expectedType);
        }
        return null;
    }

    public int getExitStatus() {
        return this.getVM().getExitStatus();
    }

    public ExceptionDescription getException() {
        return this.getVM().getException();
    }

    public DebuggerThreadTreeModel getThreadTreeModel() {
        return this.treeModel;
    }

    private void fireTargetEvent(DebuggerEvent ce) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$bluej$debugger$DebuggerListener == null ? JdiDebugger.class$("bluej.debugger.DebuggerListener") : class$bluej$debugger$DebuggerListener)) continue;
            ((DebuggerListener)listeners[i + 1]).debuggerEvent(ce);
        }
    }

    synchronized void raiseStateChangeEvent(int newState) {
        if (newState != this.machineState) {
            if (this.machineState == 3 && newState == 1) {
                this.fireTargetEvent(new DebuggerEvent(this, 1, 3, 2));
                this.machineState = 2;
            }
            int oldState = this.machineState;
            this.machineState = newState;
            this.fireTargetEvent(new DebuggerEvent(this, 1, oldState, newState));
        }
    }

    void raiseRemoveStepMarksEvent() {
        this.fireTargetEvent(new DebuggerEvent(this, 2));
    }

    public String toggleBreakpoint(String className, int line, boolean set) {
        try {
            if (set) {
                return this.getVM().setBreakpoint(className, line);
            }
            return this.getVM().clearBreakpoint(className, line);
        }
        catch (Exception e) {
            Debug.reportError("breakpoint error: " + e);
            return Config.getString("debugger.jdiDebugger.internalErrorMsg");
        }
    }

    public void breakpoint(final ThreadReference tr, boolean bp) {
        final JdiThread breakThread = this.allThreads.find(tr);
        this.treeModel.syncExec(new Runnable(){

            public void run() {
                JdiThreadNode jtn = JdiDebugger.this.treeModel.findThreadNode(tr);
                if (jtn == null) {
                    JdiThreadNode root = JdiDebugger.this.treeModel.getThreadRoot();
                    JdiDebugger.this.treeModel.insertNodeInto(new JdiThreadNode(breakThread), root, 0);
                } else {
                    JdiDebugger.this.treeModel.nodeChanged(jtn);
                }
            }
        });
        if (bp) {
            this.fireTargetEvent(new DebuggerEvent(this, 4, breakThread));
        } else {
            this.fireTargetEvent(new DebuggerEvent(this, 3, breakThread));
        }
    }

    void vmExit() {
    }

    synchronized void vmDisconnect() {
        if (this.autoRestart) {
            if (!this.selfRestart) {
                this.machineLoader = new MachineLoaderThread();
            }
            this.vmRunning = false;
            this.selfRestart = true;
            this.vmRef.closeIO();
            this.vmRef = null;
            this.launch();
            this.raiseRemoveStepMarksEvent();
            this.raiseStateChangeEvent(1);
            this.allThreads.clear();
            this.usedNames.clear();
            this.treeModel.syncExec(new Runnable(){

                public void run() {
                    JdiDebugger.this.treeModel.setRoot(new JdiThreadNode());
                    JdiDebugger.this.treeModel.reload();
                }
            });
        }
    }

    void threadStart(ThreadReference tr) {
        final JdiThread newThread = new JdiThread(this.treeModel, tr);
        this.allThreads.add(newThread);
        this.treeModel.syncExec(new Runnable(){

            public void run() {
                JdiDebugger.this.displayThread(newThread);
            }
        });
    }

    void threadDeath(final ThreadReference tr) {
        this.allThreads.removeThread(tr);
        this.treeModel.syncExec(new Runnable(){

            public void run() {
                JdiThreadNode jtn = JdiDebugger.this.treeModel.findThreadNode(tr);
                if (jtn != null) {
                    JdiDebugger.this.treeModel.removeNodeFromParent(jtn);
                }
            }
        });
    }

    public void hideSystemThreads(boolean hide) {
        if (this.hideSystemThreads == hide) {
            return;
        }
        this.hideSystemThreads = hide;
        this.updateThreadDisplay();
    }

    private void updateThreadDisplay() {
        this.treeModel.setRoot(new JdiThreadNode());
        Iterator it = this.allThreads.iterator();
        while (it.hasNext()) {
            JdiThread currentThread = (JdiThread)it.next();
            this.displayThread(currentThread);
        }
        this.treeModel.reload();
    }

    private void displayThread(JdiThread newThread) {
        if (!this.hideSystemThreads || !newThread.isKnownSystemThread()) {
            JdiThreadNode root = this.treeModel.getThreadRoot();
            this.treeModel.insertNodeInto(new JdiThreadNode(newThread), root, 0);
        }
    }

    public void dumpThreadInfo() {
        this.getVM().dumpThreadInfo();
    }

    private VMReference getVM() {
        if (this.machineLoader == null) {
            return null;
        }
        return this.machineLoader.getVM();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class MachineLoaderThread
    extends Thread {
        MachineLoaderThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void run() {
            try {
                JdiDebugger.this.vmRef = new VMReference(JdiDebugger.this, JdiDebugger.this.terminal, JdiDebugger.this.startingDirectory);
                JdiDebugger.this.vmRef.waitForStartup();
                JdiDebugger jdiDebugger = JdiDebugger.this;
                synchronized (jdiDebugger) {
                    JdiDebugger.this.vmRunning = true;
                }
                JdiDebugger.this.newClassLoader(JdiDebugger.this.startingDirectory.getAbsolutePath());
                this.notifyAll();
                JdiDebugger.this.raiseStateChangeEvent(2);
            }
            catch (JdiVmCreationException e) {
                BlueJEvent.raiseEvent(1, null);
            }
        }

        private synchronized VMReference getVM() {
            while (!JdiDebugger.this.vmRunning) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            return JdiDebugger.this.vmRef;
        }
    }
}

