/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugger.gentype;

import bluej.debugger.gentype.GenType;
import bluej.debugger.gentype.GenTypeExtends;
import bluej.debugger.gentype.GenTypeParameterizable;
import bluej.debugger.gentype.GenTypeSolid;
import bluej.debugger.gentype.GenTypeSuper;
import bluej.debugger.gentype.NameTransform;
import java.util.Map;

public class GenTypeWildcard
extends GenTypeParameterizable {
    GenTypeSolid upperBound;
    GenTypeSolid lowerBound;

    public GenTypeWildcard(GenTypeSolid upper, GenTypeSolid lower) {
        this.upperBound = upper;
        this.lowerBound = lower;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean stripPrefix) {
        return "? extends " + this.upperBound.toString(stripPrefix) + " super " + this.lowerBound.toString(stripPrefix);
    }

    public String toString(NameTransform nt) {
        return "? extends " + this.upperBound.toString(nt) + " super " + this.lowerBound.toString(nt);
    }

    protected GenTypeParameterizable precisify(GenTypeParameterizable other) {
        GenTypeExtends myUpper = new GenTypeExtends(this.upperBound);
        GenTypeSuper myLower = new GenTypeSuper(this.lowerBound);
        GenTypeExtends otherUpper = null;
        if (other instanceof GenTypeExtends) {
            otherUpper = (GenTypeExtends)other;
        } else if (other instanceof GenTypeWildcard) {
            otherUpper = new GenTypeExtends(((GenTypeWildcard)other).upperBound);
        }
        if (otherUpper != null) {
            myUpper = (GenTypeExtends)myUpper.precisify(otherUpper);
        }
        GenTypeSuper otherLower = null;
        if (other instanceof GenTypeSuper) {
            otherLower = (GenTypeSuper)other;
        } else if (other instanceof GenTypeWildcard) {
            otherLower = new GenTypeSuper(((GenTypeWildcard)other).lowerBound);
        }
        if (otherLower != null) {
            myLower = (GenTypeSuper)myLower.precisify(otherLower);
        }
        if (myUpper.upperBound == this.upperBound && myLower.lowerBound == this.lowerBound) {
            return this;
        }
        if (myUpper.upperBound.equals(myLower.lowerBound)) {
            return myUpper.upperBound;
        }
        return new GenTypeWildcard(myUpper.upperBound, myLower.lowerBound);
    }

    public GenType mapTparsToTypes(Map tparams) {
        GenTypeParameterizable newUpper = null;
        GenTypeParameterizable newLower = null;
        if (this.upperBound != null) {
            newUpper = (GenTypeParameterizable)this.upperBound.mapTparsToTypes(tparams);
        }
        if (this.lowerBound != null) {
            newLower = (GenTypeParameterizable)this.lowerBound.mapTparsToTypes(tparams);
        }
        return new GenTypeWildcard((GenTypeSolid)newUpper, (GenTypeSolid)newLower);
    }

    public boolean equals(GenTypeParameterizable other) {
        if (!(other instanceof GenTypeWildcard)) {
            return false;
        }
        GenTypeWildcard bOther = (GenTypeWildcard)other;
        return this.upperBound.equals(bOther.upperBound) && this.lowerBound.equals(bOther.lowerBound);
    }

    protected void getParamsFromTemplate(Map map, GenTypeParameterizable template) {
    }

    public boolean isPrimitive() {
        return true;
    }

    public GenTypeSolid getUpperBound() {
        return this.upperBound;
    }

    public GenTypeSolid getLowerBound() {
        return this.lowerBound;
    }
}

