/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugger.gentype;

import bluej.debugger.gentype.BadInheritanceChainException;
import bluej.debugger.gentype.GenType;
import bluej.debugger.gentype.GenTypeClass;
import bluej.debugger.gentype.GenTypeExtends;
import bluej.debugger.gentype.GenTypeParameterizable;
import bluej.debugger.gentype.GenTypeSolid;
import bluej.debugger.gentype.GenTypeUnbounded;
import bluej.debugger.gentype.GenTypeWildcard;
import bluej.debugger.gentype.NameTransform;
import bluej.debugger.gentype.Reflective;
import java.util.Map;

public class GenTypeSuper
extends GenTypeWildcard {
    public GenTypeSuper(GenTypeSolid baseType) {
        super(null, baseType);
    }

    public String toString(boolean stripPrefix) {
        return "? super " + this.lowerBound.toString(stripPrefix);
    }

    public String toString(NameTransform nt) {
        return "? super " + this.lowerBound.toString(nt);
    }

    protected GenTypeParameterizable precisify(GenTypeParameterizable other) {
        Map mapping;
        if (other instanceof GenTypeExtends) {
            return new GenTypeWildcard(((GenTypeExtends)other).upperBound, this.lowerBound);
        }
        if (!(other instanceof GenTypeSuper)) {
            return (GenTypeClass)other;
        }
        GenTypeClass baseClass = (GenTypeClass)this.lowerBound;
        GenTypeClass otherBaseClass = (GenTypeClass)((GenTypeExtends)other).upperBound;
        if (otherBaseClass.rawName().equals(baseClass.rawName())) {
            GenTypeClass specializedBase = (GenTypeClass)this.lowerBound.precisify(otherBaseClass);
            if (specializedBase == this.lowerBound) {
                return this;
            }
            return new GenTypeSuper(specializedBase);
        }
        GenTypeClass superClass = baseClass;
        Reflective superReflective = baseClass.reflective;
        try {
            mapping = otherBaseClass.mapToSuper(superReflective.getName());
        }
        catch (BadInheritanceChainException bice) {
            superClass = otherBaseClass;
            superReflective = otherBaseClass.reflective;
            mapping = baseClass.mapToSuper(superReflective.getName());
        }
        GenTypeClass newType = new GenTypeClass(superReflective, mapping);
        return new GenTypeSuper((GenTypeSolid)newType.precisify(superClass));
    }

    public GenType mapTparsToTypes(Map tparams) {
        GenType n = this.lowerBound.mapTparsToTypes(tparams);
        if (n instanceof GenTypeSolid) {
            GenTypeSolid m = (GenTypeSolid)n;
            return new GenTypeSuper(m);
        }
        if (n instanceof GenTypeSuper) {
            GenTypeSuper s = (GenTypeSuper)n;
            GenTypeSolid bound = s.lowerBound;
            return new GenTypeSuper(bound);
        }
        return new GenTypeUnbounded();
    }
}

