/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugger.gentype;

import bluej.debugger.gentype.GenType;
import bluej.debugger.gentype.GenTypeClass;
import bluej.debugger.gentype.GenTypeParameterizable;
import bluej.debugger.gentype.GenTypeSolid;
import bluej.debugger.gentype.GenTypeSuper;
import bluej.debugger.gentype.GenTypeUnbounded;
import bluej.debugger.gentype.GenTypeWildcard;
import bluej.debugger.gentype.NameTransform;
import bluej.debugger.gentype.Reflective;
import java.util.Map;

public class GenTypeExtends
extends GenTypeWildcard {
    public GenTypeExtends(GenTypeSolid baseType) {
        super(baseType, null);
    }

    public String toString(boolean stripPrefix) {
        return "? extends " + this.upperBound.toString(stripPrefix);
    }

    public String toString(NameTransform nt) {
        return "? extends " + this.upperBound.toString(nt);
    }

    protected GenTypeParameterizable precisify(GenTypeParameterizable other) {
        if (other instanceof GenTypeSuper) {
            return new GenTypeWildcard(this.upperBound, ((GenTypeSuper)other).lowerBound);
        }
        if (!(other instanceof GenTypeExtends)) {
            return other;
        }
        GenTypeClass baseClass = (GenTypeClass)this.upperBound;
        GenTypeClass otherBaseClass = (GenTypeClass)((GenTypeExtends)other).upperBound;
        if (((GenTypeExtends)other).upperBound.equals(this.upperBound)) {
            GenTypeParameterizable specializedBase = baseClass.precisify(otherBaseClass);
            if (specializedBase == this.upperBound) {
                return this;
            }
            return new GenTypeExtends((GenTypeSolid)specializedBase);
        }
        GenTypeClass subClass = otherBaseClass;
        Reflective subReflective = subClass.reflective;
        Map mapping = baseClass.mapToDerived(subReflective);
        if (mapping == null) {
            subClass = baseClass;
            subReflective = baseClass.reflective;
            mapping = otherBaseClass.mapToDerived(subReflective);
        }
        GenTypeClass newType = new GenTypeClass(subReflective, mapping);
        return new GenTypeExtends((GenTypeSolid)newType.precisify(subClass));
    }

    public GenType mapTparsToTypes(Map tparams) {
        GenType n = this.upperBound.mapTparsToTypes(tparams);
        if (n instanceof GenTypeSolid) {
            GenTypeSolid m = (GenTypeSolid)n;
            return new GenTypeExtends(m);
        }
        if (n instanceof GenTypeExtends) {
            GenTypeExtends e = (GenTypeExtends)n;
            GenTypeSolid bound = e.upperBound;
            return new GenTypeExtends(bound);
        }
        return new GenTypeUnbounded();
    }
}

