/*
 * Decompiled with CFR 0.152.
 */
package bluej.classmgr;

import bluej.classmgr.ClassPath;
import bluej.classmgr.JarFilter;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;

public class ProjectClassLoader
extends URLClassLoader {
    public static final String projectLibDirName = "+libs";
    private File[] libsJars;

    public ProjectClassLoader(File projectDir) {
        this(projectDir, ClassLoader.getSystemClassLoader());
    }

    public ProjectClassLoader(File projectDir, ClassLoader parent) {
        super(ProjectClassLoader.getDirectoryAsURL(projectDir), parent);
        this.setAssertions(true);
        File libsDirectory = new File(projectDir, projectLibDirName);
        if (libsDirectory.isDirectory()) {
            this.libsJars = libsDirectory.listFiles(new JarFilter());
        }
        if (this.libsJars == null) {
            this.libsJars = new File[0];
        }
        for (int i = 0; i < this.libsJars.length; ++i) {
            try {
                this.addURL(this.libsJars[i].toURL());
                continue;
            }
            catch (MalformedURLException mue) {
                // empty catch block
            }
        }
    }

    public ClassPath getAsClassPath() {
        return new ClassPath(this.getURLs());
    }

    public File[] getProjectLibs() {
        return this.libsJars;
    }

    private static URL[] getDirectoryAsURL(File projectDir) {
        if (!projectDir.isDirectory()) {
            throw new IllegalArgumentException("project directory was not a directory");
        }
        try {
            URL[] urls = new URL[]{projectDir.toURL()};
            return urls;
        }
        catch (MalformedURLException mue) {
            URL[] blankUrls = new URL[]{};
            return blankUrls;
        }
    }

    private void setAssertions(boolean status) {
        try {
            Class<?> cl = this.getClass();
            Class[] p = new Class[]{Boolean.TYPE};
            Method setAssertMethod = cl.getMethod("setDefaultAssertionStatus", p);
            Object[] arguments = new Object[]{new Boolean(status)};
            setAssertMethod.invoke((Object)this, arguments);
        }
        catch (NoSuchMethodException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }
}

