/*
 * Decompiled with CFR 0.152.
 */
package bluej.classmgr;

import bluej.Config;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;

public class ClassPathEntry
implements Cloneable {
    private static final String statusGood = Config.getString("classmgr.statusgood");
    private static final String statusBad = Config.getString("classmgr.statusbad");
    private static final String statusNew = Config.getString("classmgr.statusnew");
    private File file;
    private String description;
    private boolean justAdded = false;

    public ClassPathEntry(String location, String description) {
        this.file = new File(location).getAbsoluteFile();
        this.description = description;
    }

    public ClassPathEntry(String location, String description, boolean isNew) {
        this(location, description);
        this.justAdded = isNew;
    }

    public String getDescription() {
        if (this.description == null) {
            return Config.getString("classmgr.error.nodescription") + " (" + this.file.getPath() + ")";
        }
        return this.description;
    }

    protected void setDescription(String d) {
        this.description = d;
    }

    public File getFile() {
        return this.file;
    }

    public String getPath() {
        return this.file.getPath();
    }

    public String getCanonicalPathNoException() {
        String path;
        try {
            path = this.file.getCanonicalPath();
        }
        catch (IOException ioe) {
            path = Config.getString("classmgr.error.unresolvable") + " (" + this.file.getPath() + ")";
        }
        return path;
    }

    public URL getURL() throws MalformedURLException {
        return this.file.toURL();
    }

    public boolean isNew() {
        return this.justAdded;
    }

    public boolean isValid() {
        if (this.file.isDirectory()) {
            return true;
        }
        if (this.isJar()) {
            return this.file.canRead();
        }
        return false;
    }

    public String getStatusString() {
        if (!this.isValid()) {
            return statusBad;
        }
        if (this.isNew()) {
            return statusNew;
        }
        return statusGood;
    }

    public boolean isJar() {
        String name = this.file.getName().toLowerCase();
        return this.file.isFile() && (name.endsWith(".zip") || name.endsWith(".jar"));
    }

    public boolean isClassRoot() {
        return this.file.isDirectory();
    }

    public String toString() {
        return this.getPath();
    }

    public boolean equals(Object o) {
        return this.file.equals(((ClassPathEntry)o).file);
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

