/*
 * Decompiled with CFR 0.152.
 */
package org.bluej.extensions.submitter.transport;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.ProtocolException;
import java.net.Socket;
import org.bluej.extensions.submitter.transport.TransportReport;

class SocketSession {
    private static final int TIMEOUT_DATA = 5000;
    private static final int TIMEOUT_OPEN = 60000;
    private static final int TIMEOUT_CONT = 1000;
    private Socket channel;
    private BufferedReader in;
    private OutputStream out;
    private TransportReport transportReport;
    private byte[] crlf = new byte[]{13, 10};

    SocketSession(String host, int port) throws IOException {
        this.channel = new Socket(host, port);
        this.in = new BufferedReader(new InputStreamReader(this.channel.getInputStream()));
        this.out = this.channel.getOutputStream();
    }

    public void setTransportReport(TransportReport i_transportReport) {
        this.transportReport = i_transportReport;
        this.reportLog("Socket open to " + this.getHost());
    }

    private void reportEvent(String message) {
        if (this.transportReport == null) {
            return;
        }
        this.transportReport.reportEvent(message);
    }

    private void reportLog(String message) {
        if (this.transportReport == null) {
            return;
        }
        this.transportReport.reportLog(message);
    }

    public String getHost() {
        return this.channel.getInetAddress().getHostName() + ":" + this.channel.getPort();
    }

    String getLocalHost() {
        return this.channel.getLocalAddress().getHostName();
    }

    public String expect(String[] response, String[] badResponse) throws IOException {
        String lastLine = null;
        this.channel.setSoTimeout(60000);
        String getLine = this.in.readLine();
        this.reportLog("<<" + getLine);
        try {
            while (getLine != null) {
                int i;
                for (i = 0; i < response.length; ++i) {
                    if (!getLine.startsWith(response[i])) continue;
                    return getLine;
                }
                for (i = 0; i < badResponse.length; ++i) {
                    if (!getLine.startsWith(badResponse[i])) continue;
                    throw new ProtocolException(getLine);
                }
                lastLine = getLine;
                this.channel.setSoTimeout(1000);
                getLine = this.in.readLine();
                this.reportLog("<<" + getLine);
            }
            throw new IOException();
        }
        catch (ProtocolException ex) {
            throw ex;
        }
        catch (IOException ex) {
            this.reportLog(ex.getMessage());
            if (lastLine == null || lastLine.trim().equals("")) {
                lastLine = "No response from server";
            }
            throw new ProtocolException(lastLine);
        }
    }

    public String expect(String[] responses) throws IOException {
        return this.expect(responses, new String[0]);
    }

    public String expect(String response, String badResponse) throws IOException {
        return this.expect(new String[]{response}, new String[]{badResponse});
    }

    public String expect(String response) throws IOException {
        return this.expect(new String[]{response}, new String[0]);
    }

    public void send(String data) throws IOException {
        this.out.write(data.getBytes());
    }

    void sendln(String data) throws IOException {
        this.nologSendln(data);
        this.reportLog(">> " + data);
    }

    void nologSendln(String data) throws IOException {
        this.out.write(data.getBytes());
        this.out.write(this.crlf);
    }

    void flush() throws IOException {
        this.out.flush();
    }

    public void close() throws IOException {
        this.out.flush();
        this.channel.shutdownOutput();
        this.channel.shutdownInput();
        this.channel.close();
    }

    void sendMimeStream(InputStream inputStream) throws IOException {
        byte[] outBuf = new byte[4];
        int line = 0;
        int size = 3;
        while (true) {
            int in0 = inputStream.read();
            int in1 = inputStream.read();
            int in2 = inputStream.read();
            if (in0 == -1) break;
            if (in2 == -1) {
                size = 2;
                in2 = 0;
            }
            if (in1 == -1) {
                size = 1;
                in1 = 0;
            }
            outBuf[0] = SocketSession.encode((byte)((in0 & 0xFC) >>> 2));
            outBuf[1] = SocketSession.encode((byte)((in0 & 3) << 4 | (in1 & 0xF0) >>> 4));
            outBuf[2] = SocketSession.encode((byte)((in1 & 0xF) << 2 | (in2 & 0xC0) >>> 6));
            outBuf[3] = SocketSession.encode((byte)(in2 & 0x3F));
            if (size < 3) {
                outBuf[3] = 61;
            }
            if (size < 2) {
                outBuf[2] = 61;
            }
            if (line + size > 57) {
                this.out.write(this.crlf);
                line = 0;
            }
            this.out.write(outBuf);
            line += size;
        }
        this.out.write(this.crlf);
    }

    /*
     * WARNING - void declaration
     */
    static byte encode(byte in) {
        void var1_1;
        int out;
        if (in < 0) {
            throw new Error("Input < 0! in = " + in);
        }
        if (in < 26) {
            out = in + 65;
        } else if (in < 52) {
            out = (byte)(in - 26 + 97);
        } else if (in < 62) {
            out = (byte)(in - 52 + 48);
        } else if (in == 62) {
            out = 43;
        } else if (in == 63) {
            out = 47;
        } else {
            throw new Error("Input too large! in = " + in);
        }
        return (byte)var1_1;
    }
}

