/*
 * Decompiled with CFR 0.152.
 */
package org.bluej.extensions.submitter.transport;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ProtocolException;
import java.net.Socket;
import java.net.URL;
import java.util.Properties;
import org.bluej.extensions.submitter.transport.SocketSession;
import org.bluej.extensions.submitter.transport.TransportSession;

public class FtpSession
extends TransportSession {
    private int fileCounter;
    private String rootDir;

    public FtpSession(URL url, Properties environment) {
        super(url, environment);
        this.result = "Not sent";
        this.fileCounter = 0;
    }

    public void connect() throws IOException {
        String password;
        String username;
        String ftpHost = this.url.getHost();
        String userInfo = this.url.getUserInfo();
        if (userInfo == null) {
            username = "anonymous";
            password = this.urlProps.getProperty("useraddr", "");
        } else {
            int colon = userInfo.indexOf(58);
            username = colon == -1 ? userInfo : userInfo.substring(0, colon);
            password = colon == -1 ? "" : userInfo.substring(colon + 1);
        }
        this.reportEvent("Starting FTP...");
        int port = 21;
        if (this.url.getPort() != -1) {
            port = this.url.getPort();
        }
        this.connection = new SocketSession(ftpHost, port);
        this.connection.setTransportReport(this.transportReport);
        this.connection.expect("220 ", "421");
        this.connection.sendln("USER " + username);
        String reply = this.connection.expect(new String[]{"331 ", "230 "}, new String[]{"530", "500", "501", "421", "332"});
        if (reply.startsWith("331")) {
            if (password.length() == 0) {
                throw new ProtocolException("No password provided!");
            }
            this.connection.sendln("PASS " + password);
            this.connection.expect(new String[]{"230 ", "202 "}, new String[]{"202", "530", "500", "501", "503", "421", "332"});
        }
    }

    public void send(InputStream is, String name, boolean binary) throws IOException {
        int c;
        int slash;
        String sendPath = this.url.getPath();
        if (this.rootDir == null) {
            this.connection.sendln("PWD");
            String aResult = this.connection.expect(new String[]{"257 "}, new String[]{"500", "501", "502", "421", "530", "550"});
            int firstQuote = aResult.indexOf("\"");
            int lastQuote = aResult.indexOf("\"", firstQuote + 1);
            this.rootDir = aResult.substring(firstQuote + 1, lastQuote);
        }
        this.connection.sendln("CWD " + this.rootDir);
        this.connection.expect(new String[]{"250 "}, new String[]{"500", "501", "502", "421", "530", "550"});
        if (!sendPath.equals("") && !sendPath.equals("/")) {
            this.connection.sendln("CWD " + sendPath.substring(1));
            String resp = this.connection.expect(new String[]{"250 ", "550"}, new String[]{"500", "501", "502", "421", "530"});
            if (resp.startsWith("550")) {
                throw new FileNotFoundException("ftp://" + this.url.getHost() + sendPath);
            }
        }
        while ((slash = name.indexOf(47)) != -1) {
            String dir = name.substring(0, slash);
            name = name.substring(slash + 1);
            this.connection.sendln("CWD " + dir);
            if (!this.connection.expect(new String[]{"250 ", "550 "}, new String[]{"500", "501", "502", "421", "530"}).startsWith("550 ")) continue;
            this.connection.sendln("MKD " + dir);
            this.connection.expect(new String[]{"257 "}, new String[]{"500", "501", "502", "421", "530", "550"});
            this.connection.sendln("CWD " + dir);
            this.connection.expect(new String[]{"250 "}, new String[]{"500", "501", "502", "421", "530", "550"});
        }
        if (binary) {
            this.connection.sendln("TYPE I");
            this.connection.expect(new String[]{"200 "}, new String[]{"500", "501", "504", "421", "530"});
        } else {
            this.connection.sendln("TYPE A");
            this.connection.expect(new String[]{"200 "}, new String[]{"500", "501", "504", "421", "530"});
        }
        this.connection.sendln("PASV");
        String portString = this.connection.expect(new String[]{"227 "}, new String[]{"500", "501", "502", "421", "530"});
        int p = portString.indexOf(40);
        int[] param = new int[6];
        int paramNo = 0;
        for (int i = p + 1; i < portString.length() && paramNo < 6; ++i) {
            if (Character.getType(portString.charAt(i)) == 9) continue;
            param[paramNo++] = Integer.parseInt(portString.substring(p + 1, i));
            p = i;
        }
        if (paramNo < 6) {
            throw new ProtocolException("Unexpected message from FTP server");
        }
        String host = param[0] + "." + param[1] + "." + param[2] + "." + param[3];
        int port = (param[4] << 8) + param[5];
        Socket data = new Socket(host, port);
        this.connection.sendln("STOR " + name);
        this.connection.expect(new String[]{"150 ", "125 "}, new String[]{"425", "426", "451", "551", "552", "532", "450", "452", "553", "500", "501", "421", "530"});
        OutputStream out = data.getOutputStream();
        byte[] buffer = new byte[data.getSendBufferSize()];
        while ((c = is.read(buffer)) != -1) {
            out.write(buffer, 0, c);
        }
        data.shutdownOutput();
        data.close();
        this.connection.expect(new String[]{"226 ", "250 "}, new String[]{"425", "426", "451", "551", "552", "532", "450", "452", "553", "500", "501", "421", "530"});
        ++this.fileCounter;
    }

    public void disconnect() throws IOException {
        this.connection.sendln("QUIT");
        this.connection.expect("221 ", "500");
        this.connection.close();
        this.connection = null;
        this.reportEvent("Connection closed.");
        this.result = null;
    }
}

