/*
 * Decompiled with CFR 0.152.
 */
package org.bluej.extensions.submitter.properties;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.StringTokenizer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import org.bluej.extensions.submitter.Stat;
import org.bluej.extensions.submitter.properties.CompilationException;
import org.bluej.extensions.submitter.properties.ConfParser;
import org.bluej.extensions.submitter.properties.TreeNode;
import org.bluej.utility.Utility;

public class TreeData {
    private static final String CONFIG_FILENAME = "submission.defs";
    private static final String ROOT_NODENAME = "Submissions";
    private Stat stat;
    private TreeNode rootNode;
    private DefaultTreeModel treeModel;

    public TreeData(Stat i_stat) {
        this.stat = i_stat;
        this.stat.aDbg.trace(1, "new SubmitTree: CALLED");
        this.rootNode = new TreeNode(this.stat, ROOT_NODENAME);
        this.treeModel = new treeModel(this.rootNode);
    }

    public boolean haveConfiguration(File projectRoot) {
        File systemConfFile = new File(this.stat.bluej.getSystemLibDir(), CONFIG_FILENAME);
        if (systemConfFile.canRead()) {
            return true;
        }
        File userConfFile = new File(this.stat.bluej.getUserConfigDir(), CONFIG_FILENAME);
        if (userConfFile.canRead()) {
            return true;
        }
        File projectConfFile = new File(projectRoot, CONFIG_FILENAME);
        return projectConfFile.canRead();
    }

    public void loadTree(File projectRoot) {
        this.stat.aDbg.trace(1, "SubmitTree.loadTree: CALLED");
        this.rootNode.removeAllChildren();
        this.treeModel.nodeStructureChanged(this.rootNode);
        File systemConfFile = new File(this.stat.bluej.getSystemLibDir(), CONFIG_FILENAME);
        this.loadFile(this.rootNode, systemConfFile);
        File userConfFile = new File(this.stat.bluej.getUserConfigDir(), CONFIG_FILENAME);
        this.loadFile(this.rootNode, userConfFile);
        File projectConfFile = new File(projectRoot, CONFIG_FILENAME);
        this.loadFile(this.rootNode, projectConfFile);
    }

    private void loadFile(TreeNode insertPoint, File fromFile) {
        if (fromFile == null) {
            return;
        }
        try {
            FileInputStream risul = new FileInputStream(fromFile);
            if (risul == null) {
                return;
            }
            this.loadOneStream(insertPoint, risul, fromFile.toString());
        }
        catch (Exception exc) {
            this.stat.submitDialog.logWriteln("Opening " + exc.getMessage());
        }
    }

    void loadUrl(TreeNode insertPoint, String fromUrl) {
        if (fromUrl == null) {
            return;
        }
        try {
            URL url = new URL(fromUrl);
            InputStream risul = url.openStream();
            if (risul == null) {
                return;
            }
            this.loadOneStream(insertPoint, risul, fromUrl);
        }
        catch (Exception exc) {
            this.stat.submitDialog.logWriteln("Opening " + exc.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadOneStream(TreeNode insertPoint, InputStream fromStream, String streamName) {
        this.stat.aDbg.trace(1, "SubmissionProperties.loadOneStream CALLED");
        try {
            this.stat.submitDialog.statusWriteln("Loading " + streamName);
            ConfParser aParser = new ConfParser(this.stat, this.treeModel);
            aParser.parse(insertPoint, fromStream);
        }
        catch (CompilationException cex) {
            cex.addFilename(streamName);
            this.stat.submitDialog.logWriteln(cex.toString());
        }
        finally {
            Utility.inputStreamClose(fromStream);
        }
        this.treeModel.nodeStructureChanged(this.rootNode);
    }

    public DefaultTreeModel getTreeModel() {
        return this.treeModel;
    }

    public Collection getProps(String item) {
        TreePath path = this.getPathFromString(this.stat.submitDialog.schemeSelectedGet());
        if (path == null) {
            return null;
        }
        TreeNode selected = (TreeNode)path.getLastPathComponent();
        return selected.getConfig(item);
    }

    public String getPathAsString(TreePath path) {
        String pathString = "";
        if (path == null) {
            return pathString;
        }
        Object[] objs = path.getPath();
        for (int i = 1; i < objs.length; ++i) {
            TreeNode n = (TreeNode)objs[i];
            pathString = pathString + n.getTitle() + (i == objs.length - 1 ? "" : "/");
        }
        return pathString;
    }

    public TreePath getPathFromString(String pathString) {
        StringTokenizer token = new StringTokenizer(pathString, "/");
        TreeNode leaf = this.rootNode;
        ArrayList<TreeNode> pathList = new ArrayList<TreeNode>();
        pathList.add(leaf);
        while (token.hasMoreTokens()) {
            String nextNodeString = token.nextToken();
            TreeNode nextNode = null;
            Enumeration<javax.swing.tree.TreeNode> enumeration = leaf.children();
            while (enumeration.hasMoreElements()) {
                javax.swing.tree.TreeNode someChild = enumeration.nextElement();
                if (!someChild.toString().equals(nextNodeString)) continue;
                nextNode = (TreeNode)someChild;
                break;
            }
            if (nextNode == null) {
                return null;
            }
            leaf = nextNode;
            pathList.add(leaf);
        }
        TreePath path = new TreePath(pathList.toArray());
        return path;
    }

    class treeModel
    extends DefaultTreeModel {
        treeModel(TreeNode rootNode) {
            super(rootNode);
        }

        public void insertNodeInto(MutableTreeNode newChild, MutableTreeNode parent, int index) {
            ((TreeData)TreeData.this).stat.aDbg.debug(1, "insertNodeInto: child=" + newChild);
            index = this.getChildCount(parent);
            super.insertNodeInto(newChild, parent, index);
        }
    }
}

