/*
 * Decompiled with CFR 0.152.
 */
package org.bluej.extensions.submitter;

import bluej.extensions.BPackage;
import bluej.extensions.BProject;
import bluej.extensions.ExtensionException;
import bluej.extensions.MenuGenerator;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import org.bluej.extensions.submitter.Stat;

public class MenuBuilder
extends MenuGenerator
implements ActionListener {
    private Stat stat;
    private String aLabel;

    MenuBuilder(Stat i_stat) {
        this.stat = i_stat;
        this.aLabel = this.stat.bluej.getLabel("menu.submit");
    }

    public JMenuItem getToolsMenuItem(BPackage aPackage) {
        JMenuItem anItem = new JMenuItem(this.aLabel);
        anItem.setEnabled(this.isMenuEnabled(aPackage));
        anItem.addActionListener(this);
        return anItem;
    }

    public void notifyPostToolsMenu(BPackage bp, JMenuItem jmi) {
        jmi.setEnabled(this.isMenuEnabled(bp));
    }

    private boolean isMenuEnabled(BPackage aPackage) {
        if (aPackage == null) {
            return false;
        }
        try {
            BProject bproj = aPackage.getProject();
            return this.stat.treeData.haveConfiguration(bproj.getDir());
        }
        catch (Exception exc) {
            return false;
        }
    }

    public void actionPerformed(ActionEvent anEvent) {
        try {
            BPackage bpkg = this.stat.bluej.getCurrentPackage();
            if (bpkg == null) {
                return;
            }
            BProject bproj = bpkg.getProject();
            bproj.save();
            this.stat.submitDialog.submitThis(bproj.getDir(), bproj.getName());
        }
        catch (ExtensionException extensionException) {
            // empty catch block
        }
    }
}

