/*
 * Decompiled with CFR 0.152.
 */
package bluej.views;

import bluej.debugger.gentype.GenType;
import bluej.utility.JavaUtils;
import bluej.views.CallableView;
import bluej.views.Comment;
import bluej.views.FormattedPrintWriter;
import bluej.views.View;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Map;

public class MethodView
extends CallableView
implements Comparable {
    protected Method method;
    protected View returnType;
    static /* synthetic */ Class class$java$lang$String;

    public MethodView(View view, Method method) {
        super(view);
        this.method = method;
    }

    public Method getMethod() {
        return this.method;
    }

    public String toString() {
        return this.method.toString();
    }

    public int getModifiers() {
        return this.method.getModifiers();
    }

    public boolean hasParameters() {
        return this.method.getParameterTypes().length > 0;
    }

    public String getSignature() {
        return JavaUtils.getJavaUtils().getSignature(this.method);
    }

    public String getCallSignature() {
        StringBuffer name = new StringBuffer();
        name.append(this.method.getName());
        name.append('(');
        Class<?>[] params = this.method.getParameterTypes();
        for (int i = 0; i < params.length; ++i) {
            name.append(params[i].getName());
            if (i == params.length - 1) continue;
            name.append(',');
        }
        name.append(')');
        return name.toString();
    }

    public String getShortDesc() {
        return JavaUtils.getJavaUtils().getShortDesc(this.method, this.getParamNames());
    }

    public String getShortDesc(Map genericParams) {
        return JavaUtils.getJavaUtils().getShortDesc(this.method, this.getParamNames(), genericParams);
    }

    public String getLongDesc() {
        return JavaUtils.getJavaUtils().getLongDesc(this.method, this.getParamNames());
    }

    public String getLongDesc(Map genericParams) {
        return JavaUtils.getJavaUtils().getLongDesc(this.method, this.getParamNames(), genericParams);
    }

    public Class[] getParameters() {
        return this.method.getParameterTypes();
    }

    public GenType[] getParamTypes(boolean raw) {
        JavaUtils jutils = JavaUtils.getJavaUtils();
        GenType[] ptypes = jutils.getParamGenTypes(this.method, raw);
        List tparams = jutils.getTypeParams(this.method);
        Map tpmap = JavaUtils.TParamsToMap(tparams);
        for (int i = 0; i < ptypes.length; ++i) {
            ptypes[i] = ptypes[i].mapTparsToTypes(tpmap);
        }
        return ptypes;
    }

    public String[] getParamTypeStrings() {
        return JavaUtils.getJavaUtils().getParameterTypes(this.method);
    }

    public String getName() {
        return this.method.getName();
    }

    public boolean isVoid() {
        String resultName = this.getReturnType().getQualifiedName();
        return "void".equals(resultName);
    }

    public boolean isMain() {
        if (!this.isVoid()) {
            return false;
        }
        if ("main".equals(this.getName())) {
            Class[] c = this.getParameters();
            if (c.length != 1) {
                return false;
            }
            if (c[0].isArray() && (class$java$lang$String == null ? (class$java$lang$String = MethodView.class$("java.lang.String")) : class$java$lang$String).equals(c[0].getComponentType()) && Modifier.isStatic(this.getModifiers()) && Modifier.isPublic(this.getModifiers())) {
                return true;
            }
        }
        return false;
    }

    public boolean isVarArgs() {
        return JavaUtils.getJavaUtils().isVarArgs(this.method);
    }

    public View getReturnType() {
        if (this.returnType == null) {
            this.returnType = View.getView(this.method.getReturnType());
        }
        return this.returnType;
    }

    public void print(FormattedPrintWriter out, Map typeParams, int indents) {
        Comment comment = this.getComment();
        if (comment != null) {
            comment.print(out, indents);
        }
        out.setItalic(false);
        out.setBold(true);
        for (int i = 0; i < indents; ++i) {
            out.indentLine();
        }
        out.println(this.getLongDesc(typeParams));
    }

    public int compareTo(Object other) {
        MethodView otherView = (MethodView)other;
        return this.method.getName().compareTo(otherView.method.getName());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

