/*
 * Decompiled with CFR 0.152.
 */
package bluej.views;

import bluej.utility.Utility;
import bluej.views.FormattedPrintWriter;
import java.util.Properties;
import java.util.StringTokenizer;

public final class Comment {
    private String target;
    private String text;
    private String[] paramnames;

    public void load(Properties p, String prefix) {
        this.target = p.getProperty(prefix + ".target", "<no target>");
        this.text = p.getProperty(prefix + ".text");
        String paramnamestring = p.getProperty(prefix + ".params");
        if (paramnamestring != null) {
            StringTokenizer st = new StringTokenizer(paramnamestring, " ");
            this.paramnames = new String[st.countTokens()];
            int i = 0;
            while (st.hasMoreTokens()) {
                this.paramnames[i] = st.nextToken();
                ++i;
            }
        }
    }

    public String getTarget() {
        return this.target;
    }

    public String getText() {
        return this.text;
    }

    public String getParamName(int i) {
        if (this.paramnames != null && i >= 0 && i < this.paramnames.length) {
            return this.paramnames[i];
        }
        return null;
    }

    public int getParamCount() {
        if (this.paramnames != null) {
            return this.paramnames.length;
        }
        return 0;
    }

    public String[] getParamNames() {
        return (String[])this.paramnames.clone();
    }

    public void print(FormattedPrintWriter out) {
        this.print(out, 0);
    }

    public void print(FormattedPrintWriter out, int indents) {
        out.setBold(false);
        out.setItalic(true);
        if (this.text != null) {
            int last;
            String[] lines = Utility.splitLines(this.text);
            for (int i = 0; i < lines.length; ++i) {
                lines[i] = lines[i].trim();
            }
            for (int first = 0; first < lines.length && lines[first].length() == 0; ++first) {
            }
            for (last = lines.length - 1; last >= 0 && lines[last].length() == 0; --last) {
            }
            for (int i = first; i <= last; ++i) {
                for (int j = 0; j < indents; ++j) {
                    out.indentLine();
                }
                out.println("// " + lines[i]);
            }
        }
    }

    public String toString() {
        return this.text;
    }
}

