/*
 * Decompiled with CFR 0.152.
 */
package bluej.utility;

import bluej.debugger.gentype.GenType;
import bluej.debugger.gentype.GenTypeArray;
import bluej.debugger.gentype.GenTypeClass;
import bluej.debugger.gentype.GenTypeDeclTpar;
import bluej.debugger.gentype.GenTypeExtends;
import bluej.debugger.gentype.GenTypeSolid;
import bluej.debugger.gentype.GenTypeSuper;
import bluej.debugger.gentype.GenTypeTpar;
import bluej.debugger.gentype.GenTypeUnbounded;
import bluej.debugger.gentype.Reflective;
import bluej.utility.Debug;
import bluej.utility.JavaArrayReflective;
import bluej.utility.JavaNames;
import bluej.utility.JavaReflective;
import bluej.utility.JavaUtils;
import bluej.utility.JavaUtils14;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class JavaUtils15
extends JavaUtils {
    static /* synthetic */ Class class$0;

    public String getSignature(Method method) {
        String name = JavaUtils15.getTypeParameters(method);
        name = String.valueOf(name) + JavaUtils15.getTypeName(method.getGenericReturnType()) + " " + method.getName();
        Type[] params = method.getGenericParameterTypes();
        return JavaUtils15.makeSignature(name, params, method.isVarArgs());
    }

    public String getShortDesc(Method method, String[] paramnames) {
        String name = JavaUtils15.getTypeParameters(method);
        name = String.valueOf(name) + JavaUtils15.getTypeName(method.getGenericReturnType()) + " " + method.getName();
        Type[] paramTypes = method.getGenericParameterTypes();
        String[] paramTypeNames = this.getParameterTypes(paramTypes, false);
        return JavaUtils.makeDescription(name, paramTypeNames, paramnames, false, method.isVarArgs());
    }

    public String getShortDesc(Method method, String[] paramnames, Map tparams) {
        if (tparams == null) {
            String name = String.valueOf(JavaUtils14.getTypeName(method.getReturnType())) + " " + method.getName();
            Class[] params = method.getParameterTypes();
            String[] paramTypes = JavaUtils14.getParameterTypes(params);
            return JavaUtils.makeDescription(name, paramTypes, paramnames, false, false);
        }
        HashMap<String, GenTypeDeclTpar> newMap = new HashMap<String, GenTypeDeclTpar>(tparams);
        List myParams = this.getTypeParams(method);
        for (GenTypeDeclTpar tpar : myParams) {
            newMap.put(tpar.getTparName(), tpar);
        }
        String name = JavaUtils15.getTypeParameters(method);
        GenType rtype = this.getReturnType(method);
        name = String.valueOf(name) + rtype.mapTparsToTypes(newMap).toString(true) + " " + method.getName();
        GenType[] paramTypes = this.getParamGenTypes(method, false);
        String[] paramTypeNames = new String[paramTypes.length];
        int i = 0;
        while (i < paramTypes.length) {
            paramTypeNames[i] = paramTypes[i].mapTparsToTypes(newMap).toString(true);
            ++i;
        }
        return JavaUtils.makeDescription(name, paramTypeNames, paramnames, false, method.isVarArgs());
    }

    public String getLongDesc(Method method, String[] paramnames) {
        String name = JavaUtils15.getTypeParameters(method);
        name = String.valueOf(name) + JavaUtils15.getTypeName(method.getGenericReturnType()) + " " + method.getName();
        Type[] paramTypes = method.getGenericParameterTypes();
        String[] paramTypeNames = this.getParameterTypes(paramTypes, false);
        return JavaUtils.makeDescription(name, paramTypeNames, paramnames, true, method.isVarArgs());
    }

    public String getLongDesc(Method method, String[] paramnames, Map tparams) {
        if (tparams == null) {
            String name = String.valueOf(JavaUtils14.getTypeName(method.getReturnType())) + " " + method.getName();
            Class[] params = method.getParameterTypes();
            String[] paramTypes = JavaUtils14.getParameterTypes(params);
            return JavaUtils.makeDescription(name, paramTypes, paramnames, true, false);
        }
        HashMap<String, GenTypeDeclTpar> newMap = new HashMap<String, GenTypeDeclTpar>();
        if (tparams != null) {
            newMap.putAll(tparams);
        }
        List myParams = this.getTypeParams(method);
        for (GenTypeDeclTpar tpar : myParams) {
            newMap.put(tpar.getTparName(), tpar);
        }
        String name = JavaUtils15.getTypeParameters(method);
        GenType rtype = this.getReturnType(method);
        name = String.valueOf(name) + rtype.mapTparsToTypes(newMap).toString(true) + " " + method.getName();
        GenType[] paramTypes = this.getParamGenTypes(method, false);
        String[] paramTypeNames = new String[paramTypes.length];
        int i = 0;
        while (i < paramTypes.length) {
            paramTypeNames[i] = paramTypes[i].mapTparsToTypes(newMap).toString(true);
            ++i;
        }
        return JavaUtils.makeDescription(name, paramTypeNames, paramnames, true, method.isVarArgs());
    }

    public String getShortDesc(Constructor constructor, String[] paramnames) {
        String name = constructor.getName();
        name = String.valueOf(name) + this.getTypeParams(constructor);
        Type[] paramTypes = constructor.getGenericParameterTypes();
        String[] paramTypeNames = this.getParameterTypes(paramTypes, false);
        return JavaUtils.makeDescription(name, paramTypeNames, paramnames, false, constructor.isVarArgs());
    }

    public String getLongDesc(Constructor constructor, String[] paramnames) {
        String name = constructor.getName();
        name = String.valueOf(name) + this.getTypeParams(constructor);
        Type[] paramTypes = constructor.getGenericParameterTypes();
        String[] paramTypeNames = this.getParameterTypes(paramTypes, false);
        return JavaUtils.makeDescription(name, paramTypeNames, paramnames, true, constructor.isVarArgs());
    }

    private String getTypeParams(Constructor constructor) {
        String typeString = "";
        List typeParams = this.getTypeParams(constructor.getDeclaringClass());
        if (typeParams.size() > 0) {
            typeString = String.valueOf(typeString) + "<";
            Iterator iter = typeParams.iterator();
            while (iter.hasNext()) {
                GenTypeDeclTpar element = (GenTypeDeclTpar)iter.next();
                typeString = String.valueOf(typeString) + element.toString(true);
                if (!iter.hasNext()) continue;
                typeString = String.valueOf(typeString) + ",";
            }
            typeString = String.valueOf(typeString) + ">";
        }
        return typeString;
    }

    public String getSignature(Constructor cons) {
        String name = JavaNames.getBase(cons.getName());
        Type[] params = cons.getGenericParameterTypes();
        return JavaUtils15.makeSignature(name, params, cons.isVarArgs());
    }

    public boolean isVarArgs(Constructor cons) {
        return cons.isVarArgs();
    }

    public boolean isVarArgs(Method method) {
        return method.isVarArgs();
    }

    public boolean isBridge(Method method) {
        return method.isBridge();
    }

    public boolean isEnum(Class cl) {
        return cl.isEnum();
    }

    public GenType getReturnType(Method method) {
        Type rt = method.getGenericReturnType();
        return JavaUtils15.genTypeFromType(rt);
    }

    public GenType getRawReturnType(Method method) {
        Class<?> c = method.getReturnType();
        return JavaUtils14.genTypeFromClass(c);
    }

    public List getTypeParams(Method method) {
        ArrayList<GenTypeDeclTpar> rlist = new ArrayList<GenTypeDeclTpar>();
        TypeVariable<Method>[] tvars = method.getTypeParameters();
        int i = 0;
        while (i < tvars.length) {
            GenTypeSolid upperBound = (GenTypeSolid)JavaUtils15.genTypeFromType(tvars[i].getBounds()[0]);
            rlist.add(new GenTypeDeclTpar(tvars[i].getName(), upperBound));
            ++i;
        }
        return rlist;
    }

    public List getTypeParams(Class cl) {
        ArrayList<GenTypeDeclTpar> rlist = new ArrayList<GenTypeDeclTpar>();
        TypeVariable<Class<T>>[] tvars = cl.getTypeParameters();
        int i = 0;
        while (i < tvars.length) {
            GenTypeSolid upperBound = (GenTypeSolid)JavaUtils15.genTypeFromType(tvars[i].getBounds()[0]);
            rlist.add(new GenTypeDeclTpar(tvars[i].getName(), upperBound));
            ++i;
        }
        return rlist;
    }

    public GenTypeClass getSuperclass(Class cl) {
        Type sc = cl.getGenericSuperclass();
        if (sc == null) {
            return null;
        }
        return (GenTypeClass)JavaUtils15.genTypeFromType(sc);
    }

    public GenTypeClass[] getInterfaces(Class cl) {
        Type[] classes = cl.getGenericInterfaces();
        GenTypeClass[] gentypes = new GenTypeClass[classes.length];
        int i = 0;
        while (i < classes.length) {
            gentypes[i] = (GenTypeClass)JavaUtils15.genTypeFromType(classes[i]);
            ++i;
        }
        return gentypes;
    }

    public String[] getParameterTypes(Method method) {
        Type[] params = method.getGenericParameterTypes();
        boolean isVarArgs = this.isVarArgs(method);
        return this.getParameterTypes(params, isVarArgs);
    }

    public GenType[] getParamGenTypes(Method method, boolean raw) {
        Type[] params = raw ? method.getParameterTypes() : method.getGenericParameterTypes();
        GenType[] gentypes = new GenType[params.length];
        int i = 0;
        while (i < params.length) {
            gentypes[i] = JavaUtils15.genTypeFromType(params[i]);
            ++i;
        }
        return gentypes;
    }

    public String[] getParameterTypes(Constructor constructor) {
        Type[] params = constructor.getGenericParameterTypes();
        boolean isVarArgs = this.isVarArgs(constructor);
        return this.getParameterTypes(params, isVarArgs);
    }

    public GenType[] getParamGenTypes(Constructor constructor) {
        Type[] params = constructor.getGenericParameterTypes();
        GenType[] gentypes = new GenType[params.length];
        int i = 0;
        while (i < params.length) {
            gentypes[i] = JavaUtils15.genTypeFromType(params[i]);
            ++i;
        }
        return gentypes;
    }

    private String[] getParameterTypes(Type[] params, boolean isVarArgs) {
        String[] parameterTypes = new String[params.length];
        int j = 0;
        while (j < params.length) {
            String typeName = JavaUtils15.getTypeName(params[j]);
            if (isVarArgs && j == params.length - 1) {
                typeName = JavaUtils15.createVarArg(typeName);
            }
            parameterTypes[j] = typeName;
            ++j;
        }
        return parameterTypes;
    }

    private static String getTypeName(Type type) {
        StringBuffer sb = new StringBuffer();
        Type primtype = type;
        int dimensions = 0;
        while (primtype instanceof GenericArrayType) {
            ++dimensions;
            primtype = ((GenericArrayType)primtype).getGenericComponentType();
        }
        if (primtype == null) {
            Debug.message("type == null??");
        }
        if (primtype instanceof Class) {
            sb.append(JavaUtils14.getTypeName((Class)primtype));
        } else if (primtype instanceof ParameterizedType) {
            sb.append(JavaUtils15.getTypeName((ParameterizedType)primtype));
        } else if (primtype instanceof TypeVariable) {
            sb.append(((TypeVariable)primtype).getName());
        } else if (primtype instanceof WildcardType) {
            sb.append(JavaUtils15.getTypeName((WildcardType)primtype));
        } else {
            Debug.message("getTypeName: Unknown type: " + primtype.getClass().getName());
        }
        while (dimensions > 0) {
            sb.append("[]");
            --dimensions;
        }
        return sb.toString();
    }

    private static String getTypeName(ParameterizedType type) {
        StringBuffer sb = new StringBuffer();
        sb.append(JavaUtils15.getTypeName(type.getRawType()));
        sb.append('<');
        Type[] argTypes = type.getActualTypeArguments();
        int i = 0;
        while (i < argTypes.length) {
            sb.append(JavaUtils15.getTypeName(argTypes[i]));
            if (i != argTypes.length - 1) {
                sb.append(',');
            }
            ++i;
        }
        sb.append('>');
        return sb.toString();
    }

    private static String getTypeName(WildcardType type) {
        StringBuffer sb = new StringBuffer();
        Type[] upperBounds = type.getUpperBounds();
        Type[] lowerBounds = type.getLowerBounds();
        if (lowerBounds.length == 0 || lowerBounds[0] == null) {
            if (upperBounds.length == 0 || upperBounds[0] == null || upperBounds[0].equals(Object.class)) {
                sb.append("?");
            } else {
                sb.append("? extends ");
                sb.append(JavaUtils15.getTypeName(upperBounds[0]));
                if (upperBounds.length != 1) {
                    Debug.message("getTypeName: multiple upper bounds for wildcard type?");
                }
            }
        } else {
            sb.append("? super ");
            if (lowerBounds[0] == null) {
                Debug.message("lower bound[0] is null??");
                sb.append("[null type]");
            } else {
                sb.append(JavaUtils15.getTypeName(lowerBounds[0]));
            }
            if (upperBounds.length != 0 && upperBounds[0] != null && upperBounds[0] != Object.class) {
                Debug.message("getTypeName: upper and lower bound?");
                Debug.message("upper bound is: " + upperBounds[0]);
            }
            if (lowerBounds.length != 1) {
                Debug.message("getTypeName: multiple lower bounds for wildcard type?");
            }
        }
        return sb.toString();
    }

    private static String makeSignature(String name, Type[] params, boolean isVarArgs) {
        StringBuffer sb = new StringBuffer();
        sb.append(name);
        sb.append("(");
        int j = 0;
        while (j < params.length) {
            String typeName = JavaUtils15.getTypeName(params[j]);
            if (isVarArgs && j == params.length - 1) {
                typeName = JavaUtils15.createVarArg(typeName);
            }
            sb.append(typeName);
            if (j < params.length - 1) {
                sb.append(",");
            }
            ++j;
        }
        sb.append(")");
        return sb.toString();
    }

    private static String createVarArg(String typeName) {
        String lastArrayStripped = typeName.substring(0, typeName.length() - 2);
        return String.valueOf(lastArrayStripped) + " ...";
    }

    private static String getTypeParameters(Method method) {
        TypeVariable<Method>[] tparams = method.getTypeParameters();
        if (tparams.length != 0) {
            String name = "<";
            int i = 0;
            while (i < tparams.length) {
                TypeVariable<Method> type = tparams[i];
                name = String.valueOf(name) + type.getName();
                Type[] upperBounds = type.getBounds();
                if (upperBounds.length != 0 && upperBounds[0] != null && !upperBounds[0].equals(Object.class)) {
                    name = String.valueOf(name) + " extends " + JavaUtils15.getTypeName(upperBounds[0]);
                    if (upperBounds.length != 1) {
                        Debug.message("getTypeName: multiple upper bounds for typevariable type?");
                    }
                }
                if (i != tparams.length - 1) {
                    name = String.valueOf(name) + ',';
                }
                ++i;
            }
            return String.valueOf(name) + "> ";
        }
        return "";
    }

    private static GenType genTypeFromType(Type t) {
        if (t instanceof Class) {
            return JavaUtils14.genTypeFromClass((Class)t);
        }
        if (t instanceof TypeVariable) {
            return new GenTypeTpar(((TypeVariable)t).getName());
        }
        if (t instanceof WildcardType) {
            WildcardType wtype = (WildcardType)t;
            Type[] upperBounds = wtype.getUpperBounds();
            Type[] lowerBounds = wtype.getLowerBounds();
            if (lowerBounds.length == 0 || lowerBounds[0] == null) {
                if (upperBounds.length == 0 || upperBounds[0] == null) {
                    return new GenTypeUnbounded();
                }
                GenTypeSolid gtp = (GenTypeSolid)JavaUtils15.genTypeFromType(upperBounds[0]);
                if (upperBounds.length != 1) {
                    Debug.message("GenTypeFromType: multiple upper bounds for wildcard type?");
                }
                return new GenTypeExtends(gtp);
            }
            if (lowerBounds[0] == null) {
                Debug.message("lower bound[0] is null??");
                return new GenTypeSuper(null);
            }
            if (upperBounds.length != 0 && upperBounds[0] != null && upperBounds[0] != Object.class) {
                Debug.message("getTypeName: upper and lower bound?");
            }
            if (lowerBounds.length != 1) {
                Debug.message("getTypeName: multiple lower bounds for wildcard type?");
            }
            GenTypeSolid lbound = (GenTypeSolid)JavaUtils15.genTypeFromType(lowerBounds[0]);
            return new GenTypeSuper(lbound);
        }
        if (t instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)t;
            Class rawtype = (Class)pt.getRawType();
            Type[] argtypes = pt.getActualTypeArguments();
            ArrayList<GenType> arggentypes = new ArrayList<GenType>();
            int i = 0;
            while (i < argtypes.length) {
                arggentypes.add(JavaUtils15.genTypeFromType(argtypes[i]));
                ++i;
            }
            return new GenTypeClass((Reflective)new JavaReflective(rawtype), arggentypes);
        }
        GenericArrayType gat = (GenericArrayType)t;
        GenType componentType = JavaUtils15.genTypeFromType(gat.getGenericComponentType());
        return new GenTypeArray(componentType, new JavaArrayReflective(gat));
    }
}

