/*
 * Decompiled with CFR 0.152.
 */
package bluej.testmgr;

import bluej.BlueJTheme;
import bluej.Config;
import bluej.debugger.DebuggerTestResult;
import bluej.debugger.SourceLocation;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.Project;
import bluej.testmgr.CounterPanel;
import bluej.testmgr.MyCellRenderer;
import bluej.testmgr.ProgressBar;
import bluej.utility.JavaNames;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.InvocationTargetException;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class TestDisplayFrame {
    static TestDisplayFrame singleton = null;
    private JFrame frame;
    private DefaultListModel testEntries;
    private JList testnames;
    private ProgressBar pb;
    private GridBagConstraints pbConstraints;
    private JPanel statusLabel;
    private JPanel topPanel;
    private static final int PROGRESS_BAR_INDEX = 2;
    private CounterPanel cp;
    private int errorCount = 0;
    private int failureCount = 0;
    private int testTotal = 0;
    private boolean doingMultiple = false;
    private JTextArea exceptionMessageField;
    private JButton showSourceButton;
    private Project lastProject;

    public static synchronized TestDisplayFrame getTestDisplay() {
        if (singleton == null) {
            singleton = new TestDisplayFrame();
        }
        return singleton;
    }

    public static boolean isFrameShown() {
        if (singleton == null) {
            return false;
        }
        return singleton.isShown();
    }

    public TestDisplayFrame() {
        this.createUI();
    }

    public void showTestDisplay(boolean doShow) {
        this.frame.setVisible(doShow);
    }

    public boolean isShown() {
        return this.frame.isShowing();
    }

    protected void createUI() {
        this.frame = new JFrame(Config.getString("testdisplay.title"));
        this.frame.setIconImage(BlueJTheme.getIconImage());
        this.frame.setLocation(Config.getLocation("bluej.testdisplay"));
        this.frame.addComponentListener(new ComponentAdapter(){

            public void componentMoved(ComponentEvent event) {
                Config.putLocation("bluej.testdisplay", TestDisplayFrame.this.frame.getLocation());
            }
        });
        this.topPanel = new JPanel();
        this.topPanel.setBorder(BlueJTheme.generalBorder);
        this.topPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        JScrollPane jsp = new JScrollPane();
        this.testEntries = new DefaultListModel();
        this.testnames = new JList(this.testEntries);
        this.testnames.setCellRenderer(new MyCellRenderer());
        this.testnames.addListSelectionListener(new MyListSelectionListener());
        this.testnames.addMouseListener(new ShowSourceListener());
        jsp.setViewportView(this.testnames);
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridx = 0;
        this.topPanel.add((Component)jsp, c);
        c.weighty = 0.0;
        this.topPanel.add(Box.createVerticalStrut(5), c);
        this.pb = new ProgressBar();
        this.topPanel.add((Component)this.pb, c);
        this.topPanel.add(Box.createVerticalStrut(5), c);
        this.cp = new CounterPanel();
        this.topPanel.add((Component)this.cp, c);
        this.topPanel.add(Box.createVerticalStrut(5), c);
        this.exceptionMessageField = new JTextArea("");
        this.exceptionMessageField.setEditable(false);
        CompoundBorder x = new CompoundBorder(new LineBorder(Color.BLACK, 1), new EmptyBorder(2, 2, 2, 2));
        this.exceptionMessageField.setBorder(x);
        this.exceptionMessageField.setRows(2);
        this.exceptionMessageField.setLineWrap(true);
        this.exceptionMessageField.setFocusable(false);
        Dimension size = this.exceptionMessageField.getPreferredSize();
        size.width = this.exceptionMessageField.getMaximumSize().width;
        this.exceptionMessageField.setPreferredSize(size);
        size.width = this.exceptionMessageField.getMinimumSize().width;
        this.exceptionMessageField.setMinimumSize(size);
        this.showSourceButton = new JButton(Config.getString("testdisplay.showsource"));
        this.showSourceButton.addActionListener(new ShowSourceListener());
        JButton closeButton = new JButton(Config.getString("close"));
        closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TestDisplayFrame.this.frame.setVisible(false);
            }
        });
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        buttonPanel.add(this.showSourceButton);
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(closeButton);
        c.weighty = 0.1;
        this.topPanel.add((Component)this.exceptionMessageField, c);
        c.weighty = 0.0;
        this.topPanel.add(Box.createVerticalStrut(5), c);
        this.topPanel.add((Component)buttonPanel, c);
        c.gridy = 2;
        this.pbConstraints = c;
        this.frame.getContentPane().add(this.topPanel);
        this.frame.pack();
    }

    protected void reset() {
        this.testEntries.clear();
        this.errorCount = 0;
        this.failureCount = 0;
        this.testTotal = 0;
        this.exceptionMessageField.setText("");
        this.showSourceButton.setEnabled(false);
        this.pb.reset();
        this.cp.setTotal(0);
        this.cp.setErrorValue(0);
        this.cp.setFailureValue(0);
        this.topPanel.remove(2);
        this.topPanel.add(this.pb, this.pbConstraints, 2);
        this.topPanel.validate();
        this.pb.repaint();
    }

    public void startMultipleTests() {
        this.doingMultiple = true;
        this.reset();
    }

    public void endMultipleTests() {
        this.doingMultiple = false;
        try {
            EventQueue.invokeAndWait(new Runnable(){

                public void run() {
                    TestDisplayFrame.this.setResultLabel();
                }
            });
        }
        catch (InvocationTargetException ite) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void startTest(Project project, int num) {
        this.lastProject = project;
        if (this.doingMultiple) {
            this.testTotal += num;
        } else {
            this.reset();
            this.testTotal = num;
        }
        this.cp.setTotal(this.testTotal);
        this.pb.setmaximum(this.testTotal);
    }

    public void addResult(DebuggerTestResult dtr) {
        this.addResultQuietly(dtr);
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                TestDisplayFrame.this.showTestDisplay(true);
            }
        });
    }

    public void addResultQuietly(final DebuggerTestResult dtr) {
        if (!dtr.isSuccess()) {
            if (dtr.isFailure()) {
                ++this.failureCount;
            } else {
                ++this.errorCount;
            }
        }
        try {
            EventQueue.invokeAndWait(new Runnable(){

                public void run() {
                    TestDisplayFrame.this.testEntries.addElement(dtr);
                    TestDisplayFrame.this.pb.step(TestDisplayFrame.this.testEntries.getSize(), dtr.isSuccess());
                    TestDisplayFrame.this.cp.setFailureValue(TestDisplayFrame.this.failureCount);
                    TestDisplayFrame.this.cp.setErrorValue(TestDisplayFrame.this.errorCount);
                    TestDisplayFrame.this.cp.setRunValue(TestDisplayFrame.this.testEntries.getSize());
                    if (!TestDisplayFrame.this.doingMultiple && TestDisplayFrame.this.pb.getValue() == TestDisplayFrame.this.pb.getMaximum()) {
                        TestDisplayFrame.this.setResultLabel();
                    }
                }
            });
        }
        catch (InvocationTargetException ite) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void setResultLabel() {
        this.statusLabel = new JPanel();
        if (this.errorCount + this.failureCount == 0) {
            this.statusLabel.setBackground(ProgressBar.greenBarColour);
        } else {
            this.statusLabel.setBackground(ProgressBar.redBarColour);
        }
        this.statusLabel.setMinimumSize(this.pb.getMinimumSize());
        this.statusLabel.setMaximumSize(this.pb.getMaximumSize());
        this.statusLabel.setPreferredSize(this.pb.getSize());
        this.statusLabel.setOpaque(true);
        this.topPanel.remove(2);
        this.topPanel.add(this.statusLabel, this.pbConstraints, 2);
        this.topPanel.validate();
        this.statusLabel.repaint();
    }

    class ShowSourceListener
    extends MouseAdapter
    implements ActionListener {
        ShowSourceListener() {
        }

        public void mouseClicked(MouseEvent e) {
            int cc = e.getClickCount();
            if (cc == 2) {
                this.showSource();
            }
        }

        public void actionPerformed(ActionEvent e) {
            this.showSource();
        }

        private void showSource() {
            DebuggerTestResult dtr = (DebuggerTestResult)TestDisplayFrame.this.testnames.getSelectedValue();
            if (dtr != null && (dtr.isError() || dtr.isFailure())) {
                SourceLocation exceptionLocation = dtr.getExceptionLocation();
                String packageName = JavaNames.getPrefix(exceptionLocation.getClassName());
                Package spackage = TestDisplayFrame.this.lastProject.getExistingPackage(packageName);
                if (spackage == null) {
                    return;
                }
                String sourceName = exceptionLocation.getFileName();
                int lineno = exceptionLocation.getLineNumber();
                spackage.showSource(sourceName, lineno, "", false);
            }
        }
    }

    class MyListSelectionListener
    implements ListSelectionListener {
        MyListSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
            if (TestDisplayFrame.this.testnames.getSelectedValue() != null) {
                DebuggerTestResult dtr = (DebuggerTestResult)TestDisplayFrame.this.testnames.getSelectedValue();
                if (dtr.isError() || dtr.isFailure()) {
                    if (dtr.isError()) {
                        String text = dtr.getTrace();
                        int index = text.indexOf(10);
                        if (index == -1) {
                            index = text.length();
                        }
                        TestDisplayFrame.this.exceptionMessageField.setText(text.substring(0, index));
                    } else {
                        TestDisplayFrame.this.exceptionMessageField.setText(dtr.getExceptionMessage());
                    }
                    TestDisplayFrame.this.exceptionMessageField.setCaretPosition(0);
                    if (dtr.getExceptionLocation() != null) {
                        TestDisplayFrame.this.showSourceButton.setEnabled(true);
                    }
                } else {
                    TestDisplayFrame.this.exceptionMessageField.setText("");
                    TestDisplayFrame.this.showSourceButton.setEnabled(false);
                }
            }
        }
    }
}

