/*
 * Decompiled with CFR 0.152.
 */
package bluej.terminal;

import bluej.BlueJEvent;
import bluej.BlueJEventListener;
import bluej.Config;
import bluej.debugger.DebuggerTerminal;
import bluej.pkgmgr.Project;
import bluej.prefmgr.PrefMgr;
import bluej.terminal.InputBuffer;
import bluej.terminal.TermTextArea;
import bluej.utility.Debug;
import bluej.utility.DialogManager;
import bluej.utility.FileUtility;
import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.text.BadLocationException;

public final class Terminal
extends JFrame
implements KeyListener,
BlueJEventListener,
DebuggerTerminal {
    private static final String WINDOWTITLE = Config.getString("terminal.title");
    private static final int windowHeight = Config.getPropInteger("bluej.terminal.height", 22);
    private static final int windowWidth = Config.getPropInteger("bluej.terminal.width", 80);
    private static final Color fgColour = Color.black;
    private static final Color errorColour = Color.red;
    private static final Image iconImage = Config.getImageAsIcon("image.icon.terminal").getImage();
    private static final int SHORTCUT_MASK = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
    static boolean enabled = true;
    private Project project;
    private TermTextArea text;
    private JTextArea errorText;
    private JScrollPane errorScrollPane;
    private JScrollPane scrollPane;
    private JSplitPane splitPane;
    private boolean isActive = false;
    private boolean recordMethodCalls = false;
    private boolean clearOnMethodCall = false;
    private boolean newMethodCall = false;
    private boolean errorShown = false;
    private InputBuffer buffer;
    private JCheckBoxMenuItem autoClear;
    private JCheckBoxMenuItem recordCalls;
    private JCheckBoxMenuItem unlimitedBuffering;
    private Reader in = new TerminalReader();
    private Writer out = new TerminalWriter(false);
    private Writer err = new TerminalWriter(true);
    private StringBuffer erroutBuffer = new StringBuffer(120);

    public Terminal(Project project) {
        this(WINDOWTITLE + " - " + project.getProjectName(), windowWidth, windowHeight);
        this.project = project;
    }

    private Terminal(String title, int columns, int rows) {
        super(title);
        this.buffer = new InputBuffer(256);
        this.makeWindow(columns, rows);
        BlueJEvent.addListener(this);
    }

    public void showHide(boolean show) {
        this.setVisible(show);
        if (show) {
            this.text.requestFocus();
        }
    }

    public boolean isShown() {
        return this.isShowing();
    }

    public void activate(boolean active) {
        if (active != this.isActive) {
            this.text.setEditable(active);
            this.isActive = active;
        }
    }

    public void clear() {
        this.text.setText("");
        if (this.errorText != null) {
            this.errorText.setText("");
        }
        this.hideErrorPane();
    }

    public void save() {
        String fileName = FileUtility.getFileName(this, Config.getString("terminal.save.title"), Config.getString("terminal.save.buttonText"), false, null, false);
        if (fileName != null) {
            try {
                FileWriter writer = new FileWriter(fileName);
                this.text.write(writer);
                writer.close();
            }
            catch (IOException ex) {
                DialogManager.showError(this, "error-save-file");
            }
        }
    }

    private void writeToTerminal(String s) {
        this.text.append(s);
        this.text.setCaretPosition(this.text.getDocument().getLength());
    }

    private void writeToTerminal(char ch) {
        if (ch == '\f') {
            this.clear();
        } else {
            this.text.append(String.valueOf(ch));
            this.text.setCaretPosition(this.text.getDocument().getLength());
        }
    }

    private void writeToErrorOut(String s) {
        this.showErrorPane();
        this.errorText.append(s);
        this.errorText.setCaretPosition(this.errorText.getDocument().getLength());
    }

    private void writeToErrorOut(char ch) {
        this.erroutBuffer.append(ch);
        if (ch == '\n') {
            if (this.erroutBuffer.indexOf("Java_apple_awt_") == -1) {
                this.showErrorPane();
                this.errorText.append(this.erroutBuffer.toString());
                this.errorText.setCaretPosition(this.errorText.getDocument().getLength());
            }
            this.erroutBuffer.setLength(0);
        }
    }

    private void prepare() {
        if (this.newMethodCall) {
            this.showHide(true);
            this.newMethodCall = false;
        }
    }

    private void methodCall(String callString) {
        this.newMethodCall = false;
        if (this.clearOnMethodCall) {
            this.clear();
        }
        if (this.recordMethodCalls) {
            try {
                if (this.text.getCaretPosition() != this.text.getLineStartOffset(this.text.getLineCount())) {
                    this.writeToTerminal('\n');
                }
            }
            catch (BadLocationException exc) {
                this.writeToTerminal('\n');
            }
            if (callString != null) {
                this.writeToTerminal("[ ");
                this.writeToTerminal(callString);
                this.writeToTerminal(" ]\n");
            }
        }
        this.newMethodCall = true;
    }

    public Reader getReader() {
        return this.in;
    }

    public Writer getWriter() {
        return this.out;
    }

    public Writer getErrorWriter() {
        return this.err;
    }

    public void keyPressed(KeyEvent event) {
        if (event.getModifiers() != SHORTCUT_MASK) {
            event.consume();
        }
    }

    public void keyReleased(KeyEvent event) {
        if (event.getModifiers() != SHORTCUT_MASK) {
            event.consume();
        }
    }

    public void keyTyped(KeyEvent event) {
        if (this.isActive) {
            char ch = event.getKeyChar();
            switch (ch) {
                case '\b': {
                    if (!this.buffer.backSpace()) break;
                    try {
                        int length = this.text.getDocument().getLength();
                        this.text.replaceRange("", length - 1, length);
                    }
                    catch (Exception exc) {
                        Debug.reportError("bad location " + exc);
                    }
                    break;
                }
                case '\n': 
                case '\r': {
                    if (!this.buffer.putChar('\n')) break;
                    this.writeToTerminal(ch);
                    this.buffer.notifyReaders();
                    break;
                }
                default: {
                    if (!this.buffer.putChar(ch)) break;
                    this.writeToTerminal(ch);
                }
            }
        }
        event.consume();
    }

    public void blueJEvent(int eventId, Object arg) {
        if (eventId == 3) {
            this.methodCall((String)arg);
        }
    }

    private void makeWindow(int columns, int rows) {
        this.setIconImage(iconImage);
        this.text = new TermTextArea(rows, columns);
        this.scrollPane = new JScrollPane(this.text);
        this.text.setFont(PrefMgr.getTerminalFont());
        this.text.setEditable(true);
        this.text.setLineWrap(false);
        this.text.setForeground(fgColour);
        this.text.setMargin(new Insets(6, 6, 6, 6));
        this.text.addKeyListener(this);
        this.getContentPane().add((Component)this.scrollPane, "Center");
        this.setJMenuBar(this.makeMenuBar());
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent event) {
                Window win = (Window)event.getSource();
                if (Terminal.this.project != null && Terminal.this.project.getDebugger().getStatus() == 3) {
                    return;
                }
                win.setVisible(false);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentMoved(ComponentEvent event) {
                Config.putLocation("bluej.terminal", Terminal.this.getLocation());
            }
        });
        this.setDefaultCloseOperation(0);
        this.setLocation(Config.getLocation("bluej.terminal"));
        this.pack();
    }

    private void createErrorPane() {
        this.errorText = new JTextArea(5, this.text.getColumns());
        this.errorScrollPane = new JScrollPane(this.errorText);
        this.errorText.setFont(PrefMgr.getTerminalFont());
        this.errorText.setEditable(false);
        this.errorText.setLineWrap(false);
        this.errorText.setForeground(errorColour);
        this.errorText.setMargin(new Insets(6, 6, 6, 6));
        this.splitPane = new JSplitPane(0, this.scrollPane, this.errorScrollPane);
    }

    private void showErrorPane() {
        if (this.errorShown) {
            return;
        }
        boolean doPack = false;
        if (this.errorText == null) {
            doPack = true;
            this.createErrorPane();
        }
        this.getContentPane().remove(this.scrollPane);
        this.getContentPane().add((Component)this.splitPane, "Center");
        this.splitPane.resetToPreferredSizes();
        if (doPack) {
            this.pack();
        } else {
            this.validate();
        }
        this.errorShown = true;
    }

    private void hideErrorPane() {
        if (!this.errorShown) {
            return;
        }
        this.getContentPane().remove(this.splitPane);
        this.getContentPane().add((Component)this.scrollPane, "Center");
        this.errorShown = false;
        this.validate();
    }

    private JMenuBar makeMenuBar() {
        JMenuBar menubar = new JMenuBar();
        JMenu menu = new JMenu(Config.getString("terminal.options"));
        JMenuItem item = menu.add(new ClearAction());
        item.setAccelerator(KeyStroke.getKeyStroke(75, SHORTCUT_MASK));
        item = menu.add(this.getCopyAction());
        item.setText(Config.getString("terminal.copy"));
        item.setAccelerator(KeyStroke.getKeyStroke(67, SHORTCUT_MASK));
        item = menu.add(new SaveAction());
        item.setAccelerator(KeyStroke.getKeyStroke(83, SHORTCUT_MASK));
        menu.add(new JSeparator());
        this.autoClear = new JCheckBoxMenuItem(new AutoClearAction());
        menu.add(this.autoClear);
        this.recordCalls = new JCheckBoxMenuItem(new RecordCallAction());
        menu.add(this.recordCalls);
        this.unlimitedBuffering = new JCheckBoxMenuItem(new BufferAction());
        menu.add(this.unlimitedBuffering);
        menu.add(new JSeparator());
        item = menu.add(new CloseAction());
        item.setAccelerator(KeyStroke.getKeyStroke(87, SHORTCUT_MASK));
        menubar.add(menu);
        return menubar;
    }

    private Action getCopyAction() {
        Action[] textActions = this.text.getActions();
        for (int i = 0; i < textActions.length; ++i) {
            if (!textActions[i].getValue("Name").equals("copy-to-clipboard")) continue;
            return textActions[i];
        }
        return null;
    }

    private class TerminalWriter
    extends Writer {
        private boolean isErrorOut;

        TerminalWriter(boolean isError) {
            this.isErrorOut = isError;
        }

        public void write(char[] cbuf, int off, int len) {
            if (enabled) {
                Terminal.this.prepare();
                if (this.isErrorOut) {
                    Terminal.this.writeToErrorOut(new String(cbuf, off, len));
                } else {
                    Terminal.this.writeToTerminal(new String(cbuf, off, len));
                }
            }
        }

        public void write(int ch) {
            if (enabled) {
                Terminal.this.prepare();
                if (this.isErrorOut) {
                    Terminal.this.writeToErrorOut((char)ch);
                } else {
                    Terminal.this.writeToTerminal((char)ch);
                }
            }
        }

        public void flush() {
        }

        public void close() {
        }
    }

    private class TerminalReader
    extends Reader {
        private TerminalReader() {
        }

        public int read(char[] cbuf, int off, int len) {
            int charsRead;
            for (charsRead = 0; charsRead < len; ++charsRead) {
                cbuf[off + charsRead] = Terminal.this.buffer.getChar();
                if (Terminal.this.buffer.numberOfCharacters() != 0) continue;
                break;
            }
            return charsRead;
        }

        public void close() {
        }
    }

    private class BufferAction
    extends AbstractAction {
        public BufferAction() {
            super(Config.getString("terminal.buffering"));
        }

        public void actionPerformed(ActionEvent e) {
            Terminal.this.text.setUnlimitedBuffering(Terminal.this.unlimitedBuffering.isSelected());
        }
    }

    private class RecordCallAction
    extends AbstractAction {
        public RecordCallAction() {
            super(Config.getString("terminal.recordCalls"));
        }

        public void actionPerformed(ActionEvent e) {
            Terminal.this.recordMethodCalls = Terminal.this.recordCalls.isSelected();
        }
    }

    private class AutoClearAction
    extends AbstractAction {
        public AutoClearAction() {
            super(Config.getString("terminal.clearScreen"));
        }

        public void actionPerformed(ActionEvent e) {
            Terminal.this.clearOnMethodCall = Terminal.this.autoClear.isSelected();
        }
    }

    private class CloseAction
    extends AbstractAction {
        public CloseAction() {
            super(Config.getString("terminal.close"));
        }

        public void actionPerformed(ActionEvent e) {
            Terminal.this.showHide(false);
        }
    }

    private class SaveAction
    extends AbstractAction {
        public SaveAction() {
            super(Config.getString("terminal.save"));
        }

        public void actionPerformed(ActionEvent e) {
            Terminal.this.save();
        }
    }

    private class ClearAction
    extends AbstractAction {
        public ClearAction() {
            super(Config.getString("terminal.clear"));
        }

        public void actionPerformed(ActionEvent e) {
            Terminal.this.clear();
        }
    }
}

