/*
 * Decompiled with CFR 0.152.
 */
package bluej.terminal;

import bluej.utility.Debug;
import javax.swing.JTextArea;
import javax.swing.text.BadLocationException;

public final class TermTextArea
extends JTextArea {
    private static final int BUFFER_LINES = 48;
    private boolean unlimitedBuffer = false;

    public TermTextArea(int rows, int columns) {
        super(rows, columns);
    }

    public void setUnlimitedBuffering(boolean arg) {
        this.unlimitedBuffer = arg;
    }

    public void append(String s) {
        int lines;
        super.append(s);
        if (!this.unlimitedBuffer && (lines = this.getLineCount()) > 48) {
            try {
                int linePos = this.getLineStartOffset(lines - 48);
                this.replaceRange(null, 0, linePos);
            }
            catch (BadLocationException exc) {
                Debug.reportError("bad location in terminal operation");
            }
        }
    }
}

