/*
 * Decompiled with CFR 0.152.
 */
package bluej.runtime;

import bluej.runtime.RemoteClassMgr;
import bluej.runtime.RemoteSecurityManager;
import bluej.runtime.RemoteTestRunner;
import java.awt.AWTEvent;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestFailure;
import junit.framework.TestResult;
import junit.framework.TestSuite;

public class ExecServer {
    public static final String NEW_LOADER = "newLoader";
    public static final String LOAD_CLASS = "loadClass";
    public static final String ADD_OBJECT = "addObject";
    public static final String REMOVE_OBJECT = "removeObject";
    public static final String SET_LIBRARIES = "setLibraries";
    public static final String RUN_TEST_SETUP = "runTestSetUp";
    public static final String RUN_TEST_METHOD = "runTestMethod";
    public static final String SUPRESS_OUTPUT = "supressOutput";
    public static final String RESTORE_OUTPUT = "restoreOutput";
    public static final String MAIN_THREAD_NAME = "mainThread";
    public static Thread mainThread = null;
    public static final String WORKER_THREAD_NAME = "workerThread";
    public static Thread workerThread = null;
    public static String classToRun;
    public static String methodToRun;
    public static int execAction;
    public static Object methodReturn;
    public static Throwable exception;
    public static final String CLASS_TO_RUN_NAME = "classToRun";
    public static final String METHOD_TO_RUN_NAME = "methodToRun";
    public static final String EXEC_ACTION_NAME = "execAction";
    public static final String METHOD_RETURN_NAME = "methodReturn";
    public static final String EXCEPTION_NAME = "exception";
    public static final int EXEC_SHELL = 0;
    public static final int TEST_SETUP = 1;
    public static final int TEST_RUN = 2;
    public static final int DISPOSE_WINDOWS = 3;
    public static final int EXIT_VM = 4;
    private static RemoteClassMgr classmgr;
    private static ClassLoader currentLoader;
    private static Map objects;
    public static final String SHOULD_DIE = "shouldDie";
    public static boolean shouldDie;
    private static List openWindows;
    private static boolean disposingAllWindows;
    private static PrintStream systemErr;
    private static ByteArrayOutputStream throwawayErr;
    static /* synthetic */ Class class$java$lang$String;

    public static void main(String[] args) throws Throwable {
        classmgr = new RemoteClassMgr();
        try {
            ExecServer.newLoader(".");
            ExecServer.loadClass("Dummy");
            currentLoader = null;
        }
        catch (Exception e) {
            // empty catch block
        }
        workerThread = new Thread("BlueJ worker thread"){

            public void run() {
                while (true) {
                    ExecServer.vmSuspend();
                }
            }
        };
        workerThread.setDaemon(true);
        workerThread.start();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        AWTEventListener listener = new AWTEventListener(){

            public void eventDispatched(AWTEvent event) {
                if (event.getID() == 200) {
                    ExecServer.addWindow(event.getSource());
                } else if (event.getID() == 202) {
                    ExecServer.removeWindow(event.getSource());
                }
            }
        };
        toolkit.addAWTEventListener(listener, 64L);
        System.setSecurityManager(new RemoteSecurityManager());
        ExecServer.newThread();
    }

    public static void vmStarted() {
    }

    public static void vmSuspend() {
    }

    private static void addWindow(Object o) {
        openWindows.add(o);
    }

    private static void removeWindow(Object o) {
        if (!disposingAllWindows) {
            openWindows.remove(o);
        }
    }

    static Map getScope() {
        return objects;
    }

    private static ClassLoader newLoader(String classPath) {
        currentLoader = classmgr.getLoader(classPath);
        return currentLoader;
    }

    private static Class loadClass(String className) throws ClassNotFoundException {
        Class<?> cl = null;
        cl = currentLoader == null ? classmgr.getLoader().loadClass(className) : currentLoader.loadClass(className);
        try {
            Method m = cl.getMethod("prepare", null);
            m.invoke(null, null);
        }
        catch (Exception e) {
            ExecServer.forceInitialisation(cl);
        }
        return cl;
    }

    private static void forceInitialisation(Class cl) {
        Field[] fields = cl.getFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            int modifiers = field.getModifiers();
            if (!Modifier.isStatic(modifiers)) continue;
            try {
                field.get(null);
                continue;
            }
            catch (IllegalArgumentException e1) {
                e1.printStackTrace();
                continue;
            }
            catch (IllegalAccessException e1) {
                e1.printStackTrace();
            }
        }
    }

    static void addObject(String instanceName, Object value) {
        Map scope = ExecServer.getScope();
        scope.put(instanceName, value);
    }

    private static void setLibraries(String libraries) {
        classmgr.setLibraries(libraries);
    }

    private static Object[] runTestSetUp(String className) throws ClassNotFoundException {
        Class cl = ExecServer.loadClass(className);
        try {
            Method setUpMethod;
            Object testCase = null;
            Class[] partypes = new Class[]{class$java$lang$String == null ? (class$java$lang$String = ExecServer.class$("java.lang.String")) : class$java$lang$String};
            try {
                Constructor ct = cl.getConstructor(partypes);
                Object[] arglist = new Object[]{"TestCase " + className};
                testCase = ct.newInstance(arglist);
            }
            catch (NoSuchMethodException nsme) {
                testCase = null;
            }
            if (testCase == null) {
                testCase = cl.newInstance();
            }
            if ((setUpMethod = ExecServer.findMethod(cl, "setUp", null)) != null) {
                setUpMethod.setAccessible(true);
                setUpMethod.invoke(testCase, null);
            }
            Field[] fields = cl.getDeclaredFields();
            Object[] obs = new Object[fields.length * 2 + 1];
            for (int i = 0; i < fields.length; ++i) {
                fields[i].setAccessible(true);
                obs[i * 2] = fields[i].getName();
                obs[i * 2 + 1] = fields[i].get(testCase);
            }
            obs[obs.length - 1] = testCase;
            return obs;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return new Object[0];
        }
    }

    private static Method findMethod(Class cl, String name, Class[] paramtypes) {
        while (cl != null) {
            try {
                return cl.getDeclaredMethod(name, paramtypes);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                cl = cl.getSuperclass();
            }
        }
        return null;
    }

    private static Object[] runTestMethod(String className, String methodName) throws ClassNotFoundException {
        Class cl = ExecServer.loadClass(className);
        TestCase testCase = null;
        try {
            Class[] partypes = new Class[]{class$java$lang$String == null ? (class$java$lang$String = ExecServer.class$("java.lang.String")) : class$java$lang$String};
            Constructor ct = cl.getConstructor(partypes);
            Object[] arglist = new Object[]{methodName};
            testCase = (TestCase)ct.newInstance(arglist);
        }
        catch (NoSuchMethodException nsme) {
        }
        catch (InstantiationException ie) {
            throw new IllegalArgumentException("ie");
        }
        catch (IllegalAccessException iae) {
            throw new IllegalArgumentException("iae");
        }
        catch (InvocationTargetException ite) {
            throw new IllegalArgumentException("ite");
        }
        if (testCase == null) {
            try {
                testCase = (TestCase)cl.newInstance();
                testCase.setName(methodName);
            }
            catch (InstantiationException ie) {
            }
            catch (IllegalAccessException iae) {
                // empty catch block
            }
        }
        TestSuite suite = new TestSuite("bluej");
        suite.addTest((Test)testCase);
        RemoteTestRunner runner = new RemoteTestRunner();
        TestResult tr = runner.doRun((Test)suite);
        if (tr.errorCount() > 1 || tr.failureCount() > 1) {
            throw new IllegalStateException("error or failure count was > 1");
        }
        if (tr.errorCount() == 1) {
            Enumeration e = tr.errors();
            if (e.hasMoreElements()) {
                Object[] result = new Object[7];
                TestFailure tf = (TestFailure)e.nextElement();
                result[0] = tf.isFailure() ? "failure" : "error";
                result[1] = tf.exceptionMessage() != null ? tf.exceptionMessage() : "no exception message";
                result[2] = tf.trace() != null ? tf.trace() : "no trace";
                StackTraceElement[] ste = tf.thrownException().getStackTrace();
                result[3] = ste[0].getClassName();
                result[4] = ste[0].getFileName();
                result[5] = ste[0].getMethodName();
                result[6] = String.valueOf(ste[0].getLineNumber());
                return result;
            }
            throw new IllegalStateException("errorCount was 1 but found no errors");
        }
        if (tr.failureCount() == 1) {
            Enumeration e = tr.failures();
            if (e.hasMoreElements()) {
                int i;
                Object[] result = new Object[7];
                TestFailure tf = (TestFailure)e.nextElement();
                result[0] = tf.isFailure() ? "failure" : "error";
                result[1] = tf.exceptionMessage() != null ? tf.exceptionMessage() : "no exception message";
                result[2] = tf.trace() != null ? tf.trace() : "no trace";
                StackTraceElement[] ste = tf.thrownException().getStackTrace();
                for (i = 0; i < ste.length && ste[i].getClassName().startsWith("junit."); ++i) {
                }
                result[3] = ste[i].getClassName();
                result[4] = ste[i].getFileName();
                result[5] = ste[i].getMethodName();
                result[6] = String.valueOf(ste[i].getLineNumber());
                return result;
            }
            throw new IllegalStateException("failureCount was 1 but found no errors");
        }
        return null;
    }

    private static void removeObject(String instanceName) {
        Map scope = ExecServer.getScope();
        scope.remove(instanceName);
    }

    static void supressOutput() {
        throwawayErr = new ByteArrayOutputStream();
        System.setErr(new PrintStream(throwawayErr));
    }

    static void restoreOutput() {
        System.setErr(systemErr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void disposeWindows() {
        List list = openWindows;
        synchronized (list) {
            disposingAllWindows = true;
            Iterator it = openWindows.iterator();
            while (it.hasNext()) {
                Object o = it.next();
                if (!(o instanceof Window)) continue;
                Window w = (Window)o;
                w.dispose();
            }
            openWindows.clear();
            disposingAllWindows = false;
        }
    }

    static void clearInputBuffer() {
        try {
            int n = System.in.available();
            while (n != 0) {
                System.in.skip(n);
                n = System.in.available();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static void newThread() {
        final Thread oldThread = mainThread;
        mainThread = new Thread("main"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                try {
                    if (oldThread != null) {
                        oldThread.join();
                    }
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
                ExecServer.vmStarted();
                methodReturn = null;
                exception = null;
                try {
                    switch (execAction) {
                        case 0: {
                            ExecServer.clearInputBuffer();
                            Class<?> c = currentLoader.loadClass(classToRun);
                            Method m = c.getMethod("run", new Class[0]);
                            try {
                                methodReturn = m.invoke(null, new Object[0]);
                                return;
                            }
                            catch (InvocationTargetException ite) {
                                throw ite.getCause();
                            }
                        }
                        case 1: {
                            methodReturn = ExecServer.runTestSetUp(classToRun);
                            return;
                        }
                        case 2: {
                            methodReturn = ExecServer.runTestMethod(classToRun, methodToRun);
                            return;
                        }
                        case 3: {
                            ExecServer.disposeWindows();
                            return;
                        }
                        case 4: {
                            System.exit(0);
                            return;
                        }
                    }
                    return;
                }
                catch (Throwable t) {
                    exception = t;
                    return;
                }
                finally {
                    execAction = 4;
                    ExecServer.newThread();
                }
            }
        };
        mainThread.start();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        objects = new HashMap();
        shouldDie = false;
        openWindows = Collections.synchronizedList(new LinkedList());
        disposingAllWindows = false;
        systemErr = System.err;
        throwawayErr = null;
    }
}

