/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr.target.role;

import bluej.Config;
import bluej.debugger.DebuggerObject;
import bluej.debugger.DebuggerTestResult;
import bluej.editor.Editor;
import bluej.editor.moe.MoeEditor;
import bluej.parser.SourceLocation;
import bluej.parser.SourceSpan;
import bluej.parser.UnitTestAnalyzer;
import bluej.pkgmgr.PackageEditor;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.pkgmgr.target.ClassTarget;
import bluej.pkgmgr.target.Target;
import bluej.pkgmgr.target.role.ClassRole;
import bluej.prefmgr.PrefMgr;
import bluej.testmgr.TestDisplayFrame;
import bluej.testmgr.record.ExistingFixtureInvokerRecord;
import bluej.utility.DialogManager;
import bluej.utility.JavaNames;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class UnitTestClassRole
extends ClassRole {
    public static final String UNITTEST_ROLE_NAME = "UnitTestTarget";
    private final Color unittestbg = Config.getItemColour("colour.class.bg.unittest");
    private static final String popupPrefix = Config.getString("pkgmgr.test.popup.testPrefix");
    private static final String testAll = Config.getString("pkgmgr.test.popup.testAll");
    private static final String createTest = Config.getString("pkgmgr.test.popup.createTest");
    private static final String benchToFixture = Config.getString("pkgmgr.test.popup.benchToFixture");
    private static final String fixtureToBench = Config.getString("pkgmgr.test.popup.fixtureToBench");

    public String getRoleName() {
        return UNITTEST_ROLE_NAME;
    }

    public String getStereotypeLabel() {
        return "unit test";
    }

    public Color getBackgroundColour() {
        return this.unittestbg;
    }

    private boolean isJUnitTestMethod(Method m) {
        if (!m.getName().startsWith("test")) {
            return false;
        }
        if (!Modifier.isPublic(m.getModifiers())) {
            return false;
        }
        if (m.getParameterTypes().length != 0) {
            return false;
        }
        return m.getReturnType().equals(Void.TYPE);
    }

    public boolean createRoleMenu(JPopupMenu menu, ClassTarget ct, Class cl, int state) {
        boolean enableTestAll = false;
        if (state == 0 && cl != null) {
            Method[] allMethods = cl.getMethods();
            for (int i = 0; i < allMethods.length; ++i) {
                Method m = allMethods[i];
                if (!this.isJUnitTestMethod(m)) continue;
                enableTestAll = true;
                break;
            }
        }
        this.addMenuItem(menu, new TestAction(testAll, ct.getPackage().getEditor(), ct), enableTestAll);
        menu.addSeparator();
        return false;
    }

    public boolean createClassConstructorMenu(JPopupMenu menu, ClassTarget ct, Class cl) {
        boolean hasEntries = false;
        Method[] allMethods = cl.getMethods();
        for (int i = 0; i < allMethods.length; ++i) {
            Method m = allMethods[i];
            if (!this.isJUnitTestMethod(m)) continue;
            TestAction testAction = new TestAction(popupPrefix + " " + m.getName().substring(4), ct.getPackage().getEditor(), ct, m.getName());
            JMenuItem item = new JMenuItem();
            item.setAction(testAction);
            item.setFont(PrefMgr.getPopupMenuFont());
            menu.add(item);
            hasEntries = true;
        }
        if (!hasEntries) {
            JMenuItem item = new JMenuItem(Config.getString("pkgmgr.test.popup.noTests"));
            item.setFont(PrefMgr.getPopupMenuFont());
            item.setEnabled(false);
            menu.add(item);
        }
        return true;
    }

    public boolean createClassStaticMenu(JPopupMenu menu, ClassTarget ct, Class cl) {
        boolean enable = !ct.getPackage().getProject().inTestMode() && ct.hasSourceCode();
        this.addMenuItem(menu, new MakeTestCaseAction(createTest, ct.getPackage().getEditor(), ct), enable);
        this.addMenuItem(menu, new BenchToFixtureAction(benchToFixture, ct.getPackage().getEditor(), ct), enable);
        this.addMenuItem(menu, new FixtureToBenchAction(fixtureToBench, ct.getPackage().getEditor(), ct), enable);
        return true;
    }

    public void run(final PkgMgrFrame pmf, final ClassTarget ct, final String param) {
        Thread thr = new Thread(){

            public void run() {
                UnitTestClassRole.this.doRunTest(pmf, ct, param);
            }
        };
        thr.start();
    }

    public void doRunTest(PkgMgrFrame pmf, ClassTarget ct, String param) {
        DebuggerTestResult dtr = null;
        if (param != null) {
            TestDisplayFrame.getTestDisplay().startTest(pmf.getProject(), 1);
            dtr = pmf.getProject().getDebugger().runTestMethod(ct.getQualifiedName(), param);
            if (dtr.isSuccess()) {
                pmf.setStatus(param + " " + Config.getString("pkgmgr.test.succeeded"));
                TestDisplayFrame.getTestDisplay().addResultQuietly(dtr);
            } else {
                TestDisplayFrame.getTestDisplay().addResult(dtr);
            }
        } else {
            int i;
            Class cl = pmf.getPackage().loadClass(ct.getQualifiedName());
            if (cl == null) {
                return;
            }
            Method[] allMethods = cl.getMethods();
            int testCount = 0;
            for (i = 0; i < allMethods.length; ++i) {
                if (!this.isJUnitTestMethod(allMethods[i])) continue;
                ++testCount;
            }
            TestDisplayFrame.getTestDisplay().startTest(pmf.getProject(), testCount);
            for (i = 0; i < allMethods.length; ++i) {
                Method m = allMethods[i];
                if (!this.isJUnitTestMethod(m)) continue;
                dtr = pmf.getProject().getDebugger().runTestMethod(ct.getQualifiedName(), m.getName());
                TestDisplayFrame.getTestDisplay().addResult(dtr);
            }
        }
    }

    public void doMakeTestCase(final PkgMgrFrame pmf, final ClassTarget ct) {
        String newTestName = DialogManager.askString(pmf, "unittest-new-test-method");
        if (newTestName == null) {
            return;
        }
        if (newTestName.length() == 0) {
            pmf.setStatus(Config.getString("pkgmgr.test.noTestName"));
            return;
        }
        if (!newTestName.startsWith("test")) {
            newTestName = "test" + Character.toTitleCase(newTestName.charAt(0)) + newTestName.substring(1);
        }
        if (!JavaNames.isIdentifier(newTestName)) {
            pmf.setStatus(Config.getString("pkgmgr.test.invalidTestName"));
            return;
        }
        try {
            UnitTestAnalyzer uta = new UnitTestAnalyzer(new FileReader(ct.getSourceFile()));
            SourceSpan existingSpan = uta.getMethodBlockSpan(newTestName);
            if (existingSpan != null && DialogManager.askQuestion(null, "unittest-method-present") == 1) {
                return;
            }
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
        }
        pmf.testRecordingStarted(Config.getString("pkgmgr.test.recording") + " " + ct.getBaseName() + "." + newTestName + "()");
        pmf.getProject().removeLocalClassLoader();
        final String testName = newTestName;
        new Thread(){

            public void run() {
                Map dobs = pmf.getProject().getDebugger().runTestSetUp(ct.getQualifiedName());
                EventQueue.invokeLater(new Runnable(this, dobs){
                    private final /* synthetic */ Map val$dobs;
                    private final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = this$1;
                        this.val$dobs = val$dobs;
                    }

                    public void run() {
                        Iterator<Map.Entry<K, V>> it = this.val$dobs.entrySet().iterator();
                        while (it.hasNext()) {
                            Map.Entry<K, V> mapent = it.next();
                            2.access$000(this.this$1).putObjectOnBench((String)mapent.getKey(), (DebuggerObject)mapent.getValue(), null);
                        }
                        2.access$000(this.this$1).getObjectBench().resetRecordingInteractions();
                        2.access$000(this.this$1).setTestInfo(2.access$100(this.this$1), 2.access$200(this.this$1));
                    }
                });
            }

            static /* synthetic */ PkgMgrFrame access$000(2 x0) {
                return x0.pmf;
            }

            static /* synthetic */ String access$100(2 x0) {
                return x0.testName;
            }

            static /* synthetic */ ClassTarget access$200(2 x0) {
                return x0.ct;
            }
        }.start();
    }

    public void doEndMakeTestCase(PkgMgrFrame pmf, ClassTarget ct, String name) {
        Editor ed = ct.getEditor();
        ed.save();
        try {
            UnitTestAnalyzer uta = new UnitTestAnalyzer(new FileReader(ct.getSourceFile()));
            SourceSpan existingSpan = uta.getMethodBlockSpan(name);
            if (existingSpan != null) {
                ed.setSelection(existingSpan.getStartLine(), existingSpan.getStartColumn(), existingSpan.getEndLine(), existingSpan.getEndColumn() + 1);
                ed.insertText("{\n" + pmf.getObjectBench().getTestMethod() + "\t}", false);
            } else {
                SourceLocation methodInsert = uta.getNewMethodInsertLocation();
                if (methodInsert != null) {
                    ed.setSelection(methodInsert.getLine(), methodInsert.getColumn(), 1);
                    ed.insertText("\n\tpublic void " + name + "()\n\t{\n" + pmf.getObjectBench().getTestMethod() + "\t}\n}\n", false);
                }
            }
            ed.save();
        }
        catch (FileNotFoundException fnfe) {
            // empty catch block
        }
    }

    public void doFixtureToBench(PkgMgrFrame pmf, ClassTarget ct) {
        MoeEditor ed = (MoeEditor)ct.getEditor();
        ed.save();
        ExistingFixtureInvokerRecord existing = new ExistingFixtureInvokerRecord();
        try {
            UnitTestAnalyzer uta = new UnitTestAnalyzer(new FileReader(ct.getSourceFile()));
            List fixtureSpans = uta.getFieldSpans();
            ListIterator it = fixtureSpans.listIterator();
            while (it.hasNext()) {
                SourceSpan variableSpan = (SourceSpan)it.next();
                ed.setSelection(variableSpan.getStartLine(), variableSpan.getStartColumn(), variableSpan.getEndLine(), variableSpan.getEndColumn() + 1);
                existing.addFieldDeclaration(ed.getSelectedText());
            }
            SourceSpan setUpSpan = uta.getMethodBlockSpan("setUp");
            if (setUpSpan != null) {
                ed.setSelection(setUpSpan.getStartLine(), setUpSpan.getStartColumn(), setUpSpan.getEndLine(), setUpSpan.getEndColumn() + 1);
                String setUpWithBrackets = ed.getSelectedText();
                String setUpWithoutBrackets = setUpWithBrackets.substring(setUpWithBrackets.indexOf(123) + 1, setUpWithBrackets.indexOf(125)).trim();
                existing.setSetupMethod(setUpWithoutBrackets);
            }
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
        }
        Map dobs = pmf.getProject().getDebugger().runTestSetUp(ct.getQualifiedName());
        Iterator it = dobs.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry mapent = it.next();
            pmf.putObjectOnBench((String)mapent.getKey(), (DebuggerObject)mapent.getValue(), null);
        }
        pmf.getObjectBench().addInteraction(existing);
    }

    public void doBenchToFixture(PkgMgrFrame pmf, ClassTarget ct) {
        if (pmf.getObjectBench().getObjectCount() == 0) {
            return;
        }
        Editor ed = ct.getEditor();
        ed.save();
        try {
            SourceLocation fixtureInsertLocation;
            UnitTestAnalyzer uta = new UnitTestAnalyzer(new FileReader(ct.getSourceFile()));
            List variables = uta.getFieldSpans();
            if (variables != null && variables.size() > 0 && DialogManager.askQuestion(null, "unittest-fixture-present") == 1) {
                return;
            }
            if (variables != null) {
                ListIterator it = variables.listIterator(variables.size());
                while (it.hasPrevious()) {
                    SourceSpan variableSpan = (SourceSpan)it.previous();
                    ed.setSelection(variableSpan.getStartLine(), variableSpan.getStartColumn(), variableSpan.getEndLine(), variableSpan.getEndColumn() + 1);
                    ed.insertText("", false);
                }
                ed.save();
                uta = new UnitTestAnalyzer(new FileReader(ct.getSourceFile()));
            }
            if ((fixtureInsertLocation = uta.getFixtureInsertLocation()) == null) {
                return;
            }
            SourceSpan setupSpan = uta.getMethodBlockSpan("setUp");
            if (setupSpan != null) {
                ed.setSelection(setupSpan.getStartLine(), setupSpan.getStartColumn(), setupSpan.getEndLine(), setupSpan.getEndColumn() + 1);
            } else {
                ed.setSelection(fixtureInsertLocation.getLine(), fixtureInsertLocation.getColumn(), 1);
                ed.insertText("{\n\tpublic void setUp()\n\t", false);
            }
            ed.insertText("{\n" + pmf.getObjectBench().getFixtureSetup() + "\t}", false);
            ed.setSelection(fixtureInsertLocation.getLine(), fixtureInsertLocation.getColumn(), 1);
            ed.insertText("{\n" + pmf.getObjectBench().getFixtureDeclaration(), false);
            ed.save();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        pmf.getProject().removeLocalClassLoader();
        pmf.getProject().newRemoteClassLoader();
        pmf.getPackage().compileQuiet(ct);
    }

    private class FixtureToBenchAction
    extends TargetAbstractAction {
        public FixtureToBenchAction(String name, PackageEditor ped, Target t) {
            super(name, ped, t);
        }

        public void actionPerformed(ActionEvent e) {
            this.ped.raiseFixtureToBenchEvent(this.t);
        }
    }

    private class BenchToFixtureAction
    extends TargetAbstractAction {
        public BenchToFixtureAction(String name, PackageEditor ped, Target t) {
            super(name, ped, t);
        }

        public void actionPerformed(ActionEvent e) {
            this.ped.raiseBenchToFixtureEvent(this.t);
        }
    }

    private class MakeTestCaseAction
    extends TargetAbstractAction {
        public MakeTestCaseAction(String name, PackageEditor ped, Target t) {
            super(name, ped, t);
        }

        public void actionPerformed(ActionEvent e) {
            this.ped.raiseMakeTestCaseEvent(this.t);
        }
    }

    private class TestAction
    extends TargetAbstractAction {
        private String testName;

        public TestAction(String actionName, PackageEditor ped, Target t) {
            super(actionName, ped, t);
            this.testName = null;
        }

        public TestAction(String actionName, PackageEditor ped, Target t, String testName) {
            super(actionName, ped, t);
            this.testName = testName;
        }

        public void actionPerformed(ActionEvent e) {
            this.ped.raiseRunTargetEvent(this.t, this.testName);
        }
    }

    private abstract class TargetAbstractAction
    extends AbstractAction {
        protected Target t;
        protected PackageEditor ped;

        public TargetAbstractAction(String name, PackageEditor ped, Target t) {
            super(name);
            this.ped = ped;
            this.t = t;
        }
    }
}

