/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr.target;

import bluej.graph.Vertex;
import bluej.pkgmgr.Package;
import bluej.prefmgr.PrefMgr;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.util.Properties;

public abstract class Target
extends Vertex
implements Comparable {
    static final int DEF_WIDTH = 80;
    static final int DEF_HEIGHT = 50;
    static final int ARR_HORIZ_DIST = 5;
    static final int ARR_VERT_DIST = 10;
    static final int HANDLE_SIZE = 20;
    static final int TEXT_HEIGHT = 16;
    static final int TEXT_BORDER = 4;
    static final int SHAD_SIZE = 4;
    public static final int S_NORMAL = 0;
    public static final int S_INVALID = 1;
    public static final int S_COMPILING = 2;
    private String identifierName;
    private String displayName;
    private Package pkg;
    protected boolean disabled;
    protected int state = 1;
    protected boolean selected;
    protected boolean queued;
    static FontRenderContext FRC = new FontRenderContext(new AffineTransform(), false, false);

    public Target(Package pkg, String identifierName) {
        super(0, 0, Target.calculateWidth(identifierName), 50);
        if (pkg == null) {
            throw new NullPointerException();
        }
        this.pkg = pkg;
        this.identifierName = identifierName;
        this.displayName = identifierName;
    }

    protected static int calculateWidth(String name) {
        int width = 0;
        if (name != null) {
            width = (int)PrefMgr.getTargetFont().getStringBounds(name, FRC).getWidth();
        }
        if (width + 20 <= 80) {
            return 80;
        }
        return (width + 29) / 10 * 10;
    }

    public void load(Properties props, String prefix) throws NumberFormatException {
        this.setPos(Integer.parseInt(props.getProperty(prefix + ".x")), Integer.parseInt(props.getProperty(prefix + ".y")));
        this.setSize(Integer.parseInt(props.getProperty(prefix + ".width")), Integer.parseInt(props.getProperty(prefix + ".height")));
    }

    public void save(Properties props, String prefix) {
        props.put(prefix + ".x", String.valueOf(this.getX()));
        props.put(prefix + ".y", String.valueOf(this.getY()));
        props.put(prefix + ".width", String.valueOf(this.getWidth()));
        props.put(prefix + ".height", String.valueOf(this.getHeight()));
        props.put(prefix + ".name", this.getIdentifierName());
    }

    public abstract boolean copyFiles(String var1);

    public Package getPackage() {
        return this.pkg;
    }

    public void setDisplayName(String name) {
        this.displayName = name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getIdentifierName() {
        return this.identifierName;
    }

    public void setIdentifierName(String newName) {
        this.identifierName = newName;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
        this.repaint();
    }

    public boolean isSelected() {
        return this.selected;
    }

    public Rectangle getBoundingBox() {
        return this.getRectangle();
    }

    public void toggleSelected() {
        this.selected = !this.selected;
        this.repaint();
    }

    public boolean isHandle(int x, int y) {
        return x - this.getX() + y - this.getY() >= this.getWidth() + this.getHeight() - 20;
    }

    public boolean isQueued() {
        return this.queued;
    }

    public void setQueued(boolean queued) {
        this.queued = queued;
    }

    public int getState() {
        return this.state;
    }

    public void setState(int newState) {
        this.state = newState;
        this.repaint();
    }

    public boolean isInvalidState() {
        return this.getState() == 1;
    }

    public void setInvalidState() {
        this.setState(1);
    }

    public boolean isResizable() {
        return true;
    }

    public boolean isSaveable() {
        return true;
    }

    public boolean isSelectable() {
        return true;
    }

    public void repaint() {
        if (this.pkg.getEditor() != null) {
            this.pkg.getEditor().repaint();
        }
    }

    public boolean equals(Object o) {
        if (o instanceof Target) {
            Target t = (Target)o;
            return this.identifierName.equals(t.identifierName);
        }
        return false;
    }

    public int hashCode() {
        return this.identifierName.hashCode();
    }

    public int compareTo(Object o) {
        if (this.equals(o)) {
            return 0;
        }
        Target t = (Target)o;
        if (this.getY() < t.getY()) {
            return -1;
        }
        if (this.getY() > t.getY()) {
            return 1;
        }
        if (this.getX() < t.getX()) {
            return -1;
        }
        if (this.getX() > t.getX()) {
            return 1;
        }
        return this.identifierName.compareTo(t.getIdentifierName());
    }

    public String toString() {
        return this.getDisplayName();
    }
}

