/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr.graphPainter;

import bluej.Config;
import bluej.pkgmgr.dependency.Dependency;
import bluej.pkgmgr.dependency.ImplementsDependency;
import bluej.pkgmgr.graphPainter.DependencyPainter;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Stroke;

public class ImplementsDependencyPainter
implements DependencyPainter {
    protected static final float strokeWidthDefault = 1.0f;
    protected static final float strokeWidthSelected = 2.0f;
    static final Color normalColour = Config.getItemColour("colour.arrow.implements");
    static final int ARROW_SIZE = 18;
    static final double ARROW_ANGLE = 0.5235987755982988;
    private static final float[] dash1 = new float[]{5.0f, 2.0f};
    private static final BasicStroke dashedUnselected = new BasicStroke(1.0f, 0, 0, 10.0f, dash1, 0.0f);
    private static final BasicStroke dashedSelected = new BasicStroke(2.0f, 0, 0, 10.0f, dash1, 0.0f);
    private static final BasicStroke normalSelected = new BasicStroke(2.0f);
    private static final BasicStroke normalUnselected = new BasicStroke(1.0f);

    public void paint(Graphics2D g, Dependency dependency, boolean hasFocus) {
        BasicStroke normalStroke;
        BasicStroke dashedStroke;
        boolean isSelected;
        if (!(dependency instanceof ImplementsDependency)) {
            throw new IllegalArgumentException();
        }
        Stroke oldStroke = g.getStroke();
        ImplementsDependency d = (ImplementsDependency)dependency;
        boolean bl = isSelected = d.isSelected() && hasFocus;
        if (isSelected) {
            dashedStroke = dashedSelected;
            normalStroke = normalSelected;
        } else {
            dashedStroke = dashedUnselected;
            normalStroke = normalUnselected;
        }
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(normalColour);
        Point pFrom = new Point(d.getFrom().getX() + d.getFrom().getWidth() / 2, d.getFrom().getY() + d.getFrom().getHeight() / 2);
        Point pTo = new Point(d.getTo().getX() + d.getTo().getWidth() / 2, d.getTo().getY() + d.getTo().getHeight() / 2);
        double angle = Math.atan2(-(pFrom.getY() - pTo.getY()), pFrom.getX() - pTo.getX());
        pFrom = d.getFrom().getAttachment(angle + Math.PI);
        pTo = d.getTo().getAttachment(angle);
        Point pArrow = new Point(pTo.x + (int)(16.0 * Math.cos(angle)), pTo.y - (int)(16.0 * Math.sin(angle)));
        int[] xPoints = new int[]{pTo.x, pTo.x + (int)(18.0 * Math.cos(angle + 0.5235987755982988)), pTo.x + (int)(18.0 * Math.cos(angle - 0.5235987755982988))};
        int[] yPoints = new int[]{pTo.y, pTo.y - (int)(18.0 * Math.sin(angle + 0.5235987755982988)), pTo.y - (int)(18.0 * Math.sin(angle - 0.5235987755982988))};
        g.setStroke(dashedStroke);
        g.drawLine(pFrom.x, pFrom.y, pArrow.x, pArrow.y);
        g.setStroke(normalStroke);
        g.drawPolygon(xPoints, yPoints, 3);
        g.setStroke(oldStroke);
    }

    public Point getPopupMenuPosition(Dependency dependency) {
        if (!(dependency instanceof ImplementsDependency)) {
            throw new IllegalArgumentException("Not a ExtendsDependency");
        }
        Point pFrom = new Point(dependency.getFrom().getX() + dependency.getFrom().getWidth() / 2, dependency.getFrom().getY() + dependency.getFrom().getHeight() / 2);
        Point pTo = new Point(dependency.getTo().getX() + dependency.getTo().getWidth() / 2, dependency.getTo().getY() + dependency.getTo().getHeight() / 2);
        double angle = Math.atan2(-(pFrom.y - pTo.y), pFrom.x - pTo.x);
        pTo = dependency.getTo().getAttachment(angle);
        int[] xPoints = new int[]{pTo.x, pTo.x + (int)(18.0 * Math.cos(angle + 0.5235987755982988)), pTo.x + (int)(18.0 * Math.cos(angle - 0.5235987755982988))};
        int[] yPoints = new int[]{pTo.y, pTo.y - (int)(18.0 * Math.sin(angle + 0.5235987755982988)), pTo.y - (int)(18.0 * Math.sin(angle - 0.5235987755982988))};
        return new Point((xPoints[0] + xPoints[1] + xPoints[2]) / 3, (yPoints[0] + yPoints[1] + yPoints[2]) / 3);
    }
}

