/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr.graphPainter;

import bluej.Config;
import bluej.graph.Edge;
import bluej.graph.Graph;
import bluej.graph.GraphEditor;
import bluej.graph.GraphPainter;
import bluej.graph.Moveable;
import bluej.graph.RubberBand;
import bluej.graph.Vertex;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.dependency.Dependency;
import bluej.pkgmgr.dependency.ExtendsDependency;
import bluej.pkgmgr.dependency.ImplementsDependency;
import bluej.pkgmgr.dependency.UsesDependency;
import bluej.pkgmgr.graphPainter.ClassTargetPainter;
import bluej.pkgmgr.graphPainter.DependencyPainter;
import bluej.pkgmgr.graphPainter.ExtendsDependencyPainter;
import bluej.pkgmgr.graphPainter.ImplementsDependencyPainter;
import bluej.pkgmgr.graphPainter.PackageTargetPainter;
import bluej.pkgmgr.graphPainter.ReadmeTargetPainter;
import bluej.pkgmgr.graphPainter.UsesDependencyPainter;
import bluej.pkgmgr.target.ClassTarget;
import bluej.pkgmgr.target.PackageTarget;
import bluej.pkgmgr.target.ReadmeTarget;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.KeyboardFocusManager;
import java.util.Iterator;

public class GraphPainterStdImpl
implements GraphPainter {
    public static final Color[] shadowColours = new Color[]{new Color(242, 242, 242), new Color(211, 211, 211), new Color(189, 189, 189), new Color(83, 83, 83)};
    static final int TEXT_HEIGHT = Integer.parseInt(Config.getPropString("bluej.target.fontsize")) + 4;
    static final int TEXT_BORDER = 4;
    static final float alpha = 0.5f;
    static AlphaComposite alphaComposite = AlphaComposite.getInstance(3, 0.5f);
    private final ClassTargetPainter classTargetPainter = new ClassTargetPainter();
    private final ReadmeTargetPainter readmePainter = new ReadmeTargetPainter();
    private final PackageTargetPainter packageTargetPainter = new PackageTargetPainter();
    private final ExtendsDependencyPainter extendsDependencyPainter = new ExtendsDependencyPainter();
    private final ImplementsDependencyPainter implementsDependencyPainter = new ImplementsDependencyPainter();
    private final UsesDependencyPainter usesDependencyPainter = new UsesDependencyPainter();
    private static final GraphPainterStdImpl singleton = new GraphPainterStdImpl();
    private GraphEditor graphEditor;

    private GraphPainterStdImpl() {
    }

    public void paint(Graphics2D g, GraphEditor graphEditor) {
        this.graphEditor = graphEditor;
        Graph graph = graphEditor.getGraph();
        this.paintEdges(g, graph);
        this.paintVertices(g, graph);
        this.paintGhosts(g, graph);
        this.paintIntermediateDependency(g, graph);
    }

    private void paintEdges(Graphics2D g, Graph graph) {
        Iterator it = graph.getEdges();
        while (it.hasNext()) {
            Edge edge = (Edge)it.next();
            this.paintEdge(g, edge);
        }
    }

    private void paintVertices(Graphics2D g, Graph graph) {
        Iterator it = graph.getVertices();
        while (it.hasNext()) {
            Vertex vertex = (Vertex)it.next();
            this.paintVertex(g, vertex);
        }
    }

    private void paintGhosts(Graphics2D g, Graph graph) {
        Iterator it = graph.getVertices();
        while (it.hasNext()) {
            Moveable moveable;
            Object vertex = it.next();
            if (!(vertex instanceof Moveable) || !(moveable = (Moveable)vertex).isDragging()) continue;
            this.paintGhostVertex(g, moveable);
        }
    }

    private void paintEdge(Graphics2D g, Edge edge) {
        if (!(edge instanceof Dependency)) {
            throw new IllegalArgumentException("Not a dependency");
        }
        Dependency dependency = (Dependency)edge;
        this.getDependencyPainter(dependency).paint(g, dependency, this.isPermanentFocusOwner());
    }

    public DependencyPainter getDependencyPainter(Edge edge) {
        if (edge instanceof ImplementsDependency) {
            return this.implementsDependencyPainter;
        }
        if (edge instanceof ExtendsDependency) {
            return this.extendsDependencyPainter;
        }
        if (edge instanceof UsesDependency) {
            return this.usesDependencyPainter;
        }
        return null;
    }

    private void paintVertex(Graphics2D g, Vertex vertex) {
        if (vertex instanceof ClassTarget) {
            this.classTargetPainter.paint(g, (ClassTarget)vertex, this.isPermanentFocusOwner());
        } else if (vertex instanceof ReadmeTarget) {
            this.readmePainter.paint(g, (ReadmeTarget)vertex, this.isPermanentFocusOwner());
        } else if (vertex instanceof PackageTarget) {
            this.packageTargetPainter.paint(g, (PackageTarget)vertex, this.isPermanentFocusOwner());
        }
    }

    private void paintGhostVertex(Graphics2D g, Moveable vertex) {
        if (vertex instanceof ClassTarget) {
            this.classTargetPainter.paintGhost(g, (ClassTarget)vertex, this.isPermanentFocusOwner());
        } else if (vertex instanceof PackageTarget) {
            this.packageTargetPainter.paintGhost(g, (PackageTarget)vertex, this.isPermanentFocusOwner());
        }
    }

    private void paintIntermediateDependency(Graphics2D g, Graph graph) {
        RubberBand rb = this.graphEditor.getRubberBand();
        if (rb != null) {
            if (((Package)graph).getState() == 4) {
                this.extendsDependencyPainter.paintIntermediateDependency(g, rb);
            } else if (((Package)graph).getState() == 2) {
                this.usesDependencyPainter.paintIntermedateDependency(g, rb);
            }
        }
    }

    private boolean isPermanentFocusOwner() {
        Component permanentFocusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner();
        return permanentFocusOwner == this.graphEditor;
    }

    public static GraphPainter getInstance() {
        return singleton;
    }
}

