/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr;

import bluej.Config;
import bluej.pkgmgr.Package;
import bluej.utility.Utility;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import java.text.DateFormat;
import java.util.Date;

public class PackagePrinter
extends Thread
implements Printable {
    private PageFormat pageFormat;
    private Package pkg;
    private int pageColumns = 0;
    private int pageRows = 0;
    private int pages;
    private int currentPage;
    private int currentColumn = 0;
    private int currentRow = 0;
    static final int a4Width = 595;
    static final int a4Height = 840;
    static final int PRINT_HMARGIN = 6;
    static final int PRINT_VMARGIN = 24;
    static final Font printTitleFont = new Font("SansSerif", 0, 12);
    static final Font printInfoFont = new Font("SansSerif", 2, 10);

    public PackagePrinter(Package pkg, PageFormat pageFormat) {
        this.pkg = pkg;
        this.pageFormat = pageFormat;
    }

    public void run() {
        this.printPackage();
    }

    private void printPackage() {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        Dimension graphSize = this.pkg.getMinimumSize();
        printerJob.setPrintable(this, this.pageFormat);
        if (printerJob.printDialog()) {
            this.pkg.setStatus(Config.getString("pkgmgr.info.printing"));
            this.calculatePages();
            try {
                printerJob.print();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.pkg.setStatus(Config.getString("pkgmgr.info.printed"));
        }
    }

    private void calculatePages() {
        Dimension pageSize = new Dimension((int)this.pageFormat.getImageableWidth(), (int)this.pageFormat.getImageableHeight());
        Dimension graphSize = this.pkg.getMinimumSize();
        Rectangle printArea = this.getPrintArea(this.pageFormat);
        this.pageColumns = (graphSize.width + printArea.width - 1) / printArea.width;
        this.pageRows = (graphSize.height + printArea.height - 1) / printArea.height;
        this.pages = this.pageColumns * this.pageRows;
        this.currentRow = 0;
        this.currentColumn = 0;
    }

    public int print(Graphics g, PageFormat pageFormat, int pageIndex) {
        if (pageIndex >= this.pages) {
            return 1;
        }
        Rectangle printArea = this.getPrintArea(pageFormat);
        if (this.currentColumn < this.pageColumns) {
            if (this.currentPage < pageIndex) {
                ++this.currentColumn;
            }
        } else if (this.currentRow < this.pageRows) {
            ++this.currentRow;
            this.currentColumn = 0;
        }
        this.printTitle(g, pageFormat, pageIndex + 1);
        g.translate(printArea.x - this.currentColumn * printArea.width, printArea.y - this.currentRow * printArea.height);
        g.setClip(this.currentColumn * printArea.width, this.currentRow * printArea.height, printArea.width, printArea.height);
        this.pkg.getEditor().paint(g);
        this.currentPage = pageIndex;
        return 0;
    }

    private Rectangle getPrintArea(PageFormat pageFormat) {
        return new Rectangle((int)pageFormat.getImageableX() + 6, (int)pageFormat.getImageableY() + 24, (int)pageFormat.getImageableWidth() - 12, (int)pageFormat.getImageableHeight() - 48);
    }

    private void printTitle(Graphics g, PageFormat pageFormat, int pageNum) {
        FontMetrics tfm = g.getFontMetrics(printTitleFont);
        FontMetrics ifm = g.getFontMetrics(printInfoFont);
        Rectangle printArea = new Rectangle((int)pageFormat.getImageableX(), (int)pageFormat.getImageableY(), (int)pageFormat.getImageableWidth(), (int)pageFormat.getImageableHeight());
        g.setColor(Color.lightGray);
        g.fillRect(printArea.x, printArea.y, printArea.width, 24);
        g.setColor(Color.black);
        g.drawRect(printArea.x, printArea.y, printArea.width, 24);
        g.drawRect(printArea.x, printArea.y, printArea.width, printArea.height - 24);
        String title = this.pkg.getQualifiedName();
        g.setFont(printTitleFont);
        Utility.drawCentredText(g, "BlueJ package - " + title, printArea.x, printArea.y, printArea.width, tfm.getHeight());
        g.setFont(printInfoFont);
        DateFormat dateFormat = DateFormat.getDateTimeInstance();
        Utility.drawRightText(g, dateFormat.format(new Date()) + ", Page " + pageNum, printArea.x, printArea.y + printArea.height - 24, printArea.width, ifm.getHeight());
    }
}

