/*
 * Decompiled with CFR 0.152.
 */
package bluej.pkgmgr;

import bluej.BlueJEvent;
import bluej.Config;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.Project;
import bluej.utility.Debug;
import bluej.utility.DialogManager;
import bluej.utility.FileUtility;
import bluej.utility.Utility;
import com.sun.tools.javadoc.Main;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class DocuGenerator {
    private static String docDirName = Config.getPropString("doctool.outputdir");
    private static String projectLogHeader = Config.getPropString("Project documentation");
    private static String classLogHeader = Config.getPropString("Class documentation");
    private static File docTempDir;
    private static String docCommand;
    private static String fixedJavadocParams;
    private static String tmpJavadocParams;
    private Project project;
    private File projectDir;
    private String projectDirPath;
    private File docDir;
    private String docDirPath;

    public void generateClassDocu(String filename) {
        String docDirStatus;
        if (this.docDir == null) {
            BlueJEvent.raiseEvent(8, null);
        }
        if ((docDirStatus = this.testDocDir()) != "") {
            BlueJEvent.raiseEvent(8, null);
        }
        ArrayList<String> call = new ArrayList<String>();
        call.add(docCommand);
        DocuGenerator.addParams(call, fixedJavadocParams);
        String majorVersion = System.getProperty("java.vm.version").substring(0, 3);
        call.add("-source");
        call.add(majorVersion);
        DocuGenerator.addParams(call, tmpJavadocParams);
        call.add("-d");
        call.add(this.docDir.getPath());
        call.add("-classpath");
        File junitFile = new File(Config.getBlueJLibDir(), "junit.jar");
        call.add(junitFile.getAbsolutePath());
        call.add(filename);
        String[] javadocCall = call.toArray(new String[0]);
        File htmlFile = new File(this.getDocuPath(filename));
        File logFile = new File(this.docDir, "logfile.txt");
        DocuGenerator.generateDoc(javadocCall, htmlFile, logFile, classLogHeader, false);
    }

    public String getDocuPath(String filename) {
        if (filename.startsWith(this.projectDirPath)) {
            filename = filename.substring(this.projectDirPath.length());
        }
        if (filename.endsWith(".java")) {
            filename = filename.substring(0, filename.indexOf(".java"));
        }
        return this.docDirPath + filename + ".html";
    }

    private static File getDocTempDir() {
        if (docTempDir == null) {
            try {
                docTempDir = File.createTempFile("bluej", "tmp");
            }
            catch (IOException e) {
                return null;
            }
            docTempDir.delete();
            docTempDir.mkdir();
        } else {
            FileUtility.deleteDir(docTempDir);
            docTempDir.mkdir();
        }
        return docTempDir;
    }

    private static void generateDoc(String[] call, File result, File log, String header, boolean openBrowser) {
        Thread starterThread = new Thread(new DocuRunStarter(call, result, log, header, openBrowser));
        starterThread.setPriority(1);
        starterThread.start();
        BlueJEvent.raiseEvent(6, null);
    }

    public DocuGenerator(Project project) {
        this.project = project;
        this.projectDir = project.getProjectDir();
        this.projectDirPath = this.projectDir.getPath();
        this.docDir = new File(this.projectDir, docDirName);
        this.docDirPath = this.docDir.getPath();
    }

    public String generateProjectDocu() {
        String docDirStatus = this.testDocDir();
        if (docDirStatus != "") {
            return docDirStatus;
        }
        File startPage = new File(this.docDir, "index.html");
        File logFile = new File(this.docDir, "logfile.txt");
        if (DocuGenerator.documentationExists(logFile)) {
            int result = DialogManager.askQuestion(null, "show-or-generate");
            if (result == 0) {
                Utility.openWebBrowser(startPage.getPath());
                return "";
            }
            if (result == 2) {
                return "";
            }
        }
        String linkParam = this.getLinkParam();
        ArrayList<String> call = new ArrayList<String>();
        call.add(docCommand);
        call.add("-sourcepath");
        call.add(this.projectDirPath);
        call.add("-classpath");
        File junitFile = new File(Config.getBlueJLibDir(), "junit.jar");
        call.add(junitFile.getAbsolutePath());
        call.add("-d");
        call.add(this.docDirPath);
        String majorVersion = System.getProperty("java.vm.version").substring(0, 3);
        call.add("-source");
        call.add(majorVersion);
        call.add("-doctitle");
        call.add(this.project.getProjectName());
        call.add("-windowtitle");
        call.add(this.project.getProjectName());
        DocuGenerator.addParams(call, linkParam);
        DocuGenerator.addParams(call, fixedJavadocParams);
        List packageNames = this.project.getPackageNames();
        Iterator names = packageNames.iterator();
        while (names.hasNext()) {
            String packageName = (String)names.next();
            Package pack = this.project.getPackage(packageName);
            if (!FileUtility.containsFile(pack.getPath(), ".java") || packageName.length() <= 0) continue;
            call.add(packageName);
        }
        List classNames = this.project.getPackage("").getAllClassnamesWithSource();
        String dirName = this.project.getProjectDir().getAbsolutePath();
        Iterator names2 = classNames.iterator();
        while (names2.hasNext()) {
            call.add(dirName + "/" + names2.next() + ".java");
        }
        String[] javadocCall = call.toArray(new String[0]);
        DocuGenerator.generateDoc(javadocCall, startPage, logFile, projectLogHeader, true);
        return "";
    }

    private static void addParams(List list, String s) {
        StringTokenizer st = new StringTokenizer(s);
        while (st.hasMoreTokens()) {
            list.add(st.nextToken());
        }
    }

    private String testDocDir() {
        if (this.docDir.exists()) {
            if (!this.docDir.isDirectory()) {
                return DialogManager.getMessage("docdir-blocked-by-file");
            }
        } else {
            try {
                if (!this.docDir.mkdir()) {
                    return DialogManager.getMessage("docdir-not-created");
                }
            }
            catch (SecurityException exc) {
                return DialogManager.getMessage("no-permission-for-docdir");
            }
        }
        return "";
    }

    private static boolean documentationExists(File logFile) {
        if (!logFile.exists()) {
            return false;
        }
        try {
            BufferedReader logReader = new BufferedReader(new FileReader(logFile));
            String header = logReader.readLine();
            return header.equals(projectLogHeader);
        }
        catch (Exception e) {
            return false;
        }
    }

    private String getLinkParam() {
        String linkToLib = Config.getPropString("doctool.linkToStandardLib");
        if (linkToLib.equals("true")) {
            String docURL = Config.getPropString("bluej.url.javaStdLib");
            if (docURL.endsWith("index.html")) {
                docURL = docURL.substring(0, docURL.indexOf("index.html"));
            }
            return " -link " + docURL;
        }
        return "";
    }

    static {
        docCommand = Config.getJDKExecutablePath("doctool.command", "javadoc");
        fixedJavadocParams = Config.getPropString("doctool.options");
        tmpJavadocParams = " -noindex -notree -nohelp -nonavbar";
    }

    private static class DocuRunStarter
    implements Runnable {
        private String[] docuCall;
        private File showFile;
        private File logFile;
        private String logHeader;
        private boolean openBrowser;

        public DocuRunStarter(String[] call, File result, File log, String header, boolean browse) {
            this.docuCall = call;
            this.showFile = result;
            this.logFile = log;
            this.logHeader = header;
            this.openBrowser = browse;
        }

        public void run() {
            try {
                FileOutputStream logStream = new FileOutputStream(this.logFile);
                PrintWriter logWriter = new PrintWriter(logStream, true);
                String[] docuCall2 = new String[this.docuCall.length - 1];
                logWriter.println(this.logHeader);
                logWriter.println("<---- javadoc command: ---->");
                for (int i = 0; i < this.docuCall.length; ++i) {
                    logWriter.println(this.docuCall[i]);
                    if (i == 0) continue;
                    docuCall2[i - 1] = this.docuCall[i];
                }
                logWriter.println("<---- end of javadoc command ---->");
                logWriter.flush();
                int exitValue = Main.execute((String)"javadoc", (PrintWriter)logWriter, (PrintWriter)logWriter, (PrintWriter)logWriter, (String)"com.sun.tools.doclets.standard.Standard", (String[])docuCall2);
                if (exitValue == 0) {
                    BlueJEvent.raiseEvent(7, null);
                    if (!this.showFile.exists()) {
                        Debug.message("showfile does not exist - searching");
                        this.showFile = FileUtility.findFile(this.showFile.getParentFile(), this.showFile.getName());
                    }
                    if (this.openBrowser) {
                        logWriter.println("try to open: " + this.showFile.getPath());
                        Utility.openWebBrowser(this.showFile.getPath());
                    }
                } else {
                    BlueJEvent.raiseEvent(8, null);
                    DialogManager.showMessageWithText(null, "doctool-error", this.logFile.getPath());
                }
            }
            catch (IOException exc) {
                DialogManager.showMessage(null, "severe-doc-trouble");
            }
        }
    }
}

