/*
 * Decompiled with CFR 0.152.
 */
package bluej.parser.symtab;

import bluej.parser.symtab.ClassDef;
import bluej.parser.symtab.ClassInfo;
import bluej.parser.symtab.Definition;
import bluej.parser.symtab.DummyClass;
import bluej.parser.symtab.Occurrence;
import bluej.parser.symtab.ScopedDef;
import bluej.parser.symtab.SymbolTable;
import bluej.parser.symtab.TypedDef;

class VariableDef
extends Definition
implements TypedDef {
    private String comment;
    private Definition type = null;
    private int arrayLevel = 0;
    private boolean isVarargs = false;

    VariableDef(String name, Occurrence occ, ClassDef type, boolean isVarargs, int arrayLevel, ScopedDef parentScope) {
        super(name, occ, parentScope);
        this.type = type;
        this.isVarargs = isVarargs;
        this.arrayLevel = arrayLevel;
    }

    public Definition getType() {
        return this.type;
    }

    public int getArrayLevel() {
        return this.arrayLevel;
    }

    public void getInfo(ClassInfo info, SymbolTable symbolTable) {
        if (this.getParentScope() instanceof ClassDef) {
            info.addComment(this.getName(), this.comment, null);
        }
        info.addUsed(this.type.getQualifiedName());
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    void resolveTypes(SymbolTable symbolTable) {
        Definition newType;
        if (this.type != null && this.type instanceof DummyClass && (newType = symbolTable.lookupDummy(this.type)) != null) {
            newType.addReference(this.type.getOccurrence());
            this.type = newType;
        }
        super.resolveTypes(symbolTable);
    }

    public boolean isVarargs() {
        return this.isVarargs;
    }
}

