/*
 * Decompiled with CFR 0.152.
 */
package bluej.parser.symtab;

import bluej.parser.JavaToken;
import bluej.parser.symtab.Occurrence;
import java.io.File;

public class Selection
extends Occurrence {
    private int len;
    private String origText;

    public Selection(File f, int line, int column) {
        super(f, line, column);
        this.len = 0;
        this.origText = "";
    }

    public Selection(JavaToken tok) {
        super(tok.getFile(), tok.getLine(), tok.getColumn());
        this.len = tok.getText().length();
        this.origText = new String(tok.getText());
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public int getLength() {
        return this.len;
    }

    public String getText() {
        return this.origText;
    }

    public File getFile() {
        return this.file;
    }

    public void addToken(JavaToken token) {
        if (this.line == token.getLine()) {
            StringBuffer buf = new StringBuffer(this.origText);
            int endOfExisting = this.column + this.len;
            int gap = token.getColumn() - endOfExisting;
            if (gap > 0) {
                for (int i = 0; i < gap; ++i) {
                    buf.append(' ');
                }
                buf.append(token.getText());
            } else {
                String text = token.getText();
                buf.replace(token.getColumn() - this.column, token.getColumn() - this.column + text.length(), text);
            }
            this.origText = buf.toString();
            this.len = this.origText.length();
        }
    }

    public String getLocation() {
        return "[" + this.file + ":" + this.line + ":" + this.column + ":" + this.len + "]";
    }

    public String toString() {
        return "Selection " + this.getLocation();
    }
}

