/*
 * Decompiled with CFR 0.152.
 */
package bluej.parser.symtab;

import bluej.parser.JavaToken;
import bluej.parser.symtab.ClassInfo;
import bluej.parser.symtab.Definition;
import bluej.parser.symtab.JavaHashtable;
import bluej.parser.symtab.JavaVector;
import bluej.parser.symtab.MethodDef;
import bluej.parser.symtab.MultiDef;
import bluej.parser.symtab.Occurrence;
import bluej.parser.symtab.SymbolTable;
import java.util.Enumeration;

abstract class ScopedDef
extends Definition {
    private JavaHashtable elements = new JavaHashtable();
    private JavaVector unresolvedStuff;
    private boolean iAmDefaultOrBaseScope = false;

    ScopedDef(String name, Occurrence occ, ScopedDef parentScope) {
        super(name, occ, parentScope);
    }

    void add(Definition def) {
        Definition oldDef = (Definition)this.elements.get(def.getName());
        if (oldDef != null) {
            if (!(oldDef instanceof MultiDef)) {
                this.elements.remove(oldDef);
                MultiDef newMulti = new MultiDef(def.getName(), oldDef);
                newMulti.addDef(oldDef);
                oldDef = newMulti;
                this.elements.put(def.getName(), oldDef);
            }
            ((MultiDef)oldDef).addDef(def);
        } else {
            this.elements.put(def.getName(), def);
            def.setParentScope(this);
        }
    }

    void addUnresolved(JavaToken t) {
        if (this.unresolvedStuff == null) {
            this.unresolvedStuff = new JavaVector();
        }
        this.unresolvedStuff.addElement(t);
    }

    boolean hasElements() {
        return !this.elements.isEmpty();
    }

    boolean isDefaultOrBaseScope() {
        return this.iAmDefaultOrBaseScope;
    }

    Definition lookup(String name, int numParams) {
        Definition d = (Definition)this.elements.get(name);
        if (d instanceof MultiDef) {
            return d.lookup(name, numParams);
        }
        if (d instanceof MethodDef) {
            if (((MethodDef)d).getParamCount() == numParams) {
                return d;
            }
            return null;
        }
        return d;
    }

    void getElementInfo(ClassInfo info, SymbolTable symbolTable) {
        Enumeration e = this.elements.elements();
        while (e.hasMoreElements()) {
            Definition d = (Definition)e.nextElement();
            d.getInfo(info, symbolTable);
        }
    }

    public void getInfo(ClassInfo info, SymbolTable symbolTable) {
        symbolTable.pushScope(this);
        this.getElementInfo(info, symbolTable);
        if (this.unresolvedStuff != null) {
            this.unresolvedStuff.getUnresolvedInfo(info, symbolTable);
        }
        symbolTable.popScope();
    }

    void resolveTypes(SymbolTable symbolTable) {
        symbolTable.pushScope(this);
        this.elements.resolveTypes(symbolTable);
        if (this.unresolvedStuff != null) {
            this.unresolvedStuff.resolveRefs(symbolTable);
            this.unresolvedStuff = null;
        }
        symbolTable.popScope();
        super.resolveTypes(symbolTable);
    }

    void setDefaultOrBaseScope(boolean val) {
        this.iAmDefaultOrBaseScope = val;
    }
}

