/*
 * Decompiled with CFR 0.152.
 */
package bluej.parser.symtab;

import bluej.parser.JavaToken;
import bluej.parser.symtab.ClassDef;
import bluej.parser.symtab.ClassInfo;
import bluej.parser.symtab.Definition;
import bluej.parser.symtab.DummyClass;
import bluej.parser.symtab.IndentingPrintWriter;
import bluej.parser.symtab.Occurrence;
import bluej.parser.symtab.SymbolTable;
import java.util.Enumeration;
import java.util.Vector;

public class JavaVector
extends Vector {
    private boolean resolvingRefs = false;
    private boolean resolvingTypes = false;

    public void addElement(Definition o) {
        super.addElement(o);
        if (o == null) {
            throw new IllegalArgumentException("null element added to vector");
        }
    }

    public Definition getElement(String name) {
        Enumeration e = this.elements();
        while (e.hasMoreElements()) {
            Definition d = (Definition)e.nextElement();
            if (!d.getName().equals(name)) continue;
            return d;
        }
        return null;
    }

    void list(IndentingPrintWriter out) {
        Enumeration e = this.elements();
        while (e.hasMoreElements()) {
            out.println(((Definition)e.nextElement()).getQualifiedName());
        }
    }

    void listIndented(IndentingPrintWriter out, String title) {
        if (title != null) {
            out.println(title);
        }
        out.indent();
        this.list(out);
        out.dedent();
    }

    public void getUnresolvedInfo(ClassInfo info, SymbolTable symbolTable) {
        if (!this.resolvingRefs) {
            this.resolvingRefs = true;
            Enumeration e = this.elements();
            while (e.hasMoreElements()) {
                JavaToken t = (JavaToken)((Object)e.nextElement());
                String name = t.getText();
                int dotPos = name.indexOf(".");
                while (dotPos != -1) {
                    String partName = name.substring(0, dotPos);
                    Definition d = symbolTable.lookup(partName);
                    if (d != null && d instanceof ClassDef) {
                        info.addUsed(d.getQualifiedName());
                    }
                    dotPos = name.indexOf(".", dotPos + 1);
                }
                Definition d = symbolTable.lookup(name);
                if (d == null || !(d instanceof ClassDef)) continue;
                info.addUsed(d.getQualifiedName());
            }
        }
    }

    public void resolveRefs(SymbolTable symbolTable) {
        if (!this.resolvingRefs) {
            this.resolvingRefs = true;
            Enumeration e = this.elements();
            while (e.hasMoreElements()) {
                JavaToken t = (JavaToken)((Object)e.nextElement());
                Definition d = symbolTable.lookup(t.getText(), t.getParamCount());
                if (d == null) {
                    d = symbolTable.findPackage(t.getText());
                }
                if (d == null) continue;
                d.addReference(new Occurrence(t.getFile(), t.getLine(), t.getColumn()));
            }
        }
    }

    public void resolveTypes(SymbolTable symbolTable) {
        if (!this.resolvingTypes) {
            this.resolvingTypes = true;
            Enumeration e = this.elements();
            while (e.hasMoreElements()) {
                Definition d = (Definition)e.nextElement();
                if (d instanceof DummyClass) {
                    String pkg = ((DummyClass)d).getPackage();
                    Definition newD = symbolTable.lookupDummy(d);
                    if (newD == null) continue;
                    newD.addReference(d.getOccurrence());
                    this.removeElement(d);
                    this.addElement(newD);
                    continue;
                }
                d.resolveTypes(symbolTable);
            }
        }
    }
}

