/*
 * Decompiled with CFR 0.152.
 */
package bluej.parser.symtab;

import bluej.parser.symtab.Definition;
import bluej.parser.symtab.DummyClass;
import bluej.parser.symtab.IndentingPrintWriter;
import bluej.parser.symtab.SymbolTable;
import java.util.Enumeration;
import java.util.Hashtable;

class JavaHashtable
extends Hashtable {
    private boolean resolving = false;
    private static final int CLASS = 0;
    private static final int INTERFACE = 1;
    private static final int EITHER = 2;

    JavaHashtable() {
    }

    void list(IndentingPrintWriter out) {
        Enumeration e = this.elements();
        while (e.hasMoreElements()) {
            out.println(((Definition)e.nextElement()).getQualifiedName());
        }
    }

    void listIndented(IndentingPrintWriter out, String title) {
        if (title != null) {
            out.println(title);
        }
        out.indent();
        this.list(out);
        out.dedent();
    }

    void resolveTypes(SymbolTable symbolTable) {
        if (!this.resolving) {
            this.resolving = true;
            Enumeration e = this.elements();
            while (e.hasMoreElements()) {
                Definition d = (Definition)e.nextElement();
                if (d instanceof DummyClass) {
                    String pkg = ((DummyClass)d).getPackage();
                    Definition newD = symbolTable.lookupDummy(d);
                    if (newD == null) continue;
                    newD.addReference(d.getOccurrence());
                    this.remove(d.getName());
                    this.put(d.getName(), newD);
                    continue;
                }
                d.resolveTypes(symbolTable);
            }
        }
    }
}

