/*
 * Decompiled with CFR 0.152.
 */
package bluej.parser.symtab;

import bluej.parser.symtab.ClassInfo;
import bluej.parser.symtab.Definition;
import bluej.parser.symtab.DummyClass;
import bluej.parser.symtab.HasImports;
import bluej.parser.symtab.JavaVector;
import bluej.parser.symtab.Occurrence;
import bluej.parser.symtab.PackageDef;
import bluej.parser.symtab.ScopedDef;
import bluej.parser.symtab.Selection;
import bluej.parser.symtab.SymbolTable;
import java.util.Enumeration;
import java.util.Vector;

class ClassDef
extends HasImports {
    static final int CLASS = 0;
    static final int INTERFACE = 1;
    static final int EITHER = 2;
    private int classOrInterface = 2;
    private boolean isAbstract = false;
    private boolean isPublic = false;
    private boolean isEnum = false;
    private ClassDef superClass;
    private JavaVector subClasses;
    private JavaVector interfaces;
    private JavaVector implementers;
    private String comment;
    private Vector interfaceSelections;
    private Vector typeParameterSelections;
    private Selection extendsInsert;
    private Selection implementsInsert;
    private Selection extendsReplace;
    private Selection superReplace;
    private Selection typeParamInsert;

    ClassDef() {
        super("Object", null, null);
    }

    ClassDef(String name) {
        super(name, null, null);
    }

    ClassDef(String name, boolean isAbstract, boolean isPublic, boolean isEnum, Occurrence occ, ClassDef superClass, JavaVector interfaces, ScopedDef parentScope) {
        super(name, occ, parentScope);
        this.isAbstract = isAbstract;
        this.isPublic = isPublic;
        this.isEnum = isEnum;
        if (superClass != null) {
            this.superClass = superClass;
        }
        this.interfaces = interfaces;
    }

    void addImplementer(ClassDef def) {
        this.getImplementers().addElement(def);
        this.setType(1);
        def.setType(0);
    }

    void addSubclass(ClassDef subclass) {
        this.getSubClasses().addElement(subclass);
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    JavaVector getImplementers() {
        if (this.implementers == null) {
            this.implementers = new JavaVector();
        }
        return this.implementers;
    }

    JavaVector getInterfaces() {
        return this.interfaces;
    }

    JavaVector getSubClasses() {
        if (this.subClasses == null) {
            this.subClasses = new JavaVector();
        }
        return this.subClasses;
    }

    ClassDef getSuperClass() {
        return this.superClass;
    }

    boolean isClass() {
        return this.classOrInterface == 0;
    }

    boolean isInterface() {
        return this.classOrInterface == 1;
    }

    boolean isEnum() {
        return this.isEnum;
    }

    void setExtendsInsert(Selection extendsInsert) {
        this.extendsInsert = extendsInsert;
    }

    void setImplementsInsert(Selection implementsInsert) {
        this.implementsInsert = implementsInsert;
    }

    void setTypeParamInsert(Selection typeParamInsert) {
        this.typeParamInsert = typeParamInsert;
    }

    void setExtendsReplace(Selection extendsReplace) {
        this.extendsReplace = extendsReplace;
    }

    void setSuperReplace(Selection superReplace) {
        this.superReplace = superReplace;
    }

    void setInterfaceSelections(Vector interfaceSelections) {
        this.interfaceSelections = interfaceSelections;
    }

    void setTypeParameterSelections(Vector typeParamSelections) {
        this.typeParameterSelections = typeParamSelections;
    }

    Definition lookup(String name, int numParams) {
        Definition d = super.lookup(name, numParams);
        if (d == null && this.getSuperClass() != null) {
            this.setType(0);
            this.getSuperClass().setType(0);
            d = this.getSuperClass().lookup(name, numParams);
        }
        if (d == null && this.interfaces != null) {
            Enumeration e = this.interfaces.elements();
            while (d == null && e.hasMoreElements()) {
                d = ((ClassDef)e.nextElement()).lookup(name, numParams);
            }
        }
        return d;
    }

    public void getInfo(ClassInfo info, SymbolTable symbolTable) {
        if (this.getParentScope() instanceof PackageDef) {
            StringBuffer target = new StringBuffer();
            if (this.isPublic && !info.foundPublicClass() || !info.foundClass()) {
                info.setName(this.getName(), this.isPublic);
                if (this.getSuperClass() != null) {
                    info.setSuperclass(this.getSuperClass().getQualifiedName());
                }
                if (this.isInterface()) {
                    info.setInterface(true);
                    target.append("interface ");
                } else if (this.isEnum()) {
                    info.setEnum(true);
                } else {
                    target.append("class ");
                }
                target.append(this.getName());
                if (this.isAbstract) {
                    info.setAbstract(true);
                }
                if (this.interfaces != null) {
                    Enumeration e = this.interfaces.elements();
                    while (e.hasMoreElements()) {
                        info.addImplements(((ClassDef)e.nextElement()).getName());
                    }
                }
                info.addComment(target.toString(), this.comment, null);
                info.setExtendsInsertSelection(this.extendsInsert);
                info.setImplementsInsertSelection(this.implementsInsert);
                info.setExtendsReplaceSelection(this.extendsReplace);
                info.setSuperReplaceSelection(this.superReplace);
                if (this.typeParamInsert != null) {
                    info.setTypeParameterText(this.typeParamInsert);
                }
                if (this.typeParameterSelections != null) {
                    info.setTypeParameterSelections(this.typeParameterSelections);
                }
                info.setInterfaceSelections(this.interfaceSelections);
            }
        }
        this.getImportInfo(info);
        this.getElementInfo(info, symbolTable);
    }

    void resolveTypes(SymbolTable symbolTable) {
        ClassDef newSuperClass;
        super.resolveTypes(symbolTable);
        if (this.subClasses != null) {
            this.subClasses.resolveTypes(symbolTable);
        }
        if ((newSuperClass = this.getSuperClass()) != null && newSuperClass instanceof DummyClass) {
            String pkg = ((DummyClass)newSuperClass).getPackage();
            if ((newSuperClass = (ClassDef)symbolTable.lookupDummy(newSuperClass)) == null) {
                newSuperClass = new DummyClass(symbolTable.getUniqueName(this.getSuperClass().getName()), null, symbolTable.getUniqueName(pkg));
            }
            if (newSuperClass != null) {
                newSuperClass.addReference(this.getSuperClass().getOccurrence());
                this.setSuperClass(newSuperClass);
                newSuperClass.addSubclass(this);
                newSuperClass.setType(0);
            }
            this.setType(0);
        }
        if (this.interfaces != null) {
            this.interfaces.resolveTypes(symbolTable);
            Enumeration e = this.interfaces.elements();
            while (e.hasMoreElements()) {
                ((ClassDef)e.nextElement()).addImplementer(this);
            }
        }
        if (this.isTopLevel()) {
            this.closeImports(symbolTable);
        }
    }

    void setInterfaces(JavaVector interfaces) {
        this.interfaces = interfaces;
    }

    void setSuperClass(ClassDef superClass) {
        this.superClass = superClass;
        this.setType(0);
        superClass.setType(0);
    }

    void setType(int type) {
        this.classOrInterface = type;
    }
}

