/*
 * Decompiled with CFR 0.152.
 */
package bluej.graph;

import bluej.graph.Edge;
import bluej.graph.GraphElement;
import bluej.graph.Moveable;
import bluej.graph.SelectableGraphElement;
import bluej.graph.Vertex;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.SwingUtilities;

public final class SelectionSet {
    private Set elements = new HashSet();

    public void add(SelectableGraphElement element) {
        if (!element.isSelected()) {
            element.setSelected(true);
            this.elements.add(element);
        }
    }

    public void addAll(SelectionSet newSet) {
        this.elements.addAll(newSet.elements);
    }

    public void remove(SelectableGraphElement element) {
        if (element != null) {
            element.setSelected(false);
        }
        this.elements.remove(element);
    }

    public void clear() {
        Iterator i = this.elements.iterator();
        while (i.hasNext()) {
            SelectableGraphElement element = (SelectableGraphElement)i.next();
            element.setSelected(false);
        }
        this.elements.clear();
    }

    public void doubleClick(MouseEvent evt) {
        final MouseEvent event = evt;
        Iterator i = this.elements.iterator();
        while (i.hasNext()) {
            final GraphElement element = (GraphElement)i.next();
            Runnable sendClick = new Runnable(){

                public void run() {
                    element.doubleClick(event);
                }
            };
            SwingUtilities.invokeLater(sendClick);
        }
    }

    public void move(int deltaX, int deltaY) {
        Iterator i = this.elements.iterator();
        while (i.hasNext()) {
            Moveable target;
            GraphElement element = (GraphElement)i.next();
            if (!(element instanceof Moveable) || !(target = (Moveable)((Object)element)).isMoveable()) continue;
            target.setDragging(true);
            Point delta = this.restrictDelta(deltaX, deltaY);
            target.setGhostPosition(delta.x, delta.y);
        }
    }

    private Point restrictDelta(int deltaX, int deltaY) {
        Iterator i = this.elements.iterator();
        while (i.hasNext()) {
            GraphElement element = (GraphElement)i.next();
            if (!(element instanceof Moveable)) continue;
            Moveable target = (Moveable)((Object)element);
            if (target.getX() + deltaX < 0) {
                deltaX = -target.getX();
            }
            if (target.getY() + deltaY >= 0) continue;
            deltaY = -target.getY();
        }
        return new Point(deltaX, deltaY);
    }

    public void moveStopped() {
        Iterator i = this.elements.iterator();
        while (i.hasNext()) {
            GraphElement element = (GraphElement)i.next();
            if (!(element instanceof Moveable)) continue;
            Moveable moveable = (Moveable)((Object)element);
            moveable.setPositionToGhost();
        }
    }

    public void resize(int deltaX, int deltaY) {
        Iterator i = this.elements.iterator();
        while (i.hasNext()) {
            Moveable target;
            GraphElement element = (GraphElement)i.next();
            if (!(element instanceof Moveable) || !(target = (Moveable)((Object)element)).isResizable()) continue;
            target.setDragging(true);
            target.setGhostSize(deltaX, deltaY);
        }
    }

    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    public boolean isSingle() {
        return this.elements.size() == 1;
    }

    public void selectOnly(SelectableGraphElement element) {
        this.clear();
        this.add(element);
    }

    public Vertex getAnyVertex() {
        Iterator i = this.elements.iterator();
        while (i.hasNext()) {
            GraphElement element = (GraphElement)i.next();
            if (!(element instanceof Vertex)) continue;
            return (Vertex)element;
        }
        return null;
    }

    public Edge getAnyEdge() {
        Iterator i = this.elements.iterator();
        while (i.hasNext()) {
            GraphElement element = (GraphElement)i.next();
            if (!(element instanceof Edge)) continue;
            return (Edge)element;
        }
        return null;
    }

    public SelectableGraphElement getSingleElement(boolean forceSingle) {
        if (this.elements.isEmpty()) {
            return null;
        }
        if (this.isSingle()) {
            return (SelectableGraphElement)this.elements.iterator().next();
        }
        if (forceSingle) {
            SelectableGraphElement tmp = (SelectableGraphElement)this.elements.iterator().next();
            this.selectOnly(tmp);
            return tmp;
        }
        return null;
    }

    public Iterator iterator() {
        return this.elements.iterator();
    }

    public int getSize() {
        return this.elements.size();
    }
}

