/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugmgr.texteval;

import bluej.Config;
import bluej.editor.moe.BlueJSyntaxView;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.text.Element;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;
import org.gjt.sp.jedit.syntax.SyntaxDocument;
import org.gjt.sp.jedit.syntax.TokenMarker;

public class TextEvalSyntaxView
extends BlueJSyntaxView {
    public static final String OUTPUT = "output";
    public static final String ERROR = "error";
    public static final String CONTINUE = "continue";
    public static final String OBJECT = "object-ref";
    static final Image promptImage = Config.getImageAsIcon("image.eval.prompt").getImage();
    static final Image continueImage = Config.getImageAsIcon("image.eval.continue").getImage();
    static final Image objectImage = Config.getImageAsIcon("image.eval.object").getImage();
    static final Color outputColor = new Color(0, 120, 0);
    static final Color errorColor = new Color(200, 0, 20);

    public TextEvalSyntaxView(Element elem) {
        super(elem);
    }

    public void paintTaggedLine(Segment lineText, int lineIndex, Graphics g, int x, int y, SyntaxDocument document, TokenMarker tokenMarker, Color def, Element line) {
        if (this.hasTag(line, OUTPUT)) {
            g.setColor(outputColor);
            Utilities.drawTabbedText(lineText, x + 16, y, g, (TabExpander)((Object)this), 0);
        } else if (this.hasTag(line, ERROR)) {
            g.setColor(errorColor);
            Utilities.drawTabbedText(lineText, x + 16, y, g, (TabExpander)((Object)this), 0);
        } else if (this.hasObject(line, OBJECT)) {
            g.drawImage(objectImage, x - 1, y + 3 - objectImage.getHeight(null), null);
            g.setColor(outputColor);
            Utilities.drawTabbedText(lineText, x + 16, y, g, (TabExpander)((Object)this), 0);
        } else if (this.hasTag(line, CONTINUE)) {
            g.drawImage(continueImage, x - 1, y + 3 - continueImage.getHeight(null), null);
            this.paintSyntaxLine(lineText, lineIndex, x + 16, y, g, document, tokenMarker, def);
        } else {
            g.drawImage(promptImage, x - 1, y + 3 - promptImage.getHeight(null), null);
            this.paintSyntaxLine(lineText, lineIndex, x + 16, y, g, document, tokenMarker, def);
        }
    }

    protected final boolean hasObject(Element line, String tag) {
        return line.getAttributes().getAttribute(tag) != null;
    }

    public void paint(Graphics g, Shape allocation) {
        Rectangle bounds = allocation.getBounds();
        super.paint(g, allocation);
        g.setColor(Color.lightGray);
        g.drawLine(bounds.x + 14, 0, bounds.x + 14, bounds.y + bounds.height);
    }
}

