/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugmgr.inspector;

import bluej.BlueJTheme;
import bluej.Config;
import bluej.debugger.DebuggerObject;
import bluej.debugger.gentype.GenType;
import bluej.debugger.gentype.GenTypeClass;
import bluej.debugger.gentype.GenTypeParameterizable;
import bluej.debugmgr.ExpressionInformation;
import bluej.debugmgr.inspector.AssertPanel;
import bluej.debugmgr.inspector.ClassInspector;
import bluej.debugmgr.inspector.Inspector;
import bluej.debugmgr.inspector.InspectorEvent;
import bluej.debugmgr.inspector.InspectorListener;
import bluej.pkgmgr.Package;
import bluej.testmgr.record.InvokerRecord;
import bluej.utility.DialogManager;
import bluej.utility.JavaNames;
import bluej.utility.JavaUtils;
import bluej.utility.MultiLineLabel;
import bluej.views.Comment;
import bluej.views.LabelPrintWriter;
import bluej.views.MethodView;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Insets;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;

public class ResultInspector
extends Inspector
implements InspectorListener {
    protected static final String resultTitle = Config.getString("debugger.inspector.result.title");
    protected static final String returnedString = Config.getString("debugger.inspector.result.returned");
    protected DebuggerObject obj;
    protected String objName;
    private ExpressionInformation expressionInformation;
    private GenType resultType;

    public static ResultInspector getInstance(DebuggerObject obj, String name, Package pkg, InvokerRecord ir, ExpressionInformation info, JFrame parent) {
        ResultInspector inspector = (ResultInspector)inspectors.get(obj);
        if (inspector == null) {
            inspector = new ResultInspector(obj, name, pkg, ir, info, parent);
            inspectors.put(obj, inspector);
        }
        final ResultInspector insp = inspector;
        insp.update();
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                insp.setVisible(true);
                insp.bringToFront();
            }
        });
        return inspector;
    }

    private ResultInspector(DebuggerObject obj, String name, Package pkg, InvokerRecord ir, ExpressionInformation info, final JFrame parent) {
        super(pkg, ir);
        this.expressionInformation = info;
        this.obj = obj;
        this.objName = name;
        this.calcResultType();
        final ResultInspector thisInspector = this;
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                ResultInspector.this.makeFrame();
                ResultInspector.this.pack();
                DialogManager.centreWindow(thisInspector, parent);
            }
        });
    }

    private void calcResultType() {
        GenTypeClass instanceType = this.expressionInformation.getInstanceType();
        MethodView methodView = (MethodView)this.expressionInformation.getMethodView();
        Method m = methodView.getMethod();
        if (instanceType != null && instanceType.isRaw()) {
            this.resultType = JavaUtils.getJavaUtils().getRawReturnType(m);
            return;
        }
        GenType methodReturnType = JavaUtils.getJavaUtils().getReturnType(m);
        if (methodReturnType instanceof GenTypeParameterizable) {
            List tpars = JavaUtils.getJavaUtils().getTypeParams(m);
            Map tparmap = JavaUtils.TParamsToMap(tpars);
            methodReturnType = ((GenTypeParameterizable)methodReturnType).mapTparsToTypes(tparmap);
            if (instanceType != null && (tparmap = instanceType.mapToSuper(m.getDeclaringClass().getName())) != null) {
                methodReturnType = ((GenTypeParameterizable)methodReturnType).mapTparsToTypes(tparmap);
            }
        }
        this.resultType = methodReturnType;
    }

    protected Object[] getListData() {
        DebuggerObject resultObject;
        String fieldString = !this.resultType.isPrimitive() ? (!(resultObject = this.obj.getFieldObject(0, this.resultType)).isNullObject() ? resultObject.getGenType().toString(true) : this.resultType.toString(true)) : JavaNames.stripPrefix(this.obj.getFieldValueTypeString(0));
        fieldString = fieldString + " = " + this.obj.getFieldValueString(0);
        return new Object[]{fieldString};
    }

    protected void makeFrame() {
        this.setTitle(resultTitle);
        this.setBorder(BlueJTheme.dialogBorder);
        JPanel header = new JPanel();
        header.setLayout(new BoxLayout(header, 1));
        Comment comment = this.expressionInformation.getComment();
        LabelPrintWriter commentLabelPrintWriter = new LabelPrintWriter();
        comment.print(commentLabelPrintWriter);
        MultiLineLabel commentLabel = commentLabelPrintWriter.getLabel();
        commentLabel.setForeground(Color.GRAY);
        header.add(commentLabel);
        JLabel sig = new JLabel(this.expressionInformation.getSignature());
        sig.setForeground(Color.GRAY);
        header.add(sig);
        header.add(Box.createVerticalStrut(5));
        header.add(new JSeparator());
        JPanel mainPanel = new JPanel(new BorderLayout(10, 10));
        mainPanel.setOpaque(false);
        Box result = Box.createVerticalBox();
        JLabel expression = new JLabel(this.expressionInformation.getExpression(), 2);
        expression.setAlignmentX(0.0f);
        result.add(expression);
        result.add(Box.createVerticalStrut(5));
        JLabel returnedLabel = new JLabel("  " + returnedString, 10);
        returnedLabel.setAlignmentX(0.0f);
        result.add(returnedLabel);
        result.add(Box.createVerticalStrut(5));
        JScrollPane scrollPane = this.createFieldListScrollPane();
        scrollPane.setAlignmentX(0.0f);
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        result.add(scrollPane);
        result.add(Box.createVerticalStrut(5));
        mainPanel.add((Component)result, "Center");
        JPanel inspectAndGetButtons = this.createInspectAndGetButtons();
        mainPanel.add((Component)inspectAndGetButtons, "East");
        Insets insets = BlueJTheme.generalBorderWithStatusBar.getBorderInsets(mainPanel);
        mainPanel.setBorder(new EmptyBorder(insets));
        JPanel bottomPanel = new JPanel();
        bottomPanel.setOpaque(false);
        bottomPanel.setLayout(new BoxLayout(bottomPanel, 1));
        bottomPanel.setBorder(BorderFactory.createEmptyBorder(10, 5, 5, 5));
        if (this.pkg.getProject().inTestMode()) {
            this.assertPanel = new AssertPanel();
            this.assertPanel.setAlignmentX(0.0f);
            bottomPanel.add(this.assertPanel);
        }
        JPanel buttonPanel = new JPanel(new BorderLayout());
        buttonPanel.setOpaque(false);
        JButton button = this.createCloseButton();
        buttonPanel.add((Component)button, "East");
        bottomPanel.add(buttonPanel);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)header, "North");
        contentPane.add((Component)mainPanel, "Center");
        contentPane.add((Component)bottomPanel, "South");
        this.getRootPane().setDefaultButton(button);
    }

    protected void listElementSelected(int slot) {
        if (this.obj.instanceFieldIsObject(slot)) {
            String newInspectedName = this.objName != null ? this.objName + "." + this.obj.getInstanceFieldName(slot) : this.obj.getInstanceFieldName(slot);
            this.setCurrentObj(this.obj.getInstanceFieldObject(slot, this.resultType), newInspectedName);
            if (this.obj.instanceFieldIsPublic(slot)) {
                this.setButtonsEnabled(true, true);
            } else {
                this.setButtonsEnabled(true, false);
            }
        } else {
            this.setCurrentObj(null, null);
            this.setButtonsEnabled(false, false);
        }
    }

    protected void showClass() {
        ClassInspector.getInstance(this.obj.getClassRef(), this.pkg, this);
    }

    protected void prepareInspection() {
    }

    protected void remove() {
        inspectors.remove(this.obj);
    }

    public String getResult() {
        return (String)this.obj.getInstanceFields(false).get(0);
    }

    public void inspectEvent(InspectorEvent e) {
        ResultInspector.getInstance(e.getDebuggerObject(), null, this.pkg, null, null, this);
    }

    protected int getPreferredRows() {
        return 2;
    }
}

