/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugmgr.inspector;

import bluej.BlueJTheme;
import bluej.Config;
import bluej.debugger.DebuggerObject;
import bluej.debugmgr.inspector.AssertPanel;
import bluej.debugmgr.inspector.FieldList;
import bluej.debugmgr.inspector.InspectorEvent;
import bluej.debugmgr.inspector.ObjectInspector;
import bluej.pkgmgr.Package;
import bluej.testmgr.record.InvokerRecord;
import bluej.testmgr.record.ObjectInspectInvokerRecord;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public abstract class Inspector
extends JFrame
implements ListSelectionListener {
    protected static HashMap inspectors = new HashMap();
    protected static final String showClassLabel = Config.getString("debugger.inspector.showClass");
    protected static final String inspectLabel = Config.getString("debugger.inspector.inspect");
    protected static final String getLabel = Config.getString("debugger.inspector.get");
    protected static final String close = Config.getString("close");
    protected FieldList fieldList = null;
    protected JButton inspectButton;
    protected JButton getButton;
    protected AssertPanel assertPanel;
    protected DebuggerObject selectedObject;
    protected String selectedObjectName;
    protected InvokerRecord selectedInvokerRecord;
    protected Package pkg;
    protected InvokerRecord ir;
    private static final int MAX_DESCRIPTION_LENGTH = 30;
    private static final int LIST_WIDTH = 200;

    public static void updateInspectors() {
        Iterator it = inspectors.values().iterator();
        while (it.hasNext()) {
            Inspector inspector = (Inspector)it.next();
            inspector.update();
        }
    }

    public static void removeInstance(Object key) {
        Inspector insp = (Inspector)inspectors.get(key);
        if (insp != null) {
            insp.doClose();
        }
    }

    protected Inspector(Package pkg, InvokerRecord ir) {
        this.setIconImage(BlueJTheme.getIconImage());
        this.pkg = pkg;
        this.ir = ir;
        if (pkg == null && ir != null) {
            throw new IllegalArgumentException("Get button cannot be enabled when pkg==null");
        }
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent E) {
                Inspector.this.doClose();
            }
        });
        this.initFieldList();
    }

    private void initFieldList() {
        this.fieldList = new FieldList(this.getMaxDescriptionLength());
        this.fieldList.setBackground(this.getBackground());
        this.fieldList.setOpaque(true);
        this.fieldList.setSelectionBackground(Config.getSelectionColour());
        this.fieldList.getSelectionModel().addListSelectionListener(this);
        MouseAdapter mouseListener = new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    Inspector.this.doInspect();
                }
            }
        };
        this.fieldList.addMouseListener(mouseListener);
        this.fieldList.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10 || e.getKeyCode() == 27) {
                    Inspector.this.doClose();
                }
            }

            public void keyTyped(KeyEvent e) {
            }
        });
    }

    protected boolean isGetEnabled() {
        return this.ir != null;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.fieldList.requestFocus();
        }
    }

    public void getEvent(InspectorEvent e) {
    }

    public void bringToFront() {
        this.setState(0);
        this.toFront();
    }

    protected abstract Object[] getListData();

    protected abstract void listElementSelected(int var1);

    protected abstract void showClass();

    protected abstract void prepareInspection();

    protected abstract void remove();

    protected abstract int getPreferredRows();

    public void update() {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                int width;
                Object[] listData = Inspector.this.getListData();
                Inspector.this.fieldList.setData(listData);
                Inspector.this.fieldList.setTableHeader(null);
                if (Inspector.this.fieldList.getSelectedRow() == -1 && listData.length > 0) {
                    Inspector.this.fieldList.setRowSelectionInterval(0, 0);
                }
                double height = Inspector.this.fieldList.getPreferredSize().getHeight();
                int rows = listData.length;
                if (rows > Inspector.this.getPreferredRows()) {
                    height = Inspector.this.fieldList.getRowHeight() * Inspector.this.getPreferredRows();
                }
                if ((width = (int)Inspector.this.fieldList.getPreferredSize().getWidth()) < 200) {
                    width = 200;
                }
                Inspector.this.fieldList.setPreferredScrollableViewportSize(new Dimension(width, (int)height));
                Inspector.this.pack();
                if (Inspector.this.assertPanel != null) {
                    Inspector.this.assertPanel.updateWithResultData((String)listData[0]);
                }
                Inspector.this.repaint();
            }
        });
    }

    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        int slot = this.fieldList.getSelectedRow();
        if (slot == -1) {
            return;
        }
        this.listElementSelected(slot);
    }

    protected void setCurrentObj(DebuggerObject object, String name) {
        this.selectedObject = object;
        this.selectedObjectName = name;
    }

    protected void setButtonsEnabled(boolean inspect, boolean get) {
        this.inspectButton.setEnabled(inspect);
        if (this.isGetEnabled()) {
            this.getButton.setEnabled(get);
        }
    }

    protected void doInspect() {
        this.prepareInspection();
        if (this.selectedObject != null) {
            boolean isPublic = this.getButton.isEnabled();
            ObjectInspectInvokerRecord newIr = new ObjectInspectInvokerRecord("Math", this.selectedObjectName, this.ir);
            ObjectInspector.getInstance(this.selectedObject, this.selectedObjectName, this.pkg, isPublic ? newIr : null, this);
        }
    }

    private void doGet() {
        if (this.selectedObject != null) {
            this.pkg.getEditor().raisePutOnBenchEvent(this, this.selectedObject, this.ir);
        }
    }

    private void doClose() {
        this.handleAssertions();
        this.setVisible(false);
        this.remove();
        this.dispose();
    }

    protected void handleAssertions() {
        if (this.assertPanel != null && this.assertPanel.isAssertEnabled()) {
            this.ir.addAssertion(this.assertPanel.getAssertStatement());
        }
    }

    public void setBorder(Border border) {
        ((JPanel)this.getContentPane()).setBorder(border);
    }

    public int getMaxDescriptionLength() {
        return 30;
    }

    public int getListWidth() {
        return 200;
    }

    protected JButton createCloseButton() {
        JButton button = new JButton(close);
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Inspector.this.doClose();
            }
        });
        return button;
    }

    protected JPanel createInspectAndGetButtons() {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setOpaque(false);
        buttonPanel.setLayout(new GridLayout(0, 1));
        buttonPanel.setOpaque(false);
        this.inspectButton = new JButton(inspectLabel);
        this.inspectButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Inspector.this.doInspect();
            }
        });
        this.inspectButton.setEnabled(false);
        buttonPanel.add(this.inspectButton);
        this.getButton = new JButton(getLabel);
        this.getButton.setEnabled(false);
        this.getButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Inspector.this.doGet();
            }
        });
        buttonPanel.add(this.getButton);
        JPanel buttonFramePanel = new JPanel();
        buttonFramePanel.setOpaque(false);
        buttonFramePanel.setLayout(new BorderLayout(0, 0));
        buttonFramePanel.add((Component)buttonPanel, "North");
        return buttonFramePanel;
    }

    protected JScrollPane createFieldListScrollPane() {
        JScrollPane scrollPane = new JScrollPane(this.fieldList);
        scrollPane.setBorder(BlueJTheme.generalBorder);
        scrollPane.setOpaque(false);
        scrollPane.getViewport().setOpaque(false);
        this.fieldList.setPreferredScrollableViewportSize(new Dimension(this.getListWidth(), 25));
        return scrollPane;
    }
}

