/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugmgr;

import bluej.BlueJTheme;
import bluej.debugmgr.CallDialogWatcher;
import bluej.debugmgr.objectbench.ObjectBench;
import bluej.debugmgr.objectbench.ObjectBenchEvent;
import bluej.debugmgr.objectbench.ObjectBenchListener;
import bluej.debugmgr.objectbench.ObjectWrapper;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.utility.DialogManager;
import bluej.utility.MultiLineLabel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;

public abstract class CallDialog
extends JDialog
implements ObjectBenchListener {
    static final int OK = 0;
    static final int CANCEL = 1;
    private MultiLineLabel errorLabel;
    private ObjectBench bench;
    private CallDialogWatcher watcher;

    public CallDialog(PkgMgrFrame pmf, String title) {
        super(pmf, title, false);
        this.bench = pmf.getObjectBench();
    }

    public abstract void doOk();

    public abstract void doCancel();

    public void setWatcher(CallDialogWatcher w) {
        this.watcher = w;
    }

    public void callWatcher(int event) {
        if (this.watcher != null) {
            this.watcher.callDialogEvent(this, event);
        }
    }

    public void setWaitCursor(boolean wait) {
        if (wait) {
            this.setCursor(Cursor.getPredefinedCursor(3));
        } else {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    protected MultiLineLabel getErrorLabel() {
        if (this.errorLabel == null) {
            this.errorLabel = new MultiLineLabel("\n\n", 0.0f);
            this.errorLabel.setForeground(new Color(136, 56, 56));
        }
        return this.errorLabel;
    }

    protected ObjectBench getObjectBench() {
        return this.bench;
    }

    protected void startObjectBenchListening() {
        this.bench.addObjectBenchListener(this);
    }

    protected void stopObjectBenchListening() {
        this.bench.removeObjectBenchListener(this);
    }

    public void setErrorMessage(String message) {
        int index = message.indexOf("location:");
        if (index != -1) {
            message = message.substring(0, index - 1);
        }
        this.errorLabel.setText(message);
        this.pack();
        this.invalidate();
        this.validate();
    }

    public abstract void insertText(String var1);

    public void objectEvent(ObjectBenchEvent obe) {
        ObjectWrapper wrapper = obe.getWrapper();
        this.insertText(wrapper.getName());
    }

    protected void makeDialog(JComponent topComponent, JComponent centerComponent) {
        JPanel contentPane = (JPanel)this.getContentPane();
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(2));
        JButton okButton = BlueJTheme.getOkButton();
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CallDialog.this.doOk();
            }
        });
        buttonPanel.add(okButton);
        JButton cancelButton = BlueJTheme.getCancelButton();
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CallDialog.this.doCancel();
            }
        });
        buttonPanel.add(cancelButton);
        this.getRootPane().setDefaultButton(okButton);
        contentPane.setLayout(new BorderLayout(6, 6));
        contentPane.setBorder(BlueJTheme.generalBorder);
        if (topComponent != null) {
            contentPane.add((Component)topComponent, "North");
        }
        if (centerComponent != null) {
            contentPane.add((Component)centerComponent, "Center");
        }
        contentPane.add((Component)buttonPanel, "South");
        this.pack();
        DialogManager.centreDialog(this);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent event) {
                CallDialog.this.setVisible(false);
            }
        });
    }
}

