/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugger.jdi;

import bluej.debugger.DebuggerClass;
import bluej.debugger.DebuggerObject;
import bluej.debugger.gentype.GenTypeClass;
import bluej.debugger.jdi.JdiObject;
import bluej.debugger.jdi.JdiReflective;
import bluej.debugger.jdi.JdiUtils;
import bluej.utility.Debug;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.List;

public class JdiClass
extends DebuggerClass {
    ReferenceType remoteClass;
    List staticFields;

    public JdiClass(ReferenceType remoteClass) {
        this.remoteClass = remoteClass;
        this.getRemoteFields();
    }

    public String getName() {
        return this.remoteClass.name();
    }

    public int getStaticFieldCount() {
        return this.staticFields.size();
    }

    public String getStaticFieldName(int slot) {
        return ((Field)this.staticFields.get(slot)).name();
    }

    public DebuggerObject getStaticFieldObject(int slot) {
        Field field = (Field)this.staticFields.get(slot);
        ObjectReference val = (ObjectReference)this.remoteClass.getValue(field);
        GenTypeClass expectedType = (GenTypeClass)JdiReflective.fromField(field, this.remoteClass);
        return JdiObject.getDebuggerObject(val, expectedType);
    }

    public List getStaticFields(boolean includeModifiers) {
        return this.getFields(includeModifiers);
    }

    public boolean staticFieldIsPublic(int slot) {
        return ((Field)this.staticFields.get(slot)).isPublic();
    }

    public boolean staticFieldIsObject(int slot) {
        Field field = (Field)this.staticFields.get(slot);
        Value val = this.remoteClass.getValue(field);
        return val instanceof ObjectReference;
    }

    public boolean isInterface() {
        return this.remoteClass instanceof InterfaceType;
    }

    public boolean isEnum() {
        if (this.remoteClass instanceof ClassType) {
            return JdiUtils.getJdiUtils().isEnum((ClassType)this.remoteClass);
        }
        return false;
    }

    private List getFields(boolean includeModifiers) {
        ArrayList<String> fieldStrings = new ArrayList<String>(this.staticFields.size());
        List<Field> visible = this.remoteClass.visibleFields();
        for (int i = 0; i < this.staticFields.size(); ++i) {
            Field field = (Field)this.staticFields.get(i);
            Value val = this.remoteClass.getValue(field);
            String valString = JdiUtils.getJdiUtils().getValueString(val);
            String fieldString = "";
            if (includeModifiers) {
                if (field.isPrivate()) {
                    fieldString = "private ";
                }
                if (field.isProtected()) {
                    fieldString = "protected ";
                }
                if (field.isPublic()) {
                    fieldString = "public ";
                }
            }
            fieldString = fieldString + JdiReflective.fromField(field, this.remoteClass).toString(true) + " " + field.name() + " = " + valString;
            if (!visible.contains(field)) {
                fieldString = fieldString + " (hidden)";
            }
            fieldStrings.add(fieldString);
        }
        return fieldStrings;
    }

    private void getRemoteFields() {
        this.staticFields = new ArrayList();
        if (this.remoteClass != null) {
            List<Field> allFields = this.remoteClass.allFields();
            for (int i = 0; i < allFields.size(); ++i) {
                Field field = allFields.get(i);
                if (!field.isStatic()) continue;
                this.staticFields.add(field);
            }
        } else {
            Debug.reportError("cannot get fields for remote class");
        }
    }
}

