/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugger.jdi;

import bluej.debugger.gentype.GenType;
import bluej.debugger.gentype.GenTypeArray;
import bluej.debugger.gentype.GenTypeBool;
import bluej.debugger.gentype.GenTypeByte;
import bluej.debugger.gentype.GenTypeChar;
import bluej.debugger.gentype.GenTypeClass;
import bluej.debugger.gentype.GenTypeDouble;
import bluej.debugger.gentype.GenTypeFloat;
import bluej.debugger.gentype.GenTypeInt;
import bluej.debugger.gentype.GenTypeLong;
import bluej.debugger.gentype.GenTypeShort;
import bluej.debugger.gentype.Reflective;
import bluej.debugger.jdi.JdiReflective;
import com.sun.jdi.ReferenceType;

public class JdiArrayReflective
extends JdiReflective {
    private GenType componentType;

    public JdiArrayReflective(GenType t, ReferenceType srctype) {
        super(null, srctype);
        this.componentType = t;
    }

    public String getName() {
        this.checkLoaded();
        return super.getName();
    }

    protected void checkLoaded() {
        this.name = "[" + this.componentName();
        super.checkLoaded();
    }

    private String componentName() {
        if (this.componentType instanceof GenTypeBool) {
            return "Z";
        }
        if (this.componentType instanceof GenTypeByte) {
            return "B";
        }
        if (this.componentType instanceof GenTypeChar) {
            return "C";
        }
        if (this.componentType instanceof GenTypeDouble) {
            return "D";
        }
        if (this.componentType instanceof GenTypeFloat) {
            return "F";
        }
        if (this.componentType instanceof GenTypeInt) {
            return "I";
        }
        if (this.componentType instanceof GenTypeLong) {
            return "J";
        }
        if (this.componentType instanceof GenTypeShort) {
            return "S";
        }
        if (this.componentType instanceof GenTypeArray) {
            Reflective r = ((GenTypeArray)this.componentType).getReflective();
            return r.getName();
        }
        GenTypeClass gtc = (GenTypeClass)this.componentType;
        return "L" + gtc.rawName() + ";";
    }
}

