/*
 * Decompiled with CFR 0.152.
 */
package bluej.compiler;

import bluej.Config;
import bluej.compiler.CompileObserver;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

abstract class Compiler {
    public static final String COMPILER_OPTIONS = "bluej.compiler.options";
    private File destDir;
    private String classPath;
    private boolean debug;
    private boolean deprecation;

    Compiler() {
    }

    public void setDestDir(File destDir) {
        this.destDir = destDir;
    }

    public void setClassPath(String classPath) {
        this.classPath = classPath;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setDeprecation(boolean deprecation) {
        this.deprecation = deprecation;
    }

    public String getClassPath() {
        return this.classPath;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public boolean isDeprecation() {
        return this.deprecation;
    }

    public File getDestDir() {
        return this.destDir;
    }

    protected List getCompileOptions() {
        ArrayList<String> args = new ArrayList<String>();
        if (this.getDestDir() != null) {
            args.add("-d");
            args.add(this.getDestDir().getPath());
        }
        if (this.getClassPath() != null) {
            args.add("-classpath");
            args.add(this.getClassPath());
        }
        if (this.isDebug()) {
            args.add("-g");
        }
        if (this.isDeprecation()) {
            args.add("-deprecation");
        }
        String majorVersion = System.getProperty("java.vm.version").substring(0, 3);
        args.add("-source");
        args.add(majorVersion);
        if (Config.systemContainsKey(COMPILER_OPTIONS)) {
            this.addUserSpecifiedOptions(args);
        }
        return args;
    }

    private void addUserSpecifiedOptions(List args) {
        String compilerOptions = Config.getPropString(COMPILER_OPTIONS, null);
        if (compilerOptions != null) {
            StringTokenizer st = new StringTokenizer(compilerOptions);
            while (st.hasMoreTokens()) {
                args.add(st.nextToken());
            }
        }
    }

    public abstract boolean compile(File[] var1, CompileObserver var2, boolean var3);
}

