/*
 * Decompiled with CFR 0.152.
 */
package bluej.classmgr;

import bluej.classmgr.ClassPathEntry;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ClassPath {
    private ArrayList entries = new ArrayList();

    public ClassPath() {
    }

    public ClassPath(ClassPath classpath) {
        this.addClassPath(classpath);
    }

    public ClassPath(String classpath, String genericdescription) {
        this.addClassPath(classpath, genericdescription);
    }

    public ClassPath(URL[] urls) {
        for (int i = 0; i < urls.length; ++i) {
            ClassPathEntry cpe = new ClassPathEntry(urls[i].getFile(), "");
            if (this.entries.contains(cpe)) continue;
            this.entries.add(cpe);
        }
    }

    protected List getEntries() {
        return this.entries;
    }

    public List getPathEntries() {
        return Collections.unmodifiableList(this.entries);
    }

    public void removeClassPath(String classpath) {
        try {
            StringTokenizer st = new StringTokenizer(classpath, File.pathSeparator);
            while (st.hasMoreTokens()) {
                String entry = st.nextToken();
                this.entries.remove(entry);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void removeAll() {
        this.entries.clear();
    }

    public void addClassPath(ClassPath classpath) {
        Iterator it = classpath.entries.iterator();
        while (it.hasNext()) {
            ClassPathEntry nextEntry = (ClassPathEntry)it.next();
            try {
                ClassPathEntry cpentry = (ClassPathEntry)nextEntry.clone();
                if (this.entries.contains(cpentry)) continue;
                this.entries.add(cpentry);
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
        }
    }

    public void addClassPath(String classpath, String genericdescription) {
        if (classpath == null) {
            return;
        }
        try {
            StringTokenizer st = new StringTokenizer(classpath, File.pathSeparator);
            while (st.hasMoreTokens()) {
                String entry = st.nextToken();
                ClassPathEntry cpentry = new ClassPathEntry(entry, genericdescription);
                if (this.entries.contains(cpentry)) continue;
                this.entries.add(cpentry);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public URL[] getURLs() {
        Iterator it = this.entries.iterator();
        URL[] u = new URL[this.entries.size()];
        int current = 0;
        while (it.hasNext()) {
            ClassPathEntry nextEntry = (ClassPathEntry)it.next();
            try {
                u[current] = nextEntry.getURL();
            }
            catch (MalformedURLException mue) {
                // empty catch block
            }
            ++current;
        }
        return u;
    }

    public InputStream getFile(String filename) throws IOException {
        Iterator it = this.entries.iterator();
        while (it.hasNext()) {
            File fd;
            ClassPathEntry nextEntry = (ClassPathEntry)it.next();
            if (nextEntry.isJar()) {
                InputStream ret = this.readJar(nextEntry.getFile(), filename);
                if (ret == null) continue;
                return ret;
            }
            if (!nextEntry.isClassRoot() || !(fd = new File(nextEntry.getFile(), filename)).exists()) continue;
            return new FileInputStream(fd);
        }
        return null;
    }

    private InputStream readJar(File classjar, String filename) throws IOException {
        JarEntry entry;
        JarFile jarf = new JarFile(classjar);
        if (File.separatorChar != '/') {
            filename = filename.replace(File.separatorChar, '/');
        }
        if ((entry = jarf.getJarEntry(filename)) == null) {
            return null;
        }
        InputStream is = jarf.getInputStream(entry);
        return is;
    }

    public String toString() {
        return this.asList(File.pathSeparatorChar, false);
    }

    public String asList(char separator, boolean useURL) {
        StringBuffer buf = new StringBuffer();
        Iterator it = this.entries.iterator();
        while (it.hasNext()) {
            ClassPathEntry nextEntry = (ClassPathEntry)it.next();
            if (useURL) {
                try {
                    buf.append(nextEntry.getURL());
                }
                catch (MalformedURLException e) {}
            } else {
                buf.append(nextEntry.getPath());
            }
            if (!it.hasNext()) continue;
            buf.append(separator);
        }
        return buf.toString();
    }
}

