/*
 * Decompiled with CFR 0.152.
 */
package bluej.classmgr;

import bluej.Boot;
import bluej.Config;
import bluej.classmgr.ClassPath;
import bluej.classmgr.ClassPathEntry;
import bluej.classmgr.ProjectClassLoader;
import bluej.utility.Debug;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.MissingResourceException;

public class ClassMgr {
    private static final String errormissingclasspath = Config.getString("classmgr.error.missingclasspath");
    private static final String errormissingbootclasspath = Config.getString("classmgr.error.missingbootclasspath");
    private static final String userlibPrefix = "bluej.userlibrary";
    private static ClassMgr currentClassMgr = new ClassMgr();
    private BlueJLoader bluejloader = new BlueJLoader();
    protected ClassPath bootLibraries;
    protected ClassPath systemLibraries;
    protected ClassPath userLibraries;
    protected ClassPath userlibExtLibraries;

    public static ClassMgr getClassMgr() {
        return currentClassMgr;
    }

    public static ProjectClassLoader getProjectLoader(File projectDir) {
        return new ProjectClassLoader(projectDir, (ClassLoader)ClassMgr.getClassMgr().bluejloader);
    }

    private ClassMgr() {
        URL[] bootcp = Boot.getInstance().getRuntimeClassPath();
        URL[] syscp = Boot.getInstance().getRuntimeUserClassPath();
        URL[] userextcp = Boot.getInstance().getUserLibClassPath();
        String envcp = System.getProperty("java.class.path");
        if (bootcp == null) {
            Debug.message(errormissingbootclasspath);
        } else if (envcp == null) {
            Debug.message(errormissingclasspath);
        }
        this.bootLibraries = new ClassPath(bootcp);
        this.systemLibraries = new ClassPath(syscp);
        this.userLibraries = new ClassPath();
        this.userlibExtLibraries = new ClassPath(userextcp);
        this.addConfigEntries(this.userLibraries, userlibPrefix);
        if (envcp != null) {
            this.bootLibraries.addClassPath(envcp, "");
        }
    }

    public ClassPath getAllClassPath() {
        ClassPath all = new ClassPath();
        all.addClassPath(this.systemLibraries);
        all.addClassPath(this.userLibraries);
        all.addClassPath(this.userlibExtLibraries);
        all.addClassPath(this.bootLibraries);
        return all;
    }

    public ClassPath getUserClassPath() {
        ClassPath usercp = new ClassPath();
        usercp.addClassPath(this.userlibExtLibraries);
        usercp.addClassPath(this.userLibraries);
        return usercp;
    }

    private void addConfigEntries(ClassPath cp, String prefix) {
        int resourceID = 1;
        try {
            String location;
            while ((location = Config.getPropString(prefix + resourceID + ".location", null)) != null) {
                cp.addClassPath(location, "");
                ++resourceID;
            }
        }
        catch (MissingResourceException mre) {
            // empty catch block
        }
    }

    protected void saveUserLibraries() {
        String r1;
        int resourceID = 1;
        while ((r1 = Config.removeProperty(userlibPrefix + resourceID + ".location")) != null) {
            ++resourceID;
        }
        Iterator it = this.userLibraries.getEntries().iterator();
        resourceID = 1;
        while (it.hasNext()) {
            ClassPathEntry nextEntry = (ClassPathEntry)it.next();
            Config.putPropString(userlibPrefix + resourceID + ".location", nextEntry.getPath());
            ++resourceID;
        }
    }

    class BlueJLoader
    extends ClassLoader {
        BlueJLoader() {
        }

        protected Class findClass(String name) throws ClassNotFoundException {
            byte[] bytes = this.loadClassData(name);
            if (bytes != null) {
                return this.defineClass(name, bytes, 0, bytes.length);
            }
            throw new ClassNotFoundException("BlueJLoader");
        }

        protected byte[] loadClassData(String name) {
            ByteArrayOutputStream classdata = new ByteArrayOutputStream();
            try {
                String filename = name.replace('.', File.separatorChar) + ".class";
                InputStream in = null;
                try {
                    in = ClassMgr.this.systemLibraries.getFile(filename);
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                if (in == null) {
                    try {
                        in = ClassMgr.this.userlibExtLibraries.getFile(filename);
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                }
                if (in == null) {
                    try {
                        in = ClassMgr.this.userLibraries.getFile(filename);
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                }
                if (in != null) {
                    int b;
                    BufferedInputStream bufin = new BufferedInputStream(in);
                    while ((b = bufin.read()) != -1) {
                        classdata.write(b);
                    }
                }
            }
            catch (Exception e) {
                Debug.reportError("Exception attempting to load class " + name + ": " + e);
                return null;
            }
            if (classdata.size() == 0) {
                return null;
            }
            return classdata.toByteArray();
        }
    }
}

