/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.syntax;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import javax.swing.JEditorPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import javax.swing.text.Segment;
import javax.swing.text.TextAction;
import org.gjt.sp.jedit.syntax.SyntaxDocument;
import org.gjt.sp.jedit.syntax.SyntaxEditorKit;
import org.gjt.sp.jedit.syntax.SyntaxUtilities;
import org.gjt.sp.jedit.syntax.TokenMarker;

public class SyntaxTextArea
extends JEditorPane {
    public static final EditorKit EDITOR_KIT = new SyntaxEditorKit();
    private Color lineHighlightColor;
    private Object lineHighlightTag;
    private Color bracketHighlightColor;
    private Object bracketHighlightTag;
    private int electricLines;
    private boolean block;
    private boolean overwrite;
    private Segment lineSegment;
    private int lastLine = -1;
    private int lastBracket = -1;
    private static boolean keymapInitialized;

    public SyntaxTextArea() {
        this.setCaret(new SyntaxCaret());
        this.setBorder(null);
        this.setCursor(Cursor.getPredefinedCursor(2));
        this.lineHighlightColor = new Color(0xE0E0E0);
        this.bracketHighlightColor = new Color(65280);
        this.lineSegment = new Segment();
        this.addCaretListener(new CaretHandler());
        if (!keymapInitialized) {
            Keymap map = JTextComponent.getKeymap("default");
            map.setDefaultAction(new DefaultKeyTypedAction());
            map.addActionForKeyStroke(KeyStroke.getKeyStroke(155, 0), new InsertKeyAction());
            keymapInitialized = true;
        }
    }

    public EditorKit createDefaultEditorKit() {
        return EDITOR_KIT;
    }

    public void setHighlightedLine(int lineStart, int lineEnd) {
        if (this.lineHighlightTag == null) {
            return;
        }
        try {
            this.getHighlighter().changeHighlight(this.lineHighlightTag, lineStart, lineEnd);
        }
        catch (BadLocationException bl) {
            bl.printStackTrace();
        }
    }

    public void setLineHighlightColor(Color color) {
        this.lineHighlightColor = color;
    }

    public Color getLineHighlightColor() {
        return this.lineHighlightColor;
    }

    public void setLineHighlight(boolean lineHighlight) {
        if (this.lineHighlightTag != null) {
            if (lineHighlight) {
                return;
            }
            this.getHighlighter().removeHighlight(this.lineHighlightTag);
            this.lineHighlightTag = null;
        } else if (lineHighlight) {
            try {
                this.lineHighlightTag = this.getHighlighter().addHighlight(0, 0, new CurrentLineHighlighter());
            }
            catch (BadLocationException bl) {
                bl.printStackTrace();
            }
        }
    }

    public boolean getLineHighlight() {
        return this.lineHighlightTag != null;
    }

    public void setHighlightedBracket(int bracketPos) {
        if (this.bracketHighlightTag == null) {
            return;
        }
        if (bracketPos == this.lastBracket) {
            return;
        }
        this.lastBracket = bracketPos;
        try {
            if (bracketPos == -1) {
                this.getHighlighter().changeHighlight(this.bracketHighlightTag, 0, 0);
            } else {
                this.getHighlighter().changeHighlight(this.bracketHighlightTag, bracketPos, bracketPos + 1);
            }
        }
        catch (BadLocationException bl) {
            bl.printStackTrace();
        }
    }

    public void setBracketHighlightColor(Color color) {
        this.bracketHighlightColor = color;
    }

    public Color getBracketHighlightColor() {
        return this.bracketHighlightColor;
    }

    public void setBracketHighlight(boolean bracketHighlight) {
        if (this.bracketHighlightTag != null) {
            if (bracketHighlight) {
                return;
            }
            this.getHighlighter().removeHighlight(this.bracketHighlightTag);
            this.bracketHighlightTag = null;
        } else if (bracketHighlight) {
            try {
                this.bracketHighlightTag = this.getHighlighter().addHighlight(0, 0, new BracketHighlighter());
            }
            catch (BadLocationException bl) {
                bl.printStackTrace();
            }
        }
    }

    public boolean getBracketHighlight() {
        return this.bracketHighlightTag != null;
    }

    public void setElectricBorders(int lines) {
        this.electricLines = lines;
    }

    public int getElectricBorders() {
        return this.electricLines;
    }

    public void setBlockCaret(boolean block) {
        this.block = block;
    }

    public boolean getBlockCaret() {
        return this.block;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public boolean getOverwrite(boolean overwrite) {
        return overwrite;
    }

    public void toggleOverwrite() {
        this.overwrite = !this.overwrite;
    }

    public void updateHighlighters() {
        Document doc = this.getDocument();
        int dot = this.getCaretPosition();
        Element map = doc.getDefaultRootElement();
        int lineNo = map.getElementIndex(dot);
        Element lineElement = map.getElement(lineNo);
        int start = lineElement.getStartOffset();
        int end = lineElement.getEndOffset();
        if (this.getSelectionStart() == this.getSelectionEnd() && lineNo != this.lastLine) {
            this.setHighlightedLine(start, end);
            this.lastLine = lineNo;
        }
        try {
            if (dot != 0) {
                int otherBracket;
                doc.getText(--dot, 1, this.lineSegment);
                char bracket = this.lineSegment.array[this.lineSegment.offset];
                switch (bracket) {
                    case '(': {
                        otherBracket = SyntaxUtilities.locateBracketForward(doc, dot, '(', ')');
                        break;
                    }
                    case ')': {
                        otherBracket = SyntaxUtilities.locateBracketBackward(doc, dot, '(', ')');
                        break;
                    }
                    case '[': {
                        otherBracket = SyntaxUtilities.locateBracketForward(doc, dot, '[', ']');
                        break;
                    }
                    case ']': {
                        otherBracket = SyntaxUtilities.locateBracketBackward(doc, dot, '[', ']');
                        break;
                    }
                    case '{': {
                        otherBracket = SyntaxUtilities.locateBracketForward(doc, dot, '{', '}');
                        break;
                    }
                    case '}': {
                        otherBracket = SyntaxUtilities.locateBracketBackward(doc, dot, '{', '}');
                        break;
                    }
                    default: {
                        otherBracket = -1;
                    }
                }
                this.setHighlightedBracket(otherBracket);
            } else {
                this.setHighlightedBracket(-1);
            }
        }
        catch (BadLocationException bl) {
            // empty catch block
        }
    }

    public void setDocument(Document doc) {
        if (!(doc instanceof SyntaxDocument)) {
            throw new IllegalArgumentException("Document is not an instance of SyntaxDocument");
        }
        super.setDocument(doc);
    }

    public void setText(String text) {
        Document doc = this.getDocument();
        try {
            doc.remove(0, doc.getLength());
            doc.insertString(0, text, null);
        }
        catch (BadLocationException bl) {
            throw new InternalError("setText() fuckup");
        }
    }

    public SyntaxDocument getSyntaxDocument() {
        return (SyntaxDocument)this.getDocument();
    }

    public TokenMarker getTokenMarker() {
        return this.getSyntaxDocument().getTokenMarker();
    }

    public void setTokenMarker(TokenMarker tm) {
        this.getSyntaxDocument().setTokenMarker(tm);
    }

    public Color[] getColors() {
        return this.getSyntaxDocument().getColors();
    }

    public void setColors(Color[] colors) {
        this.getSyntaxDocument().setColors(colors);
    }

    public void tokenizeLines() {
        this.getSyntaxDocument().tokenizeLines();
    }

    public void tokenizeLines(int start, int len) {
        this.getSyntaxDocument().tokenizeLines(start, len);
    }

    public void doElectricScroll(Rectangle rect) {
        SwingUtilities.invokeLater(new SyntaxSafeScroller(rect));
    }

    private void _replaceSelection(String content) {
        if (!this.overwrite || this.getSelectionStart() != this.getSelectionEnd()) {
            this.replaceSelection(content);
            return;
        }
        int caret = this.getCaretPosition();
        Document doc = this.getDocument();
        Element map = doc.getDefaultRootElement();
        Element line = map.getElement(map.getElementIndex(caret));
        if (line.getEndOffset() - caret <= content.length()) {
            this.replaceSelection(content);
            return;
        }
        try {
            doc.remove(caret, content.length());
            doc.insertString(caret, content, null);
        }
        catch (BadLocationException bl) {
            bl.printStackTrace();
        }
    }

    class CaretHandler
    implements CaretListener {
        CaretHandler() {
        }

        public void caretUpdate(CaretEvent evt) {
            SyntaxTextArea.this.updateHighlighters();
        }
    }

    class BracketHighlighter
    implements Highlighter.HighlightPainter {
        BracketHighlighter() {
        }

        public void paint(Graphics g, int p0, int p1, Shape bounds, JTextComponent textComponent) {
            Rectangle bracket;
            if (SyntaxTextArea.this.getSelectionStart() != SyntaxTextArea.this.getSelectionEnd() || SyntaxTextArea.this.bracketHighlightTag == null) {
                return;
            }
            if (p0 == p1) {
                return;
            }
            Document doc = SyntaxTextArea.this.getDocument();
            FontMetrics metrics = g.getFontMetrics();
            try {
                bracket = SyntaxTextArea.this.modelToView(p0);
                doc.getText(p0, 1, SyntaxTextArea.this.lineSegment);
                bracket.width += metrics.charWidth(((SyntaxTextArea)SyntaxTextArea.this).lineSegment.array[((SyntaxTextArea)SyntaxTextArea.this).lineSegment.offset]);
            }
            catch (BadLocationException bl) {
                bl.printStackTrace();
                return;
            }
            g.setColor(SyntaxTextArea.this.bracketHighlightColor);
            g.fillRect(bracket.x, bracket.y, bracket.width, bracket.height);
        }
    }

    class CurrentLineHighlighter
    implements Highlighter.HighlightPainter {
        CurrentLineHighlighter() {
        }

        public void paint(Graphics g, int p0, int p1, Shape bounds, JTextComponent textComponent) {
            if (SyntaxTextArea.this.lineHighlightTag == null || SyntaxTextArea.this.getSelectionStart() != SyntaxTextArea.this.getSelectionEnd()) {
                return;
            }
            FontMetrics metrics = g.getFontMetrics();
            Document doc = SyntaxTextArea.this.getDocument();
            int lineNo = doc.getDefaultRootElement().getElementIndex(p0);
            Rectangle rect = (Rectangle)bounds;
            int height = metrics.getHeight();
            int x = rect.x;
            int y = rect.y + height * lineNo;
            g.setColor(SyntaxTextArea.this.lineHighlightColor);
            g.fillRect(x, y, rect.width, height);
        }
    }

    class SyntaxSafeScroller
    implements Runnable {
        public Rectangle rect;

        public SyntaxSafeScroller(Rectangle rect) {
            this.rect = rect;
        }

        public void run() {
            int lines;
            int height = SyntaxTextArea.this.getFontMetrics(SyntaxTextArea.this.getFont()).getHeight();
            int y = Math.max(0, this.rect.y - height * SyntaxTextArea.this.electricLines);
            if (y + (lines = height * SyntaxTextArea.this.electricLines * 2) + this.rect.height <= SyntaxTextArea.this.getHeight()) {
                this.rect.y = y;
                this.rect.height += lines;
            }
            SyntaxTextArea.this.scrollRectToVisible(this.rect);
        }
    }

    class SyntaxCaret
    extends DefaultCaret {
        SyntaxCaret() {
        }

        public void focusGained(FocusEvent evt) {
            this.setVisible(true);
        }

        public void adjustVisibility(Rectangle rect) {
            SyntaxTextArea.this.doElectricScroll(rect);
        }

        public void damage(Rectangle r) {
            if (r != null) {
                this.x = r.x;
                this.y = r.y;
                this.height = r.height + 2;
                this.repaint();
            }
        }

        public void paint(Graphics g) {
            if (this.getDot() != this.getMark() || !this.isVisible()) {
                return;
            }
            try {
                int dot = this.getDot();
                Rectangle r = SyntaxTextArea.this.modelToView(dot);
                this.width = g.getFontMetrics().charWidth('m');
                r.width = SyntaxTextArea.this.overwrite || SyntaxTextArea.this.block ? this.width - 1 : 0;
                this.width += 2;
                if (SyntaxTextArea.this.overwrite) {
                    r.y += r.height - 1;
                    r.height = 1;
                }
                g.setColor(SyntaxTextArea.this.getCaretColor());
                g.drawRect(r.x, r.y, r.width, r.height - 1);
            }
            catch (BadLocationException bl) {
                System.out.println("Caret fuckup:");
                bl.printStackTrace();
            }
        }
    }

    static class InsertKeyAction
    extends TextAction {
        public InsertKeyAction() {
            super("insert-key");
        }

        public void actionPerformed(ActionEvent evt) {
            JTextComponent comp = this.getTextComponent(evt);
            if (comp instanceof SyntaxTextArea) {
                ((SyntaxTextArea)comp).toggleOverwrite();
                comp.repaint();
            }
        }
    }

    static class DefaultKeyTypedAction
    extends TextAction {
        public DefaultKeyTypedAction() {
            super("syntax-default-key-typed-action");
        }

        public void actionPerformed(ActionEvent evt) {
            char c;
            JTextComponent comp = this.getTextComponent(evt);
            String content = evt.getActionCommand();
            int modifiers = evt.getModifiers();
            if (content != null && content.length() != 0 && (modifiers & 8) == 0 && (c = content.charAt(0)) >= ' ' && c != '\u007f') {
                if (comp instanceof SyntaxTextArea) {
                    ((SyntaxTextArea)comp)._replaceSelection(content);
                } else {
                    comp.replaceSelection(content);
                }
            }
        }
    }
}

