/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.syntax;

import javax.swing.text.Segment;
import org.gjt.sp.jedit.syntax.JavaScriptTokenMarker;
import org.gjt.sp.jedit.syntax.KeywordMap;
import org.gjt.sp.jedit.syntax.SyntaxUtilities;
import org.gjt.sp.jedit.syntax.TokenMarker;

public class HTMLTokenMarker
extends TokenMarker {
    public static final byte JAVASCRIPT = 100;
    private KeywordMap keywords = JavaScriptTokenMarker.getKeywords();

    public byte markTokensImpl(byte token, Segment line, int lineIndex) {
        int len;
        byte id;
        int offset;
        char[] array = line.array;
        boolean backslash = false;
        int lastOffset = offset = line.offset;
        int lastKeyword = offset;
        int length = line.count + offset;
        block17: for (int i = offset; i < length; ++i) {
            int i1 = i + 1;
            switch (array[i]) {
                case '\\': {
                    backslash = !backslash;
                    continue block17;
                }
                case ';': {
                    if (token == 8) {
                        token = 0;
                        this.addToken(i1 - lastOffset, (byte)8);
                        lastOffset = i1;
                        continue block17;
                    }
                }
                case '*': {
                    if (token == 2 && length - i > 1 && length - i > 1 && array[i1] == '/') {
                        backslash = false;
                        token = (byte)100;
                        ++i;
                        this.addToken(i1 - lastOffset, (byte)2);
                        lastOffset = i1;
                        continue block17;
                    }
                }
                case ':': {
                    if (token == 100 && lastKeyword == offset) {
                        backslash = false;
                        this.addToken(i1 - lastOffset, (byte)6);
                        lastOffset = i1;
                        continue block17;
                    }
                }
                case '\t': 
                case ' ': 
                case '(': 
                case ')': 
                case ',': 
                case '.': 
                case '[': 
                case ']': 
                case '{': 
                case '}': {
                    backslash = false;
                    if (token != 100) continue block17;
                    int len2 = i - lastKeyword;
                    byte id2 = this.keywords.lookup(line, lastKeyword, len2);
                    if (id2 != 0) {
                        if (lastKeyword != lastOffset) {
                            this.addToken(lastKeyword - lastOffset, (byte)0);
                        }
                        this.addToken(len2, id2);
                        lastOffset = i;
                    }
                    lastKeyword = i1;
                    continue block17;
                }
                case '<': {
                    backslash = false;
                    if (token == 0) {
                        token = SyntaxUtilities.regionMatches(false, line, i, "<!--") ? (byte)1 : (byte)7;
                        this.addToken(i - lastOffset, (byte)0);
                        lastOffset = i;
                        continue block17;
                    }
                    if (token != 100 || !SyntaxUtilities.regionMatches(true, line, i, "</SCRIPT>")) continue block17;
                    token = (byte)7;
                    this.addToken(i - lastOffset, (byte)0);
                    lastOffset = i;
                    continue block17;
                }
                case '>': {
                    backslash = false;
                    if (token == 7) {
                        token = SyntaxUtilities.regionMatches(true, line, lastOffset, "<SCRIPT") ? (byte)100 : (byte)0;
                        this.addToken(i1 - lastOffset, (byte)7);
                        lastOffset = i1;
                        continue block17;
                    }
                    if (token != 1 || !SyntaxUtilities.regionMatches(false, line, i - 2, "-->")) continue block17;
                    token = 0;
                    this.addToken(i1 - lastOffset, (byte)1);
                    lastOffset = i1;
                    continue block17;
                }
                case '&': {
                    backslash = false;
                    if (token != 0) continue block17;
                    token = (byte)8;
                    this.addToken(i - lastOffset, (byte)0);
                    lastOffset = i;
                    continue block17;
                }
                case '/': {
                    backslash = false;
                    if (token != 100 || length - i <= 1) continue block17;
                    switch (array[i1]) {
                        case '*': {
                            token = (byte)2;
                            this.addToken(i - lastOffset, (byte)0);
                            lastOffset = i++;
                            break;
                        }
                        case '/': {
                            this.addToken(i - lastOffset, (byte)0);
                            this.addToken(length - i, (byte)2);
                            lastOffset = length;
                            break block17;
                        }
                    }
                    continue block17;
                }
                case '\"': {
                    if (backslash) {
                        backslash = false;
                        continue block17;
                    }
                    if (token == 100) {
                        token = (byte)4;
                        this.addToken(i - lastOffset, (byte)0);
                        lastOffset = i;
                        continue block17;
                    }
                    if (token != 4) continue block17;
                    token = (byte)100;
                    this.addToken(i1 - lastOffset, (byte)4);
                    lastOffset = i1;
                    continue block17;
                }
                case '\'': {
                    if (backslash) {
                        backslash = false;
                        continue block17;
                    }
                    if (token == 100) {
                        token = (byte)5;
                        this.addToken(i - lastOffset, (byte)0);
                        lastOffset = i;
                        continue block17;
                    }
                    if (token != 5) continue block17;
                    token = (byte)100;
                    this.addToken(i1 - lastOffset, (byte)4);
                    lastOffset = i1;
                    continue block17;
                }
                default: {
                    backslash = false;
                }
            }
        }
        if (token == 100 && (id = this.keywords.lookup(line, lastKeyword, len = length - lastKeyword)) != 0) {
            if (lastKeyword != lastOffset) {
                this.addToken(lastKeyword - lastOffset, (byte)0);
            }
            this.addToken(len, id);
            lastOffset = length;
        }
        if (lastOffset != length) {
            if (token == 4 || token == 5) {
                this.addToken(length - lastOffset, (byte)11);
                token = (byte)100;
            } else if (token == 8) {
                this.addToken(length - lastOffset, (byte)11);
                token = 0;
            } else if (token == 100) {
                this.addToken(length - lastOffset, (byte)0);
            } else {
                this.addToken(length - lastOffset, token);
            }
        }
        return token;
    }
}

