/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.moe;

import bluej.Config;
import bluej.editor.moe.BlueJSyntaxView;
import bluej.prefmgr.PrefMgr;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.text.Element;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;
import org.gjt.sp.jedit.syntax.SyntaxDocument;
import org.gjt.sp.jedit.syntax.TokenMarker;

public class MoeSyntaxView
extends BlueJSyntaxView {
    public static final String BREAKPOINT = "break";
    public static final String STEPMARK = "step";
    static final Image breakImage = Config.getImageAsIcon((String)"image.editor.breakmark").getImage();
    static final Image stepImage = Config.getImageAsIcon((String)"image.editor.stepmark").getImage();
    static final Image breakStepImage = Config.getImageAsIcon((String)"image.editor.breakstepmark").getImage();

    public MoeSyntaxView(Element elem) {
        super(elem);
    }

    public void paintTaggedLine(Segment lineText, int lineIndex, Graphics g, int x, int y, SyntaxDocument document, TokenMarker tokenMarker, Color def, Element line) {
        if (PrefMgr.getFlag((String)"bluej.editor.displayLineNumbers")) {
            this.drawLineNumber(g, lineIndex + 1, x, y);
        }
        if (this.hasTag(line, BREAKPOINT)) {
            if (this.hasTag(line, STEPMARK)) {
                g.drawImage(breakStepImage, x - 1, y + 3 - breakStepImage.getHeight(null), null);
            } else {
                g.drawImage(breakImage, x - 1, y + 3 - breakImage.getHeight(null), null);
            }
        } else if (this.hasTag(line, STEPMARK)) {
            g.drawImage(stepImage, x - 1, y + 3 - stepImage.getHeight(null), null);
        }
        if (tokenMarker == null) {
            Utilities.drawTabbedText(lineText, x + 16, y, g, (TabExpander)this, 0);
        } else {
            this.paintSyntaxLine(lineText, lineIndex, x + 16, y, g, document, tokenMarker, def);
        }
    }

    public void paint(Graphics g, Shape allocation) {
        Rectangle bounds = allocation.getBounds();
        if (Boolean.FALSE.equals(this.getDocument().getProperty("compiled"))) {
            g.setColor(Color.lightGray);
            g.fillRect(0, 0, bounds.x + 14, bounds.y + bounds.height);
        }
        super.paint(g, allocation);
        g.setColor(Color.black);
        g.drawLine(bounds.x + 14, 0, bounds.x + 14, bounds.y + bounds.height);
    }
}

