/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.moe;

import bluej.BlueJTheme;
import bluej.Config;
import bluej.editor.EditorManager;
import bluej.prefmgr.PrefMgr;
import bluej.prefmgr.PrefPanelListener;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class EditorPrefPanel
extends JPanel
implements PrefPanelListener {
    private JTextField editorFontField;
    private JCheckBox hilightingBox;
    private JCheckBox autoIndentBox;
    private JCheckBox lineNumbersBox;
    private JCheckBox makeBackupBox;
    private JCheckBox showTestBox;
    private JCheckBox matchBracketsBox;

    public EditorPrefPanel() {
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(BlueJTheme.generalBorder);
        JPanel editorPanel = new JPanel(new GridLayout(4, 2, 0, 0));
        String editorTitle = Config.getString((String)"prefmgr.edit.editor.title");
        editorPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(editorTitle), BlueJTheme.generalBorder));
        editorPanel.setAlignmentX(0.0f);
        JPanel fontPanel = new JPanel(new FlowLayout(0, 5, 0));
        fontPanel.add(new JLabel(Config.getString((String)"prefmgr.edit.editorfontsize")));
        this.editorFontField = new JTextField(4);
        fontPanel.add(this.editorFontField);
        editorPanel.add(fontPanel);
        editorPanel.add(new JLabel(" "));
        this.autoIndentBox = new JCheckBox(Config.getString((String)"prefmgr.edit.autoindent"));
        editorPanel.add(this.autoIndentBox);
        this.lineNumbersBox = new JCheckBox(Config.getString((String)"prefmgr.edit.displaylinenumbers"));
        editorPanel.add(this.lineNumbersBox);
        this.hilightingBox = new JCheckBox(Config.getString((String)"prefmgr.edit.usesyntaxhilighting"));
        editorPanel.add(this.hilightingBox);
        this.makeBackupBox = new JCheckBox(Config.getString((String)"prefmgr.edit.makeBackup"));
        editorPanel.add(this.makeBackupBox);
        this.matchBracketsBox = new JCheckBox(Config.getString((String)"prefmgr.edit.matchBrackets"));
        editorPanel.add(this.matchBracketsBox);
        this.add(editorPanel);
        this.add(Box.createVerticalStrut(5));
        this.add(Box.createVerticalGlue());
        this.add(Box.createVerticalGlue());
        this.add(Box.createVerticalGlue());
    }

    public void beginEditing() {
        this.editorFontField.setText(String.valueOf(PrefMgr.getEditorFontSize()));
        this.hilightingBox.setSelected(PrefMgr.getFlag((String)"bluej.editor.syntaxHilighting"));
        this.autoIndentBox.setSelected(PrefMgr.getFlag((String)"bluej.editor.autoIndent"));
        this.lineNumbersBox.setSelected(PrefMgr.getFlag((String)"bluej.editor.displayLineNumbers"));
        this.makeBackupBox.setSelected(PrefMgr.getFlag((String)"bluej.editor.makeBackup"));
        this.matchBracketsBox.setSelected(PrefMgr.getFlag((String)"bluej.editor.matchBrackets"));
    }

    public void revertEditing() {
    }

    public void commitEditing() {
        int newFontSize = 0;
        try {
            newFontSize = Integer.parseInt(this.editorFontField.getText());
            PrefMgr.setEditorFontSize((int)newFontSize);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        PrefMgr.setFlag((String)"bluej.editor.syntaxHilighting", (boolean)this.hilightingBox.isSelected());
        PrefMgr.setFlag((String)"bluej.editor.autoIndent", (boolean)this.autoIndentBox.isSelected());
        PrefMgr.setFlag((String)"bluej.editor.displayLineNumbers", (boolean)this.lineNumbersBox.isSelected());
        PrefMgr.setFlag((String)"bluej.editor.makeBackup", (boolean)this.makeBackupBox.isSelected());
        PrefMgr.setFlag((String)"bluej.editor.matchBrackets", (boolean)this.matchBracketsBox.isSelected());
        EditorManager.getEditorManager().refreshAll();
    }
}

